/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementBase;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public class RubyIntroduceVariableHandler
extends RubyIntroduceHandlerBase {
    @NotNull
    public static final String HELP_ID = "refactoring.introduceVariable";
    public static final BiFunction<RCompoundStatement, RCompoundStatement, RCompoundStatement> STANDARD_BODY_PRODUCER = (body1, body2) -> {
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)body1, (PsiElement)body2);
        return commonParent instanceof RCompoundStatement ? (RCompoundStatement)commonParent : RubyPsiUtilCore.getCompoundStatement((PsiElement)commonParent);
    };

    @Override
    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    protected String getTitle() {
        return RefactoringBundle.message((String)"introduce.variable.title");
    }

    @Override
    protected String getFeatureID() {
        return HELP_ID;
    }

    @Override
    protected IntroduceValidator createValidator(PsiElement element, List<PsiElement> occurrences) {
        return new MyValidator(element, occurrences);
    }

    @Override
    protected RPsiElement getSearchScope(PsiElement expression) {
        return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, ScopeHolder.class);
    }

    @Override
    protected PsiElement insertDeclaration(String name, PsiElement declaration, PsiElement expression, List<PsiElement> occurrences, boolean replaceAll) {
        return RubyIntroduceVariableHandler.insertDeclaration(declaration, expression, occurrences, replaceAll, STANDARD_BODY_PRODUCER);
    }

    public static PsiElement insertDeclaration(PsiElement declaration, PsiElement expression, List<? extends PsiElement> occurrences, boolean replaceAll, @NotNull BiFunction<? super RCompoundStatement, ? super RCompoundStatement, ? extends RCompoundStatement> bodyProducer) {
        if (bodyProducer == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        Pair<RCompoundStatement, RPsiElement> placeToInsert = RubyIntroduceVariableHandler.getPlaceForDeclaration(expression, occurrences, replaceAll, bodyProducer);
        RCompoundStatement parent = (RCompoundStatement)placeToInsert.first;
        RPsiElement anchor = (RPsiElement)placeToInsert.second;
        assert (parent != null);
        FileViewProvider viewProvider = expression.getContainingFile().getViewProvider();
        PsiElement addedElement = TemplateIntegrationUtils.getInstance().addRubyStatement(viewProvider, parent, declaration, (PsiElement)anchor, true);
        if (addedElement != null) {
            return addedElement;
        }
        return parent.addBefore(declaration, (PsiElement)anchor);
    }

    @NotNull
    public static Pair<RCompoundStatement, RPsiElement> getPlaceForDeclaration(PsiElement expression, List<? extends PsiElement> occurrences, boolean replaceAll, @NotNull BiFunction<? super RCompoundStatement, ? super RCompoundStatement, ? extends RCompoundStatement> bodyProducer) {
        if (bodyProducer == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        if (replaceAll) {
            Pair<RCompoundStatement, RPsiElement> currentPlace = Pair.create(null, null);
            for (PsiElement psiElement : occurrences) {
                currentPlace = RubyIntroduceVariableHandler.processOccurrence((RPsiElement)currentPlace.second, (RCompoundStatement)currentPlace.first, psiElement, bodyProducer);
            }
            Pair<RCompoundStatement, RPsiElement> pair = currentPlace;
            if (pair == null) {
                RubyIntroduceVariableHandler.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)RubyPsiUtilCore.getCompoundStatement((PsiElement)expression), (Object)RubyPsiUtilCore.getStatement((PsiElement)expression));
        if (pair == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    private static Pair<RCompoundStatement, RPsiElement> processOccurrence(@Nullable RPsiElement anchorStatement, @Nullable RCompoundStatement anchorCoveringBody, @NotNull PsiElement occurrence, @NotNull BiFunction<? super RCompoundStatement, ? super RCompoundStatement, ? extends RCompoundStatement> bodyProducer) {
        RCompoundStatement occurrenceCoveringBody;
        RPsiElement occurrenceCoveringStatement;
        if (occurrence == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
        if (bodyProducer == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        if ((occurrenceCoveringStatement = (RPsiElement)ObjectUtils.doIfNotNull((Object)(occurrenceCoveringBody = RubyPsiUtilCore.getCompoundStatement((PsiElement)occurrence)), body -> RubyPsiUtilCore.getStatement((RCompoundStatement)body, (PsiElement)occurrence))) == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                RubyIntroduceVariableHandler.$$$reportNull$$$0(6);
            }
            return pair;
        }
        if (anchorCoveringBody == null) {
            Pair pair = Pair.create((Object)occurrenceCoveringBody, (Object)occurrenceCoveringStatement);
            if (pair == null) {
                RubyIntroduceVariableHandler.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (anchorCoveringBody == occurrenceCoveringBody) {
            Pair pair = Pair.create((Object)anchorCoveringBody, (Object)(anchorStatement != null && RubyPsiUtilCore.isBefore((PsiElement)occurrenceCoveringStatement, (PsiElement)anchorStatement) ? occurrenceCoveringStatement : anchorStatement));
            if (pair == null) {
                RubyIntroduceVariableHandler.$$$reportNull$$$0(8);
            }
            return pair;
        }
        RCompoundStatement newCoveringBody = bodyProducer.apply((RCompoundStatement)anchorCoveringBody, (RCompoundStatement)occurrenceCoveringBody);
        RPsiElement anchorBasedNewStatement = anchorStatement != null ? RubyPsiUtilCore.getStatement((RCompoundStatement)newCoveringBody, (PsiElement)anchorStatement) : null;
        RPsiElement occurrenceBasedNewStatement = RubyPsiUtilCore.getStatement((RCompoundStatement)newCoveringBody, (PsiElement)occurrenceCoveringStatement);
        RPsiElement newAnchor = anchorBasedNewStatement == null && occurrenceBasedNewStatement == null ? null : (anchorBasedNewStatement != null && occurrenceBasedNewStatement != null ? (RubyPsiUtilCore.isBefore((PsiElement)anchorBasedNewStatement, (PsiElement)occurrenceBasedNewStatement) ? anchorBasedNewStatement : occurrenceBasedNewStatement) : (RPsiElement)ObjectUtils.chooseNotNull((Object)anchorBasedNewStatement, (Object)occurrenceBasedNewStatement));
        Pair pair = Pair.create((Object)newCoveringBody, (Object)newAnchor);
        if (pair == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Override
    protected PsiElement performReplace(@NotNull Project project, @Nullable PsiElement declaration, @NotNull RubyReplacementBase elementToReplace, @NotNull String name, boolean replaceAll) {
        if (project == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        if (elementToReplace == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        if (name == null) {
            RubyIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        RPsiElement expression = elementToReplace.getExpression();
        if (elementToReplace.isStatement() && expression != null) {
            return RefactoringPsiHelper.replaceExpression(project, (PsiElement)expression, declaration);
        }
        return super.performReplace(project, declaration, elementToReplace, name, replaceAll);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyProducer";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/variable/RubyIntroduceVariableHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/variable/RubyIntroduceVariableHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForDeclaration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processOccurrence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceForDeclaration";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processOccurrence";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performReplace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class MyValidator
    extends IntroduceValidator {
        private Set<String> myProhibitedNamesAllOccurrences;
        private Set<String> myProhibitedNamesOneOccurrence;
        private final RPsiElement myExpression;

        public MyValidator(PsiElement element, List<PsiElement> occurrences) {
            super(element, occurrences);
            this.myExpression = RControlFlowBuilder.getControlFlowNodeElement(element);
        }

        @Override
        @NlsContexts.Label
        public String check(RubyIntroduceSettings settings) {
            String name = settings.getName();
            if (settings.doReplaceAllOccurrences()) {
                if (this.myProhibitedNamesAllOccurrences == null) {
                    this.myProhibitedNamesAllOccurrences = new HashSet<String>();
                    for (PsiElement occurrence : this.myOccurrences) {
                        this.myProhibitedNamesAllOccurrences.addAll(ScopeUtil.collectScopeVariableNames(occurrence));
                    }
                }
                return this.myProhibitedNamesAllOccurrences.contains(name) ? RBundle.message((String)"refactoring.introduce.variable.scope.error") : null;
            }
            if (this.myProhibitedNamesOneOccurrence == null) {
                this.myProhibitedNamesOneOccurrence = new HashSet<String>();
                this.myProhibitedNamesOneOccurrence.addAll(ScopeUtil.collectScopeVariableNames((PsiElement)this.myExpression));
            }
            return this.myProhibitedNamesOneOccurrence.contains(name) ? RBundle.message((String)"refactoring.introduce.variable.scope.error") : null;
        }

        @Override
        public boolean isNameValid(String name) {
            return name != null && !RubyRefactoringUtil.KEYWORDS.contains(name) && TextUtil.isIdentifier((String)name);
        }

        @Override
        public String checkPossibleName(String name) {
            for (PsiElement occurrence : this.myOccurrences) {
                for (String scopeVariable : ScopeUtil.collectScopeVariableNames(occurrence)) {
                    if (!StringUtil.equals((CharSequence)scopeVariable, (CharSequence)name)) continue;
                    return RBundle.message((String)"refactoring.introduce.variable.scope.error");
                }
            }
            return null;
        }
    }
}

