/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterProcessor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementBase;

public class RubyIntroduceParameterHandler
extends RubyIntroduceHandlerBase {
    @NotNull
    private ArgumentInfo.Type myType = ArgumentInfo.Type.PREDEFINED;
    @NotNull
    public static final String HELP_ID = "refactoring.introduceParameter";

    public void setType(@NotNull ArgumentInfo.Type type) {
        if (type == null) {
            RubyIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        this.myType = type;
    }

    @Override
    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    protected String getTitle() {
        return RefactoringBundle.message((String)"introduce.parameter.title");
    }

    @Override
    protected String getFeatureID() {
        return HELP_ID;
    }

    @Override
    protected boolean isSplatAllowed() {
        return false;
    }

    @Override
    protected IntroduceValidator createValidator(PsiElement element, List<PsiElement> occurrences) {
        return new RubyIntroduceVariableHandler.MyValidator(element, occurrences);
    }

    @Override
    protected RPsiElement getSearchScope(PsiElement expression) {
        return (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, RMethod.class);
    }

    @Override
    protected PsiElement insertDeclaration(String name, PsiElement declaration, PsiElement expression, List<PsiElement> occurrences, boolean replaceAll) {
        return null;
    }

    @Override
    public void performAction(Project project, Editor editor, PsiFile file, @Nullable String name, boolean replaceAll, int position) {
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), RMethod.class);
        if (method == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.parameter.outside.method.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        if (method.getArgumentList() != null && PsiUtilCore.hasErrorElementChild((PsiElement)method.getArgumentList())) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.parameter.has.error.arguments"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        List<ArgumentInfo.Type> allowedTypes = RubyIntroduceParameterHandler.getAllowedTypes(method);
        if (allowedTypes.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.parameter.no.acceptable.type"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        super.performAction(project, editor, file, name, replaceAll, position);
    }

    @Override
    public void performActionOnElement(Project project, Editor editor, RubyReplacementBase elementToReplace, String name, boolean replaceAll) {
        RPsiElement expression = elementToReplace.getExpression();
        if (expression == null) {
            return;
        }
        List<PsiElement> occurrences = elementToReplace.getOccurrences();
        if (name != null) {
            RubyIntroduceParameterProcessor processor = new RubyIntroduceParameterProcessor(project, (PsiElement)expression, () -> this.performReplace(project, null, elementToReplace, name, replaceAll), type -> this.createArgument(elementToReplace, name, (ArgumentInfo.Type)type));
            processor.setArgumentOfType(this.myType, name);
            WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> processor.performRefactoring(processor.findUsages()), (PsiFile[])new PsiFile[0]);
        } else {
            IntroduceValidator validator = this.createValidator((PsiElement)expression, occurrences);
            RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)elementToReplace.getElement(), RMethod.class);
            assert (method != null) : "Element is not in the method";
            ReadAction.nonBlocking(() -> Pair.create(this.getSuggestedNames((PsiElement)expression, validator), RubyIntroduceParameterHandler.getAllowedTypes(method))).finishOnUiThread(ModalityState.defaultModalityState(), namesAndTypes -> {
                List names = (List)namesAndTypes.getFirst();
                List types = (List)namesAndTypes.getSecond();
                Ref ref = new Ref();
                RubyIntroduceParameterDialog dialog = new RubyIntroduceParameterDialog(project, (PsiElement)expression, occurrences, validator, ArrayUtilRt.toStringArray((Collection)names), () -> {
                    RubyIntroduceParameterDialog dialog1 = (RubyIntroduceParameterDialog)((Object)((Object)((Object)ref.get())));
                    this.performReplace(project, null, elementToReplace, dialog1.getName(), dialog1.doReplaceAllOccurrences());
                }, type -> this.createArgument(elementToReplace, ((RubyIntroduceParameterDialog)((Object)((Object)((Object)ref.get())))).getName(), (ArgumentInfo.Type)type), types);
                ref.set((Object)dialog);
                dialog.show();
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    @Nullable
    private RPsiElement createArgument(@NotNull RubyReplacementBase elementToReplace, @NotNull String name, @NotNull ArgumentInfo.Type type) {
        if (elementToReplace == null) {
            RubyIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RubyIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (type == null) {
            RubyIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        this.myType = type;
        if (type == ArgumentInfo.Type.PREDEFINED) {
            return this.createDeclaration(elementToReplace, name, this.isSplatAllowed());
        }
        if (type.isKeyword()) {
            String assignmentText = elementToReplace.getExtractedText(name, true, this.isSplatAllowed());
            RMethod method = (RMethod)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)elementToReplace.getExpression(), expr -> RubyElementFactoryCore.createElementFromText((PsiElement)expr, (String)("def foo " + assignmentText + ";end"))), RMethod.class);
            return (RPsiElement)ObjectUtils.doIfNotNull((Object)method, it -> (RArgument)it.getArguments().get(0));
        }
        return (RPsiElement)ObjectUtils.doIfCast((Object)this.createDeclaration(elementToReplace, name, type == ArgumentInfo.Type.ARRAY), RAssignmentExpression.class, RAssignmentExpression::getValue);
    }

    @NotNull
    private static List<ArgumentInfo.Type> getAllowedTypes(@NotNull RMethod method) {
        if (method == null) {
            RubyIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        ArrayList<ArgumentInfo.Type> types = new ArrayList<ArgumentInfo.Type>();
        for (ArgumentInfo.Type type : ArgumentInfo.Type.values()) {
            if (!RubyPsiUtil.canInsertArgumentOfType(method, type)) continue;
            types.add(type);
        }
        ArrayList<ArgumentInfo.Type> arrayList = types;
        if (arrayList == null) {
            RubyIntroduceParameterHandler.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/parameter/RubyIntroduceParameterHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createArgument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedTypes";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

