/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementElement;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementSubstringElement;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;

public abstract class RubyIntroduceHandlerBase
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(RubyIntroduceHandlerBase.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(0);
        }
        this.performAction(project, editor, file, null, false, 0);
    }

    @NotNull
    protected String getDefaultName() {
        return "var";
    }

    public void performAction(Project project, Editor editor, PsiFile file, @Nullable String name, boolean replaceAll, int position) {
        RubyReplacementBase elementToReplace;
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            this.smartIntroduce(project, file, editor, name, replaceAll, position);
            return;
        }
        Pair<PsiElement, PsiElement> selected = RefactoringPsiHelper.getSelectedElements(editor, file);
        PsiElement element1 = (PsiElement)selected.first;
        PsiElement element2 = (PsiElement)selected.second;
        if (element1 == null || element2 == null || !RubyPsiUtilCore.isBefore((PsiElement)element1, (PsiElement)element2)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.selection.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        PsiElement parent = element1.getParent();
        if (TokenBNF.tSTRING_LIKE_CONTENTS.contains(element1.getNode().getElementType()) && element1 == element2 && RubyRefactoringUtil.isInterpolationAllowed(parent)) {
            int startOffset = parent.getTextRange().getStartOffset();
            int start = selectionModel.getSelectionStart() - startOffset;
            int end = selectionModel.getSelectionEnd() - startOffset;
            String selectedText = selectionModel.getSelectedText();
            if (selectedText == null) {
                return;
            }
            elementToReplace = new RubyReplacementSubstringElement(element1, (RPsiElement)parent, this.getSearchScope(parent), selectedText, new TextRange(start, end));
        } else {
            Object expression = RefactoringPsiHelper.getSelectedExpression(project, file, element1, element2, true, this.getHelpId());
            if (expression == null || expression instanceof String && StringUtil.isEmpty((String)((String)expression))) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.selection.error"), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            if (expression instanceof String) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)((String)expression), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            elementToReplace = new RubyReplacementElement(element1, (RPsiElement)expression, this.getSearchScope((PsiElement)((RPsiElement)expression)));
            if (elementToReplace.getExpression() == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.variable.changed.error"), (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureID());
        this.performActionOnElement(project, editor, elementToReplace, name, replaceAll);
    }

    public void performActionOnElement(final Project project, final Editor editor, final RubyReplacementBase elementToReplace, String name, boolean replaceAll) {
        RPsiElement expression = elementToReplace.getExpression();
        if (expression == null) {
            return;
        }
        PsiElement element1 = elementToReplace.getElement();
        List<PsiElement> occurrences = elementToReplace.getOccurrences();
        if (!TemplateIntegrationUtils.getInstance().isTemplateFile(expression.getContainingFile().getFileType()) && editor.getSettings().isVariableInplaceRenameEnabled() && !ApplicationManager.getApplication().isUnitTestMode()) {
            IntroduceValidator validator = this.createValidator(element1, occurrences);
            ReadAction.nonBlocking(() -> {
                List<String> names = this.getSuggestedNames((PsiElement)expression, validator);
                String newName = (String)ObjectUtils.coalesce((Object)((String)ContainerUtil.getFirstItem(names)), (Object)this.getDefaultName());
                RExpression declaration = this.createDeclaration(elementToReplace, newName, replaceAll);
                return Pair.create(names, (Object)declaration);
            }).finishOnUiThread(ModalityState.defaultModalityState(), namesAndDeclaration -> {
                final List names = (List)namesAndDeclaration.getFirst();
                final RExpression declaration = (RExpression)namesAndDeclaration.getSecond();
                if (declaration == null) {
                    return;
                }
                OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)element1, occurrences, (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice choice) {
                        boolean replaceAll = choice == OccurrencesChooser.ReplaceChoice.ALL;
                        RubyIntroduceHandlerBase.this.performInplaceIntroduce(project, editor, elementToReplace, (RPsiElement)declaration, names, replaceAll);
                    }
                });
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        } else {
            this.getParametersAndPerformRefactoring(project, (PsiElement)expression, occurrences, name, replaceAll, (TriConsumer<? super String, ? super Boolean, ? super LanguageLevel>)((TriConsumer)(newName, replaceChoice, languageLevel) -> {
                if (newName == null || replaceChoice == null || languageLevel == null) {
                    return;
                }
                RExpression declaration = this.createDeclaration(project, elementToReplace, (String)newName, (LanguageLevel)languageLevel, (boolean)replaceChoice);
                if (declaration != null) {
                    this.performIntroduce(project, (PsiElement)declaration, elementToReplace, (String)newName, (boolean)replaceChoice);
                }
            }));
        }
    }

    @Nullable
    protected PsiElement performReplace(@NotNull Project project, @Nullable PsiElement declaration, @NotNull RubyReplacementBase elementToReplace, @NotNull String name, boolean replaceAll) {
        PsiElement result;
        RPsiElement expression;
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(1);
        }
        if (elementToReplace == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(2);
        }
        if (name == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(3);
        }
        if ((expression = elementToReplace.getExpression()) == null) {
            return null;
        }
        Pair data = (Pair)expression.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE);
        if (data != null) {
            RPsiElement realElement = (RPsiElement)data.first;
            result = this.insertDeclaration(name, declaration, (PsiElement)realElement, elementToReplace.getOccurrences(), replaceAll);
        } else {
            result = this.insertDeclaration(name, declaration, (PsiElement)expression, elementToReplace.getOccurrences(), replaceAll);
        }
        SmartPsiElementPointer resultPointer = result == null ? null : SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(result);
        Object insertName = name;
        if (expression instanceof RListOfExpressions && !(((RListOfExpressions)expression).getFirstElement() instanceof RAssoc)) {
            insertName = "*" + name;
        }
        elementToReplace.replaceOccurrences(project, (String)insertName, replaceAll);
        return resultPointer == null ? null : resultPointer.getElement();
    }

    @Nullable
    protected RExpression createDeclaration(@NotNull RubyReplacementBase elementToReplace, @NotNull String name, boolean isListAllowed) {
        if (elementToReplace == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(4);
        }
        if (name == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(5);
        }
        String assignmentText = elementToReplace.getExtractedText(name, false, isListAllowed);
        return (RExpression)ObjectUtils.doIfNotNull((Object)elementToReplace.getExpression(), expr -> RubyElementFactoryCore.createExpressionFromText((PsiElement)expr, (String)assignmentText));
    }

    @Nullable
    protected RExpression createDeclaration(@NotNull Project project, @NotNull RubyReplacementBase elementToReplace, @NotNull String name, @NotNull LanguageLevel languageLevel, boolean isListAllowed) {
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(6);
        }
        if (elementToReplace == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(7);
        }
        if (name == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(8);
        }
        if (languageLevel == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(9);
        }
        String assignmentText = elementToReplace.getExtractedText(name, false, isListAllowed);
        return (RExpression)ObjectUtils.doIfNotNull((Object)elementToReplace.getExpression(), expr -> RubyElementFactoryCore.createExpressionFromText((Project)project, (String)assignmentText, (LanguageLevel)languageLevel));
    }

    protected void getParametersAndPerformRefactoring(@NotNull Project project, @NotNull PsiElement element, @NotNull List<PsiElement> occurrences, @Nullable String name, boolean replaceAll, @NotNull TriConsumer<? super String, ? super Boolean, ? super LanguageLevel> callback) {
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(10);
        }
        if (element == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(11);
        }
        if (occurrences == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(13);
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)element);
        IntroduceValidator validator = this.createValidator(element, occurrences);
        if (name != null) {
            String result = validator.check(new RubyIntroduceSettings(name, true, true));
            if (result != null) {
                throw new RuntimeException(result);
            }
            callback.accept((Object)name, (Object)replaceAll, (Object)languageLevel);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)ObjectUtils.coalesce((Object)name, (Object)((String)ContainerUtil.getFirstItem(this.getSuggestedNames(element, validator))), (Object)this.getDefaultName());
            callback.accept((Object)newName, (Object)replaceAll, (Object)languageLevel);
            return;
        }
        ReadAction.nonBlocking(() -> {
            List<String> names = this.getSuggestedNames(element, validator);
            return Pair.create(names, (Object)languageLevel);
        }).finishOnUiThread(ModalityState.defaultModalityState(), namesAndDeclaration -> {
            RubyIntroduceDialog dialog;
            List names = (List)namesAndDeclaration.getFirst();
            if (names.isEmpty()) {
                names.add(this.getDefaultName());
            }
            if (!(dialog = new RubyIntroduceDialog(project, this.getTitle(), this.getHelpId(), occurrences.size(), validator, ArrayUtilRt.toStringArray((Collection)names))).showAndGet()) {
                return;
            }
            String nameChoice = dialog.getName();
            callback.accept((Object)nameChoice, (Object)dialog.doReplaceAllOccurrences(), (Object)languageLevel);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    protected void smartIntroduce(final Project project, PsiFile file, final Editor editor, final String name, final boolean replaceAll, int position) {
        RubyReplacementElement replacement;
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset);
        PsiElement psiElement = elementAt = elementAt == null && offset > 0 ? file.findElementAt(offset - 1) : elementAt;
        if (elementAt == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.context.error"), (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        IElementType type = elementAt.getNode().getElementType();
        PsiElement psiElement2 = elementAt = RubyRefactoringUtil.isTypeToIgnore(type) ? PsiTreeUtil.prevLeaf((PsiElement)elementAt) : elementAt;
        if (elementAt != null && !(elementAt.getParent() instanceof RExpression)) {
            PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)elementAt);
            elementAt = prevLeaf != null && prevLeaf.getParent() instanceof RExpression ? prevLeaf : elementAt;
        }
        ArrayList<RExpression> expressions = new ArrayList<RExpression>();
        ArrayList<RubyReplacementElement> replacements = new ArrayList<RubyReplacementElement>();
        while (elementAt != null && !(elementAt instanceof RCompoundStatement)) {
            if (elementAt instanceof RExpression && RefactoringPsiHelper.checkCanExtract((RPsiElement)elementAt, true, this.getHelpId()) == null && (replacement = new RubyReplacementElement(elementAt, (RPsiElement)elementAt, this.getSearchScope(elementAt))).getExpression() != null) {
                expressions.add((RExpression)elementAt);
                replacements.add(replacement);
            }
            elementAt = elementAt.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode() && !expressions.isEmpty()) {
            replacement = (RubyReplacementElement)replacements.get(Math.min(position, expressions.size() - 1));
            this.performActionOnElement(project, editor, replacement, name, replaceAll);
        } else if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<RExpression>(){

                public void pass(RExpression expression) {
                    RubyIntroduceHandlerBase.this.performActionOnElement(project, editor, new RubyReplacementElement((PsiElement)expression, (RPsiElement)expression, RubyIntroduceHandlerBase.this.getSearchScope((PsiElement)expression)), name, replaceAll);
                }
            }, expression -> expression.getText());
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RBundle.message((String)"refactoring.introduce.context.error"), (String)this.getTitle(), (String)this.getHelpId());
        }
    }

    protected boolean isSplatAllowed() {
        return true;
    }

    protected abstract String getHelpId();

    @NlsContexts.DialogTitle
    protected abstract String getTitle();

    protected abstract String getFeatureID();

    protected abstract IntroduceValidator createValidator(PsiElement var1, List<PsiElement> var2);

    @Nullable
    protected abstract RPsiElement getSearchScope(PsiElement var1);

    protected abstract PsiElement insertDeclaration(String var1, PsiElement var2, PsiElement var3, List<PsiElement> var4, boolean var5);

    protected List<String> getSuggestedNames(PsiElement expression, IntroduceValidator validator) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : NamesSuggestor.getSuggestedNames(expression)) {
            if (!validator.isNameValid(name) || validator.checkPossibleName(name) != null) continue;
            result.add(name);
        }
        return result;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(15);
        }
    }

    private void performInplaceIntroduce(@NotNull Project project, @NotNull Editor editor, @NotNull RubyReplacementBase elementToReplace, @NotNull RPsiElement declaration, @NotNull List<String> names, boolean replaceAll) {
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(17);
        }
        if (elementToReplace == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(18);
        }
        if (declaration == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(19);
        }
        if (names == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(20);
        }
        RPsiElement expression = elementToReplace.getExpression();
        List<PsiElement> occurrences = elementToReplace.getOccurrences();
        PsiElement element = this.performIntroduce(project, (PsiElement)declaration, elementToReplace, names.isEmpty() ? this.getDefaultName() : names.get(0), replaceAll);
        if (element == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        final RPsiElement scope = this.getSearchScope(element);
        PsiElement[] arr = occurrences.toArray(PsiElement.EMPTY_ARRAY);
        if (!(element instanceof RAssignmentExpression)) {
            LOG.error("element is not RAssignmentExpression", new String[]{element.getText(), (String)ObjectUtils.doIfNotNull((Object)expression, PsiElement::getText)});
            return;
        }
        RAssignmentExpression assignmentExpression = (RAssignmentExpression)element;
        PsiNamedElement target = (PsiNamedElement)ObjectUtils.tryCast((Object)assignmentExpression.getObject(), PsiNamedElement.class);
        if (target == null) {
            return;
        }
        InplaceVariableIntroducer<PsiElement> introducer = new InplaceVariableIntroducer<PsiElement>(target, editor, project, this.getTitle(), arr, (PsiElement)expression){

            protected PsiElement checkLocalScope() {
                return scope;
            }

            public String getInitialName() {
                return this.myElementToRename instanceof RField ? ((RField)this.myElementToRename).getPrefix() + super.getInitialName() : super.getInitialName();
            }
        };
        introducer.performInplaceRefactoring(new LinkedHashSet<String>(names));
    }

    @Nullable
    private PsiElement performIntroduce(@NotNull Project project, @NotNull PsiElement declaration, @NotNull RubyReplacementBase elementToReplace, @NotNull String name, boolean replaceAll) {
        if (project == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(21);
        }
        if (declaration == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(22);
        }
        if (elementToReplace == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(23);
        }
        if (name == null) {
            RubyIntroduceHandlerBase.$$$reportNull$$$0(24);
        }
        Ref inserted = Ref.create();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> {
            PsiElement replacement = this.performReplace(project, declaration, elementToReplace, name, replaceAll);
            if (replacement != null) {
                inserted.set((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(replacement));
            }
        })), this.getTitle(), null);
        return (PsiElement)ObjectUtils.doIfNotNull((Object)((SmartPsiElementPointer)inserted.get()), SmartPsiElementPointer::getElement);
    }

    protected static PsiElement insertDeclaration(PsiElement declaration, PsiElement expression) {
        RContainer container = RefactoringPsiHelper.getClassOrModuleOrFile(expression);
        assert (container != null);
        List statements = container.getStatements();
        assert (!statements.isEmpty());
        boolean declarationSectionFound = false;
        RPsiElement prevStatement = null;
        for (RPsiElement statement : statements) {
            boolean isDeclaration = RubyIntroduceHandlerBase.isDeclaration(statement);
            if (declarationSectionFound && !isDeclaration) {
                return prevStatement.getParent().addAfter(declaration, (PsiElement)prevStatement);
            }
            declarationSectionFound |= isDeclaration;
            prevStatement = statement;
        }
        RPsiElement firstStatement = (RPsiElement)statements.get(0);
        return firstStatement.getParent().addBefore(declaration, (PsiElement)firstStatement);
    }

    private static boolean isDeclaration(RPsiElement statement) {
        return statement instanceof RAssignmentExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/RubyIntroduceHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performReplace";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeclaration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getParametersAndPerformRefactoring";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "performInplaceIntroduce";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "performIntroduce";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

