/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce;

import com.intellij.DynamicBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.IntroduceValidator;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.RubyIntroduceSettings;

public class RubyIntroduceDialog
extends DialogWrapper {
    private final Project myProject;
    private final int myOccurrencesCount;
    private final IntroduceValidator myValidator;
    private JPanel myContentPane;
    private ComboBox myNameComboBox;
    private JCheckBox myCheckBox;
    private JLabel myNameLabel;
    private JLabel myErrorLabel;
    private ComboBox myTypeComboBox;
    private JLabel myTypeLabel;
    private final String myHelpId;

    public RubyIntroduceDialog(@NotNull Project project, @NlsContexts.DialogTitle String caption, String helpId, int occurrencesCount, @NotNull IntroduceValidator validator, String[] possibleNames) {
        if (project == null) {
            RubyIntroduceDialog.$$$reportNull$$$0(0);
        }
        if (validator == null) {
            RubyIntroduceDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myOccurrencesCount = occurrencesCount;
        this.myValidator = validator;
        this.myHelpId = helpId;
        this.$$$setupUI$$$();
        this.setTypePanelVisible(false);
        this.setUpNameComboBox(possibleNames);
        this.setModal(true);
        this.setTitle(caption);
        this.init();
        this.setUpDialog();
        this.updateControls();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    public void setError(@NlsContexts.Label @NotNull String message) {
        if (message == null) {
            RubyIntroduceDialog.$$$reportNull$$$0(2);
        }
        this.myErrorLabel.setText(message);
    }

    @Nullable
    public String getError() {
        return this.myErrorLabel.getText();
    }

    public boolean hasError() {
        String error = this.myErrorLabel.getText();
        return error != null && !error.isEmpty() && !" ".equals(error);
    }

    @Nullable
    public String getName() {
        Object s = this.myNameComboBox.getEditor().getItem();
        if (s instanceof String && !((String)s).isEmpty()) {
            return ((String)s).trim();
        }
        return null;
    }

    @Nullable
    public Object getType() {
        if (this.myTypeComboBox.isVisible()) {
            return this.myTypeComboBox.getSelectedItem();
        }
        return null;
    }

    public boolean doReplaceAllOccurrences() {
        return this.myCheckBox.isSelected();
    }

    protected void setTypePanelVisible(boolean flag) {
        this.myTypeComboBox.setVisible(flag);
        this.myTypeLabel.setVisible(flag);
    }

    private void setUpDialog() {
        this.myCheckBox.setMnemonic(65);
        this.myNameLabel.setLabelFor((Component)this.myNameComboBox);
        this.myTypeLabel.setLabelFor((Component)this.myTypeComboBox);
        if (this.myOccurrencesCount > 1) {
            this.myCheckBox.setSelected(true);
            this.myCheckBox.setEnabled(true);
            this.myCheckBox.setText(RBundle.message((String)"refactoring.introduce.occurrences.checkbox.text", (Object[])new Object[]{this.myCheckBox.getText(), this.myOccurrencesCount}));
        } else {
            this.myCheckBox.setSelected(false);
            this.myCheckBox.setEnabled(false);
        }
    }

    private void setUpNameComboBox(@NlsSafe String[] possibleNames) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)RubyFileType.RUBY, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RubyIntroduceDialog.this.updateControls();
            }
        });
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                RubyIntroduceDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/RubyIntroduceDialog$2", "documentChanged"));
            }
        });
        this.myContentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)RubyIntroduceDialog.this.myNameComboBox, true));
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        for (String possibleName : possibleNames) {
            this.myNameComboBox.addItem((Object)possibleName);
        }
    }

    protected void setUpTypeComboBox(@NotNull Collection<@NlsSafe String> types) {
        if (types == null) {
            RubyIntroduceDialog.$$$reportNull$$$0(3);
        }
        for (String type : types) {
            this.myTypeComboBox.addItem((Object)type);
        }
        this.myTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RubyIntroduceDialog.this.checkTypeAvailable();
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void updateControls() {
        RubyIntroduceSettings settings = new RubyIntroduceSettings(this.getName(), this.isOK(), this.doReplaceAllOccurrences());
        boolean nameValid = this.myValidator.isNameValid(settings);
        this.setOKActionEnabled(nameValid);
        if (!nameValid) {
            this.setError(RBundle.message((String)"refactoring.introduce.name.error"));
            return;
        }
        String error = this.myValidator.check(settings);
        this.setOKActionEnabled(error == null);
        this.setError(error != null ? error : " ");
    }

    protected void checkTypeAvailable() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        ComboBox comboBox;
        JLabel jLabel3;
        ComboBox comboBox2;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RubyIntroduceDialog.class).getString("refactoring.introduce.dialog.replace.all.occurrences.checkbox.text"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTypeComboBox = comboBox2 = new ComboBox();
        jPanel4.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myTypeLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/RBundle", RubyIntroduceDialog.class).getString("refactoring.introduce.dialog.type.text"));
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myNameComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        comboBox.setLightWeightPopupEnabled(true);
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RBundle", RubyIntroduceDialog.class).getString("refactoring.introduce.dialog.name.text"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-65536));
        jLabel.setText("error_message_placeholder");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 0, new Dimension(320, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/RubyIntroduceDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpTypeComboBox";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

