/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.introduce;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtilRt;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NameSuggestorUtil;

public final class NamesSuggestor {
    public static String[] getSuggestedNames(@NotNull PsiElement element) {
        if (element == null) {
            NamesSuggestor.$$$reportNull$$$0(0);
        }
        NameSuggestingVisitor suggestingVisitor = new NameSuggestingVisitor();
        element.accept((PsiElementVisitor)suggestingVisitor);
        return suggestingVisitor.getNames();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/NamesSuggestor", "getSuggestedNames"));
    }

    private static class NameSuggestingVisitor
    extends RubyElementVisitor {
        private final LinkedHashSet<String> names = new LinkedHashSet();

        private NameSuggestingVisitor() {
        }

        public String @NotNull [] getNames() {
            String[] stringArray = ArrayUtilRt.toStringArray(this.names);
            if (stringArray == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private void generateNamesBy(@NotNull String name, @NotNull Scope scope, boolean sameNameAllowed) {
            if (name == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(2);
            }
            NameSuggestorUtil.addNames(this.names, name, scope, name, sameNameAllowed);
        }

        private void generateNamesByType(@NotNull String typeName, @NotNull Scope scope) {
            if (typeName == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(3);
            }
            if (scope == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(4);
            }
            NameSuggestorUtil.addNamesByType(this.names, typeName, scope);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(5);
            }
            if (element instanceof RExpression) {
                RExpression rExpression = (RExpression)element;
                RType type = RTypeUtil.getType(element);
                String name = type.getPresentableName();
                if (name != null) {
                    this.generateNamesByType(name, ScopeUtilCore.getScope((RPsiElement)rExpression));
                }
            }
        }

        public void visitRListOfExpressions(@NotNull RListOfExpressions rListOfExpressions) {
            if (rListOfExpressions == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(6);
            }
            this.generateNamesBy("list", ScopeUtilCore.getScope((RPsiElement)rListOfExpressions), false);
            this.generateNamesBy("items", ScopeUtilCore.getScope((RPsiElement)rListOfExpressions), false);
            super.visitRListOfExpressions(rListOfExpressions);
        }

        public void visitRConstant(@NotNull RConstant rConstant) {
            if (rConstant == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(7);
            }
            this.generateNamesBy(rConstant.getName(), ScopeUtilCore.getScope((RPsiElement)rConstant), false);
            super.visitRConstant(rConstant);
        }

        public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
            if (rIdentifier == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(8);
            }
            this.generateNamesBy(rIdentifier.getName(), ScopeUtil.getNearestScope((PsiElement)rIdentifier), ScopeUtil.getNearestScope((PsiElement)rIdentifier).getLocalVariable((PsiElement)rIdentifier, rIdentifier.getName()) != null);
            super.visitRIdentifier(rIdentifier);
        }

        public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
            if (rInstanceVariable == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(9);
            }
            this.generateNamesBy(rInstanceVariable.getName(), ScopeUtilCore.getScope((RPsiElement)rInstanceVariable), false);
            super.visitRInstanceVariable(rInstanceVariable);
        }

        public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
            if (rClassVariable == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(10);
            }
            this.generateNamesBy(rClassVariable.getName(), ScopeUtilCore.getScope((RPsiElement)rClassVariable), false);
            super.visitRClassVariable(rClassVariable);
        }

        public void visitRCall(@NotNull RCall rCall) {
            if (rCall == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(11);
            }
            this.generateNamesBy(rCall.getCommand(), ScopeUtilCore.getScope((RPsiElement)rCall), true);
            super.visitRCall(rCall);
        }

        public void visitRReference(@NotNull RReference rReference) {
            RPsiElement value;
            if (rReference == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(12);
            }
            if ((value = rReference.getValue()) != null) {
                String text = value.getText();
                if (!"new".equals(text)) {
                    this.generateNamesBy(text, ScopeUtilCore.getScope((RPsiElement)rReference), true);
                } else {
                    this.generateNamesBy(rReference.getReceiver().getText(), ScopeUtilCore.getScope((RPsiElement)rReference), true);
                }
            }
            super.visitRReference(rReference);
        }

        public void visitRPseudoConstant(@NotNull RPseudoConstant rPseudoConstant) {
            if (rPseudoConstant == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(13);
            }
            if (RubyTokenTypes.kSELF.toString().equals(rPseudoConstant.getText())) {
                this.names.add("instance");
            }
            super.visitRPseudoConstant(rPseudoConstant);
        }

        public void visitRSymbol(@NotNull RSymbol rSymbol) {
            if (rSymbol == null) {
                NameSuggestingVisitor.$$$reportNull$$$0(14);
            }
            this.generateNamesBy(rSymbol.getName(), ScopeUtilCore.getScope((RPsiElement)rSymbol), true);
            super.visitRSymbol(rSymbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/NamesSuggestor$NameSuggestingVisitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rListOfExpressions";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rConstant";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rIdentifier";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rInstanceVariable";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClassVariable";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rCall";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rReference";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rPseudoConstant";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNames";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/introduce/NamesSuggestor$NameSuggestingVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generateNamesBy";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generateNamesByType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRListOfExpressions";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRConstant";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRIdentifier";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRInstanceVariable";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRClassVariable";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRCall";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRReference";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRPseudoConstant";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRSymbol";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
            };
        }
    }
}

