/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractSuperclass;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractSuperclass.ExtractSuperclassDialog;

public final class RubyExtractSuperclassHandler
extends RubyClassRefactoringHandlerBase {
    private static final Logger LOG = Logger.getInstance(RubyExtractSuperclassHandler.class);

    public void showDialog(Project project, PsiElement element, Editor editor, PsiFile file, DataContext dataContext) {
        RClass clazz = RubyPsiUtil.getContainingRClass(element);
        if (clazz == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)this.getInvalidPositionMessage());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        RubyMemberInfoStorage infoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos((RContainer)clazz, element);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ExtractSuperclassDialog dialog = new ExtractSuperclassDialog(project, (RContainer)clazz, infoStorage);
        if (dialog.showAndGet()) {
            RubyExtractSuperclassHandler.extractSuperclass(clazz, dialog.getSelectedMemberInfos(), dialog.getSuperBaseName(), dialog.getTargetDirectory());
        }
    }

    @ApiStatus.Internal
    public static void extractSuperclass(RClass clazz, Collection<RubyMemberInfo> selectedMemberInfos, String superBaseName, VirtualFile targetDirectory) {
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> {
            try {
                RubyExtractSuperclassHandler.navigate((PsiElement)RubyExtractSuperclassHandler.doExtract(clazz, selectedMemberInfos, superBaseName, targetDirectory));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        })), RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{superBaseName, DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    private static PsiElement doExtract(RClass clazz, Collection<RubyMemberInfo> members, String superBaseName, VirtualFile targetDirectory) throws IOException {
        Project project = clazz.getProject();
        Pair<String, RFile> oldSuperClassAndFile = RubyExtractSuperclassHandler.getOldSuperclass(clazz);
        String statements = RubyClassMembersPsiHelper.prepareContainerStatements(superBaseName, members, "class", false);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        RFile file = RubyClassMembersPsiHelper.createTargetFile(project, targetDirectory, RubyRefactoringUtil.getNewFileName(superBaseName, module), statements);
        RubyClassMembersPsiHelper.removeMembers(members);
        RubyClassMembersPsiHelper.insertRequire(clazz.getContainingFile(), file);
        RClass newSuperclass = (RClass)RubyClassMembersPsiHelper.findPrepared(file, superBaseName);
        RubyExtractSuperclassHandler.removeSuperclass(clazz);
        if (oldSuperClassAndFile.first != null) {
            RubyExtractSuperclassHandler.addSuperclass(newSuperclass, (String)oldSuperClassAndFile.first);
        }
        if (oldSuperClassAndFile.second != null) {
            RubyClassMembersPsiHelper.insertRequire((PsiFile)file, (RFile)oldSuperClassAndFile.second);
        }
        RubyExtractSuperclassHandler.addSuperclass(clazz, superBaseName);
        return newSuperclass;
    }

    private static void removeSuperclass(RClass clazz) {
        RSuperClass superClass = clazz.getPsiSuperClass();
        if (superClass == null) {
            return;
        }
        List<PsiElement> superElements = RubyExtractSuperclassHandler.collectSuper((RPsiElement)superClass);
        RubyPsiUtil.removeElements(superElements.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static void addSuperclass(RClass clazz, String superclassName) {
        String statements = "class Foo < " + superclassName + "\nend";
        RClass fakeClass = (RClass)RubyElementFactoryCore.createElementFromText((PsiElement)clazz, (String)statements);
        List<PsiElement> superElements = RubyExtractSuperclassHandler.collectSuper((RPsiElement)fakeClass.getPsiSuperClass());
        RubyPsiUtil.addBeforeInParent(clazz.getClassName().getNextSibling(), superElements.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static List<PsiElement> collectSuper(RPsiElement psiSuperClass) {
        if (psiSuperClass == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> toRemove = new ArrayList<PsiElement>();
        toRemove.add((PsiElement)psiSuperClass);
        for (PsiElement element = psiSuperClass.getPrevSibling(); element != null && (element instanceof PsiWhiteSpace || "<".equals(element.getText())); element = element.getPrevSibling()) {
            toRemove.add(0, element);
        }
        return toRemove;
    }

    private static Pair<String, RFile> getOldSuperclass(RClass clazz) {
        PsiElement element;
        ClassModuleSymbol symbol = (ClassModuleSymbol)SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz);
        assert (symbol != null);
        Symbol superSymbol = symbol.getSuperClassSymbol((PsiElement)clazz);
        PsiElement psiElement = element = superSymbol != null && !superSymbol.getFQNWithNesting().equals(RClassBase.OBJECT_FQN) ? superSymbol.getPsiElement() : null;
        if (element == null) {
            RSuperClass superClassValue = clazz.getPsiSuperClass();
            return Pair.create((Object)(superClassValue != null ? superClassValue.getText() : null), null);
        }
        return Pair.create((Object)superSymbol.getFQNWithNesting().getFullPath(), (Object)((RFile)element.getContainingFile()));
    }

    protected String getHelpId() {
        return "refactoring.extractSuperclass";
    }

    protected String getTitle() {
        return RefactoringBundle.message((String)"extract.superclass.title");
    }

    protected String getInvalidPositionMessage() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.class");
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof RClass;
    }
}

