/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public abstract class RubyExtractMethodHelperBase {
    protected abstract void handleExtractFromExpression(Project var1, Editor var2, CodeFragment var3, RPsiElement var4);

    protected abstract void handleExtractFromStatements(Project var1, Editor var2, CodeFragment var3, RPsiElement var4, RPsiElement var5);

    public static List<PsiElement> collectElements(PsiElement statement1, PsiElement statement2) {
        ASTNode node1 = statement1.getNode();
        ASTNode node2 = statement2.getNode();
        ASTNode parentNode = statement1.getParent().getNode();
        boolean insideRange = false;
        ArrayList<PsiElement> elementsRange = new ArrayList<PsiElement>();
        for (ASTNode child : parentNode.getChildren(null)) {
            if (child == node1) {
                insideRange = true;
            }
            if (insideRange) {
                elementsRange.add(child.getPsi());
            }
            if (child == node2) break;
        }
        return elementsRange;
    }

    protected static void setSelectionAndCaret(Editor editor, PsiElement callElement) {
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(callElement.getTextOffset());
    }

    protected static PsiElement replaceElements(List<? extends PsiElement> elementsRange, PsiElement callElement) {
        PsiElement first = elementsRange.get(0);
        if (elementsRange.size() > 1) {
            first.getParent().deleteChildRange(elementsRange.get(1), elementsRange.get(elementsRange.size() - 1));
        }
        return first.replace(callElement);
    }

    protected static PsiElement replaceElements(@NotNull SimpleMatch match, @NotNull PsiElement callElement) {
        if (match == null) {
            RubyExtractMethodHelperBase.$$$reportNull$$$0(0);
        }
        if (callElement == null) {
            RubyExtractMethodHelperBase.$$$reportNull$$$0(1);
        }
        List<PsiElement> elementsRange = RubyExtractMethodHelperBase.collectElements(match.getStartElement(), match.getEndElement());
        Map changedParameters = match.getChangedParameters();
        if (callElement instanceof RCall) {
            Set keys = changedParameters.keySet();
            List arguments = ((RCall)callElement).getArguments();
            for (RPsiElement arg : arguments) {
                String argText = arg.getText();
                if (argText == null || !keys.contains(argText)) continue;
                arg.replace((PsiElement)RubyElementFactoryCore.createExpressionFromText((PsiElement)callElement, (String)((String)changedParameters.get(argText))));
            }
        }
        return RubyExtractMethodHelperBase.replaceElements(elementsRange, callElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "match";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callElement";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHelperBase";
        objectArray[2] = "replaceElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

