/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberSelectionPanel;

public abstract class UpDirectedMembersMovingDialog
extends DialogWrapper {
    protected DependencyMemberInfoModel<RPsiElement, RubyMemberInfo> myMemberInfoModel;
    protected RubyMemberSelectionPanel myMemberSelectionPanel;
    protected RContainer myClass;
    protected List<RubyMemberInfo> myMemberInfos;

    public UpDirectedMembersMovingDialog(Project project, RContainer clazz) {
        super(project, true);
        this.myClass = clazz;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new RubyMemberSelectionPanel(this.getMembersBorderTitle(), this.myMemberInfos, null);
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel2.add((Component)this.myMemberSelectionPanel, "Center");
        return panel2;
    }

    @NlsContexts.Separator
    protected abstract String getMembersBorderTitle();

    protected abstract DependencyMemberInfoModel<RPsiElement, RubyMemberInfo> createMemberInfoModel();

    protected void doOKAction() {
        if (!this.checkConflicts()) {
            return;
        }
        this.close(0);
    }

    public boolean isOKActionEnabled() {
        return !this.getSelectedMemberInfos().isEmpty() && super.isOKActionEnabled();
    }

    public abstract boolean checkConflicts();

    protected static boolean checkWritable(RContainer superClass, Collection<? extends RubyMemberInfo> infos) {
        if (infos.isEmpty()) {
            return true;
        }
        Project project = ((RPsiElement)infos.iterator().next().getMember()).getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)superClass)) {
            return false;
        }
        for (RubyMemberInfo rubyMemberInfo : infos) {
            RPsiElement member = (RPsiElement)rubyMemberInfo.getMember();
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)member)) {
                return false;
            }
            RContainer container = RubyPsiUtilCore.getParentContainer((PsiElement)member);
            if (container != null && CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)container)) continue;
            return false;
        }
        return true;
    }

    public Collection<RubyMemberInfo> getSelectedMemberInfos() {
        ArrayList<RubyMemberInfo> list = new ArrayList<RubyMemberInfo>(this.myMemberInfos.size());
        for (RubyMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add(info);
        }
        return list;
    }
}

