/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RubySuperClassesCollector {
    private final Symbol myClass;
    private final Map<RContainer, ContextImpl> myResult;
    private final boolean myInSource;

    private RubySuperClassesCollector(Symbol aClass, Map<RContainer, ContextImpl> result, boolean inSource) {
        this.myClass = aClass;
        this.myResult = result;
        this.myInSource = inSource;
    }

    private boolean addIfInSource(RContainer container, ContextImpl context) {
        if (!this.myInSource || RubySuperClassesCollector.isInSource(container)) {
            this.myResult.put(container, context);
            return true;
        }
        return false;
    }

    private static boolean isInSource(@Nullable RContainer container) {
        Module module;
        Module module2 = module = container != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)container) : null;
        if (module == null) {
            return false;
        }
        ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
        VirtualFile vFile = container.getContainingFile().getVirtualFile();
        return vFile != null && index.isInContent(vFile);
    }

    public static Map<RContainer, ContextImpl> getSuperClassesAndAllModules(RContainer clazz, boolean inSource) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz);
        if (symbol == null) {
            return Collections.emptyMap();
        }
        HashMap<RContainer, ContextImpl> result = new HashMap<RContainer, ContextImpl>(RubySuperClassesCollector.getSuperClasses(symbol, (PsiElement)clazz, inSource));
        result.putAll(RubySuperClassesCollector.getSuperClasses(symbol.getSingletonClassSymbol(), (PsiElement)clazz, inSource));
        return result;
    }

    @NotNull
    public static Map<RContainer, ContextImpl> getSuperClasses(@Nullable Symbol symbol, @NotNull PsiElement invocationPoint, boolean inSource) {
        if (invocationPoint == null) {
            RubySuperClassesCollector.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            Map<RContainer, ContextImpl> map = Collections.emptyMap();
            if (map == null) {
                RubySuperClassesCollector.$$$reportNull$$$0(1);
            }
            return map;
        }
        FQN selfFQN = symbol.getFQNWithNesting();
        HashMap<RContainer, ContextImpl> result = new HashMap<RContainer, ContextImpl>();
        RubySuperClassesCollector collector = new RubySuperClassesCollector(symbol, result, inSource);
        List<ResolveAncestor> entries = SymbolHierarchy.getAncestorsCaching(symbol, invocationPoint);
        for (ResolveAncestor entry : entries) {
            PsiElement declaration;
            if (entry.getSymbol() instanceof SingletonClassSymbol || entry.getSymbol().getFQNWithNesting().equals(selfFQN)) continue;
            Iterator iterator = entry.getSymbol().getAllDeclarations(null).iterator();
            while (!(!iterator.hasNext() || (declaration = (PsiElement)iterator.next()) instanceof RContainer && collector.addIfInSource((RContainer)declaration, ContextImpl.INSTANCE_PRIVATE))) {
            }
        }
        HashMap<RContainer, ContextImpl> hashMap = result;
        if (hashMap == null) {
            RubySuperClassesCollector.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubySuperClassesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubySuperClassesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClasses";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

