/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.ui.components.JBBox;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.UpDirectedMembersMovingDialog;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public abstract class RubyExtractSuperBaseDialog
extends UpDirectedMembersMovingDialog {
    protected JTextField mySourceClassField;
    protected JLabel mySuperNameLabel;
    protected JTextField myExtractedSuperNameField;
    protected TextFieldWithBrowseButton myTargetDirField;
    protected JLabel myDirLabel;

    public RubyExtractSuperBaseDialog(Project project, RContainer clazz, RubyMemberInfoStorage memberInfos) {
        super(project, clazz);
        this.myMemberInfos = memberInfos.getClassMemberInfos((PsiElement)this.myClass);
        this.myExtractedSuperNameField = new JTextField();
        this.myTargetDirField = new TextFieldWithBrowseButton();
        this.initSourceClassField();
    }

    @Override
    protected DependencyMemberInfoModel<RPsiElement, RubyMemberInfo> createMemberInfoModel() {
        return new MyMemberInfoModel(this.myClass);
    }

    protected void initSourceClassField() {
        this.mySourceClassField = new JTextField();
        this.mySourceClassField.setEditable(false);
        this.mySourceClassField.setText(this.myClass instanceof RClass ? RubyClassResolveUtil.getQualifiedName((RClass)this.myClass) : ((RModule)this.myClass).getQualifiedName());
    }

    @Override
    protected abstract String getMembersBorderTitle();

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    @Override
    protected void doOKAction() {
        String newName = this.getSuperBaseName();
        if (!NamingConventions.isInCamelCaseExt((String)newName)) {
            this.setErrorText(RBundle.message((String)"refactoring.extract.superbase.name.error", (Object[])new Object[]{StringUtil.capitalize((String)this.getSuperBaseType())}), this.myExtractedSuperNameField);
            return;
        }
        String directoryName = this.getDirectoryName();
        VirtualFile directory = this.getTargetDirectory();
        if (directory == null) {
            this.setErrorText(RBundle.message((String)"refactoring.extract.superbase.directory.does.not.exist", (Object[])new Object[]{directoryName}), (JComponent)this.myTargetDirField);
            return;
        }
        Project project = ProjectLocator.getPreferredProject((VirtualFile)directory);
        Module module = (Module)ObjectUtils.doIfNotNull((Object)project, it -> ModuleUtilCore.findModuleForFile((VirtualFile)directory, (Project)it));
        String fileName = RubyRefactoringUtil.getNewFileName(newName, module);
        if (directory.findFileByRelativePath(fileName) != null) {
            this.setErrorText(RBundle.message((String)"refactoring.extract.superbase.directory.file.exists", (Object[])new Object[]{fileName}), this.myExtractedSuperNameField);
            return;
        }
        super.doOKAction();
    }

    @Nullable
    public VirtualFile getTargetDirectory() {
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.getDirectoryName())));
    }

    private String getDirectoryName() {
        return this.myTargetDirField.getText();
    }

    protected abstract String getSuperBaseType();

    public String getSuperBaseName() {
        return this.myExtractedSuperNameField.getText();
    }

    protected VirtualFile getRoot() {
        return this.myClass.getContainingFile().getVirtualFile().getParent();
    }

    protected JPanel createNorthPanel() {
        Box box = this.createBox();
        box.add(Box.createVerticalStrut(10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)box, "Center");
        return panel2;
    }

    protected Box createBox() {
        JBBox box = JBBox.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(RBundle.message((String)"refactoring.extract.superbase.from", (Object[])new Object[]{this.getSuperBaseType()})), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box.add((Component)_panel);
        box.add(Box.createVerticalStrut(10));
        this.mySuperNameLabel = new JLabel();
        this.mySuperNameLabel.setText(RBundle.message((String)"refactoring.extract.superbase.name.prompt", (Object[])new Object[]{StringUtil.capitalize((String)this.getSuperBaseType())}));
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.mySuperNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add((Component)_panel);
        box.add(Box.createVerticalStrut(5));
        VirtualFile root = this.getRoot();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(this.getFileBrowserTitle()).withRoots(new VirtualFile[]{root}).withTreeRootVisible(true);
        this.myTargetDirField.setText(FileUtil.toSystemDependentName((String)root.getPath()));
        this.myTargetDirField.addBrowseFolderListener(this.myClass.getProject(), descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        _panel = new JPanel(new BorderLayout());
        this.myDirLabel = new JLabel();
        this.myDirLabel.setText(this.getFileBrowserTitle());
        _panel.add((Component)this.myDirLabel, "North");
        _panel.add((Component)this.myTargetDirField, "Center");
        box.add((Component)_panel);
        return box;
    }

    @Override
    public boolean checkConflicts() {
        Collection<RubyMemberInfo> infos = this.getSelectedMemberInfos();
        if (!RubyExtractSuperBaseDialog.checkWritable(this.myClass, infos)) {
            return false;
        }
        if (infos.isEmpty()) {
            return ((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)this.getTitle(), (String)RBundle.message((String)"refactoring.extract.superbase.no.members", (Object[])new Object[]{this.getSuperBaseType()})).yesText(RefactoringBundle.message((String)"continue.button"))).ask(this.myClass.getProject());
        }
        return true;
    }

    @NlsContexts.DialogTitle
    protected abstract String getFileBrowserTitle();

    protected boolean isStaticAllowed() {
        return true;
    }

    protected boolean isInstanceAllowed() {
        return true;
    }

    private class MyMemberInfoModel
    extends AbstractUsesDependencyMemberInfoModel<RPsiElement, RContainer, RubyMemberInfo> {
        MyMemberInfoModel(RContainer clazz) {
            super((PsiElement)clazz, null, false);
        }

        public boolean isMemberEnabled(RubyMemberInfo member) {
            return member.isStatic() && RubyExtractSuperBaseDialog.this.isStaticAllowed() || !member.isStatic() && RubyExtractSuperBaseDialog.this.isInstanceAllowed();
        }

        public boolean isAbstractEnabled(RubyMemberInfo member) {
            return false;
        }

        public int checkForProblems(@NotNull RubyMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.$$$reportNull$$$0(0);
            }
            return member.isChecked() ? 0 : super.checkForProblems((MemberInfoBase)member);
        }

        protected int doCheck(@NotNull RubyMemberInfo memberInfo, int problem) {
            if (memberInfo == null) {
                MyMemberInfoModel.$$$reportNull$$$0(1);
            }
            if (problem == 2 && memberInfo.isStatic()) {
                return 1;
            }
            return problem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberInfo";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubyExtractSuperBaseDialog$MyMemberInfoModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

