/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment.RCodeFragmentBuilder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ContextPsiFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RefactoringPsiHelper {
    private RefactoringPsiHelper() {
    }

    public static PsiElement replaceExpressionWithText(Project project, PsiElement expression, String text) {
        RExpressionSubstitution newExpression;
        RStringLiteral literal = (RStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)expression, RStringLiteral.class);
        RExpressionSubstitution substitution = (RExpressionSubstitution)PsiTreeUtil.getParentOfType((PsiElement)expression, RExpressionSubstitution.class);
        if (literal != null && substitution == null) {
            newExpression = RubyElementFactory.createExpressionSubstitutionFromText(expression, "#{" + text + "}");
        } else if (expression instanceof RListOfExpressions && text.startsWith("*")) {
            RCall call = (RCall)RubyElementFactoryCore.createExpressionFromText((PsiElement)expression, (String)("foo(" + text + ")"));
            newExpression = call.getCallArguments();
        } else {
            newExpression = RubyElementFactoryCore.createExpressionFromText((PsiElement)expression, (String)text);
        }
        return RefactoringPsiHelper.replaceExpression(project, expression, (PsiElement)newExpression);
    }

    @Nullable
    public static RContainer getClassOrModuleOrFile(PsiElement element) {
        RContainer container;
        PsiElement parent = element.getParent();
        if (parent instanceof RSuperClass) {
            return (RContainer)parent.getParent().getParent();
        }
        RContainer rContainer = container = element instanceof RContainer ? (RContainer)element : (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        while (container instanceof RMethod) {
            container = container.getParentContainer();
        }
        return container;
    }

    public static PsiElement replaceExpression(Project project, PsiElement expression, PsiElement newExpression) {
        Pair data = (Pair)expression.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE);
        if (data != null) {
            String parentText = ((RPsiElement)data.first).getText();
            TextRange textRange = (TextRange)data.second;
            String prefix = parentText.substring(0, textRange.getStartOffset());
            String suffix = parentText.substring(textRange.getEndOffset());
            LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)expression);
            RExpression newParent = RubyElementFactoryCore.createExpressionFromText((Project)project, (String)(prefix + newExpression.getText() + suffix), (LanguageLevel)languageLevel);
            return ((RPsiElement)data.first).replace((PsiElement)newParent);
        }
        return expression.replace(newExpression);
    }

    @Nullable
    public static Object getSelectedExpression(Project project, PsiFile file, PsiElement element1, PsiElement element2, boolean checkStateChangeInside, String helpId) {
        RPsiElement parent;
        PsiElement parentCandidate = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        RPsiElement rPsiElement = parent = parentCandidate instanceof RPsiElement ? (RPsiElement)parentCandidate : (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)parentCandidate, RPsiElement.class);
        if (parent == null) {
            return null;
        }
        String canExtract = RefactoringPsiHelper.checkCanExtract(parent, checkStateChangeInside, helpId);
        if (canExtract != null) {
            return canExtract;
        }
        if (RefactoringPsiHelper.isFirst((PsiElement)parent, element1) && RefactoringPsiHelper.isLast((PsiElement)parent, element2)) {
            return parent;
        }
        if (parent instanceof RBinaryExpression) {
            String suffix;
            LanguageLevel languageLevel;
            String selection = file.getText().substring(element1.getTextRange().getStartOffset(), element2.getTextRange().getEndOffset());
            RExpression expression = RubyElementFactoryCore.createExpressionFromText((Project)project, (String)selection, (LanguageLevel)(languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)element1)));
            PsiElement fakeAncestor = PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, PsiElement.class);
            if (!PsiTreeUtil.processElements((PsiElement)fakeAncestor, element -> !(element instanceof PsiErrorElement))) {
                return null;
            }
            String parentText = parent.getText();
            int startOffset = element1.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset();
            int endOffset = element2.getTextRange().getEndOffset() - parent.getTextRange().getStartOffset();
            TextRange textRange = new TextRange(startOffset, endOffset);
            String prefix = parentText.substring(0, startOffset);
            fakeAncestor = PsiTreeUtil.getTopmostParentOfType((PsiElement)RubyElementFactoryCore.createExpressionFromText((Project)project, (String)(prefix + "RubyMineRulezzz" + (suffix = parentText.substring(endOffset))), (LanguageLevel)languageLevel), PsiElement.class);
            if (!PsiTreeUtil.processElements((PsiElement)fakeAncestor, element -> !(element instanceof PsiErrorElement))) {
                return null;
            }
            expression.putUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE, (Object)Pair.create((Object)parent, (Object)textRange));
            ContextPsiFile.set((PsiElement)expression, (PsiElement)file);
            return expression;
        }
        return null;
    }

    @Nullable
    public static String checkCanExtract(RPsiElement element, boolean checkStateChangeInside, String helpId) {
        if (RCallNavigator.getByCommand((PsiElement)element) != null || RBlockCallNavigator.getByCall((RPsiElement)element) != null) {
            return RBundle.message((String)"refactoring.introduce.command.error");
        }
        if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)element) != null || element instanceof RHeredocValue) {
            return "";
        }
        if ("refactoring.introduceParameter".equals(helpId)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, RArgumentList.class, (boolean)false) != null || element instanceof ControlFlowHolder) {
                return "";
            }
            if (element instanceof RPossibleCall && !(element instanceof RColonReference) && !(element instanceof RConstant) && !(element instanceof RPseudoConstant)) {
                return "";
            }
        }
        if (!"refactoring.extractMethod".equals(helpId) && element instanceof RAssignmentExpression) {
            return "";
        }
        if (RubyPsiUtil.getAnyAssignmentByLeftPart((PsiElement)element) != null) {
            return element instanceof RVariable ? null : "";
        }
        if (!checkStateChangeInside) {
            return null;
        }
        TextRange range = element.getTextRange();
        RContainer container = element.getParentContainer();
        if (container == null) {
            throw new IllegalStateException("Element " + String.valueOf(element) + " has no container");
        }
        RCodeFragmentBuilder builder2 = new RCodeFragmentBuilder(range.getStartOffset(), range.getEndOffset(), (RPsiElement)container);
        container.accept((PsiElementVisitor)builder2);
        if (!("refactoring.introduceVariable".equals(helpId) || "refactoring.introduceField".equals(helpId) || builder2.getInElements().isEmpty())) {
            return RBundle.message((String)"refactoring.introduce.input.error");
        }
        return builder2.getOutElements().isEmpty() && builder2.getModifiedFields().isEmpty() ? null : RBundle.message((String)"refactoring.introduce.state.changed.error");
    }

    public static Pair<PsiElement, PsiElement> getSelectedElements(Editor editor, PsiFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        PsiElement element1 = null;
        PsiElement element2 = null;
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (0 <= lineNumber && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        if (element1 == null || element2 == null) {
            return Pair.create(null, null);
        }
        while (element1 != null && RefactoringPsiHelper.isExtendedWhitespace(element1)) {
            if (!((element1 = element1.getNextSibling()) instanceof RPsiElement)) continue;
            element1 = PsiTreeUtil.getDeepestFirst((PsiElement)element1);
        }
        while (element2 != null && RefactoringPsiHelper.isExtendedWhitespace(element2)) {
            if (!((element2 = element2.getPrevSibling()) instanceof RPsiElement)) continue;
            element2 = PsiTreeUtil.getDeepestLast((PsiElement)element2);
        }
        return Pair.create((Object)element1, (Object)element2);
    }

    @NotNull
    public static List<? extends PsiElement> insertElements(@NotNull PsiElement element, @NotNull List<? extends PsiElement> newElements) {
        List comments;
        if (element == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(0);
        }
        if (newElements == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(1);
        }
        ArrayList<PsiElement> inserted = new ArrayList<PsiElement>();
        RContainer container = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        assert (container != null);
        RCompoundStatement compoundStatement = container.getCompoundStatement();
        RPsiElement nextStatement = null;
        for (RPsiElement statement : compoundStatement.getStatements()) {
            if (!RubyPsiUtilCore.isBefore((PsiElement)element, (PsiElement)statement)) continue;
            nextStatement = statement;
            break;
        }
        RPsiElement anchor = nextStatement;
        if (nextStatement != null && !(comments = RubyCommentsUtilCore.getPsiComments(nextStatement)).isEmpty()) {
            anchor = (PsiElement)comments.get(0);
        }
        for (PsiElement psiElement : newElements) {
            inserted.add(compoundStatement.addBefore(psiElement, (PsiElement)anchor));
        }
        ArrayList<PsiElement> arrayList = inserted;
        if (arrayList == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    static boolean isExtendedWhitespace(PsiElement element) {
        return RubySpaceUtil.isAnySpace((PsiElement)element) || PsiUtilCore.getElementType((PsiElement)element) == RubyTokenTypes.tSEMICOLON || element instanceof PsiComment;
    }

    private static boolean isFirst(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(4);
        }
        return RefactoringPsiHelper.isFirstOrLast(parent, element, true);
    }

    private static boolean isLast(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(6);
        }
        return RefactoringPsiHelper.isFirstOrLast(parent, element, false);
    }

    private static boolean isFirstOrLast(@NotNull PsiElement parent, @NotNull PsiElement element, boolean first) {
        if (parent == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RefactoringPsiHelper.$$$reportNull$$$0(8);
        }
        element = PsiTreeUtil.getParentOfType((PsiElement)element, RPsiElement.class, (boolean)false);
        PsiElement deepest = first ? PsiTreeUtil.getDeepestFirst((PsiElement)parent) : PsiTreeUtil.getDeepestLast((PsiElement)parent);
        deepest = PsiTreeUtil.getParentOfType((PsiElement)deepest, RPsiElement.class, (boolean)false);
        return element == deepest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RefactoringPsiHelper";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RefactoringPsiHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "insertElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertElements";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFirst";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLast";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFirstOrLast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

