/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.WriteAccess;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.instructions.ReadWriteInstruction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyDefUseUtil {
    private static final Logger LOG = Logger.getInstance(RubyDefUseUtil.class);

    private RubyDefUseUtil() {
    }

    public static RPsiElement @NotNull [] getLatestDefs(ScopeHolder block, RIdentifier var, PsiElement anchor) {
        RControlFlow controlFlow = block.getControlFlow();
        Instruction[] instructions = controlFlow.getInstructions();
        ScopeHolder scope = (ScopeHolder)ScopeUtil.getLocalVariableScope((RPsiElement)anchor);
        PsiElement prevScope = anchor;
        while (scope != block && scope instanceof RCodeBlock && prevScope != scope) {
            prevScope = scope;
            scope = (ScopeHolder)ScopeUtil.getLocalVariableScope((RPsiElement)scope);
        }
        Instruction instruction = controlFlow.getInstructionByElement(prevScope);
        if (instruction == null) {
            LOG.warn("Could not find instruction found for " + anchor.getClass().getSimpleName() + " in " + block.getClass().getSimpleName());
            if (RPsiElement.EMPTY_ARRAY == null) {
                RubyDefUseUtil.$$$reportNull$$$0(0);
            }
            return RPsiElement.EMPTY_ARRAY;
        }
        HashSet<RPsiElement> result = new HashSet<RPsiElement>();
        RubyDefUseUtil.getLatestDefs(var, instructions, instruction.num(), result);
        RPsiElement[] rPsiElementArray = result.toArray(RPsiElement.EMPTY_ARRAY);
        if (rPsiElementArray == null) {
            RubyDefUseUtil.$$$reportNull$$$0(1);
        }
        return rPsiElementArray;
    }

    private static void getLatestDefs(RIdentifier var, Instruction[] instructions, int start, Collection<RPsiElement> result) {
        ControlFlowUtil.iteratePrev((int)start, (Instruction[])instructions, instruction -> {
            Instruction patt2624$temp = instructions[instruction.num()];
            if (patt2624$temp instanceof ReadWriteInstruction) {
                ReadWriteInstruction readWriteInstruction = (ReadWriteInstruction)patt2624$temp;
                RPsiElement element = (RPsiElement)readWriteInstruction.getElement();
                if (readWriteInstruction.getAccess() instanceof WriteAccess && RubyDefUseUtil.isMatchingElement(var, element)) {
                    result.add(element);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            }
            return ControlFlowUtil.Operation.NEXT;
        });
    }

    private static boolean isMatchingElement(RIdentifier var, RPsiElement element) {
        if (element instanceof RIdentifier) {
            String name = element.getName();
            return name != null && name.equals(var.getName()) && var.isLocalVariable() == ((RIdentifier)element).isLocalVariable();
        }
        return false;
    }

    public static RPsiElement @NotNull [] getPostRefs(ScopeHolder block, RIdentifier var, RPsiElement anchor) {
        RControlFlow controlFlow = block.getControlFlow();
        Instruction[] instructions = controlFlow.getInstructions();
        Instruction instruction = controlFlow.getInstructionByElement((PsiElement)anchor);
        assert (instruction != null) : "No instruction found for " + anchor.getClass().getSimpleName() + " in " + block.getClass().getSimpleName();
        HashSet<RPsiElement> result = new HashSet<RPsiElement>();
        for (Instruction succInstruction : instruction.allSucc()) {
            RubyDefUseUtil.getPostRefs(var, instructions, succInstruction.num(), result);
        }
        RPsiElement[] rPsiElementArray = result.toArray(RPsiElement.EMPTY_ARRAY);
        if (rPsiElementArray == null) {
            RubyDefUseUtil.$$$reportNull$$$0(2);
        }
        return rPsiElementArray;
    }

    private static void getPostRefs(RIdentifier var, Instruction[] instructions, int start, Collection<RPsiElement> result) {
        ControlFlowUtil.iterate((int)start, (Instruction[])instructions, instruction -> {
            PsiElement patt4716$temp;
            ReadWriteInstruction readWriteInstruction;
            RPsiElement element;
            if (instruction instanceof ReadWriteInstruction && RubyDefUseUtil.isMatchingElement(var, element = (RPsiElement)(readWriteInstruction = (ReadWriteInstruction)instruction).getElement())) {
                if (readWriteInstruction.getAccess() instanceof WriteAccess) {
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                result.add(element);
            }
            if ((patt4716$temp = instruction.getElement()) instanceof RCodeBlock) {
                RCodeBlock block = (RCodeBlock)patt4716$temp;
                RBlockArgumentList blockArguments = block.getBlockArguments();
                if (blockArguments != null) {
                    for (RArgument arg : blockArguments.getArguments()) {
                        if (!arg.getName().equals(var.getName())) continue;
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
                Instruction[] blockInstructions = block.getControlFlow().getInstructions();
                RubyDefUseUtil.getPostRefs(var, blockInstructions, 0, result);
            }
            return ControlFlowUtil.Operation.NEXT;
        }, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/RubyDefUseUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDefs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostRefs";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

