/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.postfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.postfix.RubyStringBasedPostfixTemplate;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

abstract class RubyExpressionStringBasedPostfixTemplate<T extends RExpression>
extends RubyStringBasedPostfixTemplate {
    static final String END_VARIABLE = "$END$";
    static final String EXPR_VARIABLE = "$expr$";
    @NotNull
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$([_a-zA-Z][_a-zA-Z0-9]*)\\$");

    RubyExpressionStringBasedPostfixTemplate(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector, @NotNull PostfixTemplateProvider provider) {
        if (name == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(0);
        }
        if (example == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(1);
        }
        if (selector == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(3);
        }
        super(name, example, selector, provider);
    }

    @NotNull
    public abstract String getTemplateString(@NotNull PsiElement var1);

    @NotNull
    public abstract RPsiElement getPlaceholderExpression(@NotNull T var1);

    @NotNull
    protected T createTemplateElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(4);
        }
        String text = this.getTemplateString(element);
        text = StringUtil.replace((String)text, (String)END_VARIABLE, (String)"");
        text = VARIABLE_PATTERN.matcher(text).replaceAll("$1");
        RExpression rExpression = RubyElementFactoryCore.createExpressionFromText((PsiElement)element, (String)text);
        if (rExpression == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(5);
        }
        return (T)rExpression;
    }

    public final void expandForChooseExpression(@NotNull PsiElement expr, @NotNull Editor editor) {
        if (expr == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(7);
        }
        PsiElement elementForRemoving = this.getElementToRemove(expr);
        editor.getDocument().deleteString(elementForRemoving.getTextRange().getStartOffset(), elementForRemoving.getTextRange().getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)expr.getProject());
        RPsiElement rExpr = Objects.requireNonNull((RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)expr, RPsiElement.class, (boolean)false));
        T exprTemplate = this.createTemplateElement(expr);
        String sourceExprText = RubyExpressionStringBasedPostfixTemplate.parenthesizeIfNeeded(expr.getText(), this.getPlaceholderExpression(exprTemplate), rExpr);
        String templateString = RubyExpressionStringBasedPostfixTemplate.parenthesizeIfNeeded(this.getTemplateString(expr), rExpr, exprTemplate);
        Template template = manager.createTemplate("", "Ruby postfix templates", templateString);
        template.setToReformat(this.shouldReformat());
        template.addVariable("expr", (Expression)new TextExpression(sourceExprText), false);
        this.setVariables(template, expr);
        manager.startTemplate(editor, template);
    }

    @NotNull
    private static String parenthesizeIfNeeded(@NotNull String text, @NotNull RPsiElement oldExpr, @NotNull RPsiElement newExpr) {
        if (text == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(8);
        }
        if (oldExpr == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(9);
        }
        if (newExpr == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(10);
        }
        Object object = RubyReplaceExpressionUtil.isNeedParenthesis(oldExpr, newExpr) ? "(" + text + ")" : text;
        if (object == null) {
            RubyExpressionStringBasedPostfixTemplate.$$$reportNull$$$0(11);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "example";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/postfix/RubyExpressionStringBasedPostfixTemplate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/postfix/RubyExpressionStringBasedPostfixTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parenthesizeIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateElement";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandForChooseExpression";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parenthesizeIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11 -> new IllegalStateException(string);
        };
    }
}

