/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

@State(name="RModuleSettingsStorage")
public final class RubyModuleSettings
extends SettingsExternalizer
implements ModificationTracker,
RSupportPerModuleSettings,
PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(RubyModuleSettings.class);
    @NonNls
    private static final String RMODULE_SETTINGS_STORAGE_ID = "RMODULE_SETTINGS_STORAGE_ID";
    @NonNls
    public static final String LOAD_PATH = "LOAD_PATH";
    @NonNls
    public static final String I18N_FOLDERS = "I18N_FOLDERS";
    @NonNls
    private static final String OPTIONS = "OPTIONS";
    @NonNls
    private static final String SPORK_SERVER_LAST_USED_TEST_FR_OPTION = "SPORK_SERVER_LAST_USED_TEST_FR_OPTION";
    @NotNull
    private final Module myModule;
    public List<String> myLoadPathDirs;
    private List<String> myI18nFolders;
    private SupportedTestFramework mySporkLastUsedTestFramework;
    private final AtomicLong myCounter;

    public RubyModuleSettings(@NotNull Module module) {
        if (module == null) {
            RubyModuleSettings.$$$reportNull$$$0(0);
        }
        this.myLoadPathDirs = new ArrayList<String>();
        this.myI18nFolders = new ArrayList<String>();
        this.mySporkLastUsedTestFramework = null;
        this.myCounter = new AtomicLong();
        this.myModule = module;
    }

    public long getModificationCount() {
        return this.myCounter.get();
    }

    public void setSporkLastUsedTestFramework(@NotNull SupportedTestFramework testFramework) {
        if (testFramework == null) {
            RubyModuleSettings.$$$reportNull$$$0(1);
        }
        this.mySporkLastUsedTestFramework = testFramework;
        this.myCounter.incrementAndGet();
    }

    @Nullable
    public SupportedTestFramework getSporkLastUsedTestFramework() {
        return this.mySporkLastUsedTestFramework;
    }

    public static RubyModuleSettings getInstance(Module module) {
        return (RubyModuleSettings)module.getService(RubyModuleSettings.class);
    }

    @Nullable
    public Element getState() {
        if (this.myLoadPathDirs.isEmpty() && this.myI18nFolders.isEmpty()) {
            return null;
        }
        Element result = new Element(this.getID());
        Element loadPathElement = new Element(LOAD_PATH);
        SettingsExternalizer.getState(loadPathElement, this.myLoadPathDirs);
        result.addContent(loadPathElement);
        Element i18nFolders = new Element(I18N_FOLDERS);
        SettingsExternalizer.getState(i18nFolders, this.myI18nFolders);
        result.addContent(i18nFolders);
        if (this.mySporkLastUsedTestFramework != null) {
            String strValue = SupportedTestFramework.serialize(Collections.singletonList(this.mySporkLastUsedTestFramework));
            SettingsExternalizer.writeOption(SPORK_SERVER_LAST_USED_TEST_FR_OPTION, strValue, result, OPTIONS);
        }
        return result;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            RubyModuleSettings.$$$reportNull$$$0(2);
        }
        SettingsExternalizer.loadState(element.getChild(LOAD_PATH), this.myLoadPathDirs);
        SettingsExternalizer.loadState(element.getChild(I18N_FOLDERS), this.myI18nFolders);
        Map<String, String> optionsByName = RubyModuleSettings.buildOptionsByElement(element, OPTIONS);
        String strValue = optionsByName.get(SPORK_SERVER_LAST_USED_TEST_FR_OPTION);
        if (strValue != null) {
            List<SupportedTestFramework> list = SupportedTestFramework.deserialize(strValue);
            LOG.assertTrue(1 == list.size());
            this.mySporkLastUsedTestFramework = list.get(0);
        }
        this.myCounter.incrementAndGet();
    }

    @Override
    @NotNull
    public List<String> getLoadPaths() {
        List<String> list = this.myLoadPathDirs;
        if (list == null) {
            RubyModuleSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setLoadPathDirs(@NotNull List<String> loadPathDirs) {
        if (loadPathDirs == null) {
            RubyModuleSettings.$$$reportNull$$$0(4);
        }
        if (!loadPathDirs.equals(this.myLoadPathDirs)) {
            this.myLoadPathDirs = loadPathDirs;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myModule.isDisposed()) {
                    LoadPathUtil.invalidateRubyCaches(this.myModule.getProject());
                }
            }, ModalityState.nonModal());
        }
        this.myCounter.incrementAndGet();
    }

    @Override
    @NotNull
    public List<String> getI18nFolders() {
        List<String> list = this.myI18nFolders;
        if (list == null) {
            RubyModuleSettings.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public void setI18nFolders(List<String> folders) {
        this.myI18nFolders = folders;
        this.myCounter.incrementAndGet();
    }

    @Override
    @NotNull
    public String getID() {
        return RMODULE_SETTINGS_STORAGE_ID;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFramework";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadPathDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getI18nFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSporkLastUsedTestFramework";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLoadPathDirs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

