/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.module;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.module.GemScannerSuppressor;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleManagerSettings;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleProperties;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.wizard.RubyFrameworkProjectGenerator;

@State(name="RubyModuleManagerSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class RubyModuleManager
implements Disposable,
PersistentStateComponent<RubyModuleManagerSettings> {
    private static final Logger LOG = Logger.getInstance(RubyModuleManager.class);
    @NotNull
    private final Project myProject;
    private final RubyModuleManagerSettings mySettings;
    private final SynchronizedClearableLazy<Set<VirtualFile>> myBlackListedRootsSetProvider;
    private final NotNullLazyValue<MergingUpdateQueue> mySuggestionQueueProvider;
    private final AtomicReference<Set<VirtualFile>> myQueuedKeyFilesReference;
    private final NotNullLazyValue<MergingUpdateQueue> myRescanQueueProvider;
    @NonNls
    private static final String MODULE_MANAGER_NOTIFICATION_GROUP_ID = "Ruby Module Manager";
    private boolean myInternalChange;

    public RubyModuleManager(@NotNull Project project) {
        if (project == null) {
            RubyModuleManager.$$$reportNull$$$0(0);
        }
        this.mySettings = new RubyModuleManagerSettings();
        this.myBlackListedRootsSetProvider = new SynchronizedClearableLazy(() -> {
            PathMacroManager pathMacroManager = this.getPathMacroManager();
            HashSet<VirtualFile> set = new HashSet<VirtualFile>();
            for (String path : this.mySettings.getBlackListedRootsPaths()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(pathMacroManager.expandPath(path)), (boolean)true);
                if (virtualFile == null || !virtualFile.isValid() || !virtualFile.isDirectory()) continue;
                set.add(virtualFile);
            }
            return set;
        });
        this.myInternalChange = false;
        this.myProject = project;
        this.mySuggestionQueueProvider = NotNullLazyValue.atomicLazy(() -> new MergingUpdateQueue("Shows notification about new Keyfiles", 2000, true, null, (Disposable)this, null, true));
        this.myQueuedKeyFilesReference = new AtomicReference<Set>(ConcurrentCollectionFactory.createConcurrentSet());
        this.myRescanQueueProvider = NotNullLazyValue.atomicLazy(() -> new MergingUpdateQueue("Runs project scanning for new modules", 500, true, null, (Disposable)this, null, true).usePassThroughInUnitTestMode());
    }

    public void projectOpened() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                ((MergingUpdateQueue)RubyModuleManager.this.myRescanQueueProvider.getValue()).cancelAllUpdates();
            }

            public void exitDumbMode() {
                RubyModuleManager.this.queueSuggestion();
                RubyModuleManager.this.queueFullScan();
            }
        });
        busConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!RubyModuleManager.this.myInternalChange) {
                    RubyModuleManager.this.queueFullScan();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$2", "rootsChanged"));
            }
        });
        busConnection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!RubyModuleManager.this.myInternalChange) {
                    RubyModuleManager.this.blackListRoots(Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$3";
                objectArray[2] = "moduleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileListener());
    }

    @NotNull
    private PathMacroManager getPathMacroManager() {
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.myProject);
        if (pathMacroManager == null) {
            RubyModuleManager.$$$reportNull$$$0(1);
        }
        return pathMacroManager;
    }

    public void queueFullScan() {
        ((MergingUpdateQueue)this.myRescanQueueProvider.getValue()).queue(Update.create((Object)"Scan for new modules", this::rescanForNewModules));
    }

    private boolean shouldCreateModule() {
        return this.mySettings.isShouldCreateModules() || this.shouldAskUser();
    }

    private boolean shouldAskUser() {
        return this.mySettings.isShouldAskUser();
    }

    private void rescanForNewModules() {
        ReadAction.nonBlocking(() -> {
            this.removeModules(ContainerUtil.filter((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(this.myProject), this::shouldRemoveModule));
            if (!this.shouldCreateModule()) {
                return;
            }
            List keyFiles = ContainerUtil.filter(this.collectKeyFiles(), keyFile -> this.getContentRootForNewModule((VirtualFile)keyFile) != null);
            if (keyFiles.isEmpty()) {
                return;
            }
            if (this.shouldAskUser()) {
                this.queueKeyFiles(keyFiles);
            } else {
                this.addModulesIfNecessary(keyFiles);
            }
        }).expireWith(RubyPluginUtil.getUnloadAwareDisposable(this.myProject)).coalesceBy(new Object[]{this.myProject, RubyModuleManager.class, "rescan"}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void invokeLaterInternalWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            RubyModuleManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.runInternalWriteAction(runnable));
    }

    @RequiresEdt
    private void runInternalWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            RubyModuleManager.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        WriteAction.run(() -> {
            this.myInternalChange = true;
            try {
                runnable.run();
            }
            finally {
                this.myInternalChange = false;
            }
        });
    }

    private void removeModules(@NotNull Collection<Module> modules) {
        if (modules == null) {
            RubyModuleManager.$$$reportNull$$$0(4);
        }
        if (modules.isEmpty()) {
            return;
        }
        this.invokeLaterInternalWriteAction(() -> {
            List nonDisposedModules = ContainerUtil.filter((Collection)modules, module -> !module.isDisposed());
            if (nonDisposedModules.isEmpty()) {
                return;
            }
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            modules.forEach(module -> modifiableModel.disposeModule(module));
            modifiableModel.commit();
        });
    }

    private boolean shouldRemoveModule(@Nullable Module module) {
        if (module == null || module.isDisposed() || !RubyModuleProperties.getInstance(module).isAutoCreated()) {
            return false;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length != 1) {
            return true;
        }
        VirtualFile mainContentRoot = contentRoots[0];
        if (mainContentRoot == null || !mainContentRoot.isValid()) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        VirtualFile moduleContainment = mainContentRoot.getParent();
        if (moduleContainment != null && (projectFileIndex.isExcluded(moduleContainment) || projectFileIndex.isInLibrary(moduleContainment))) {
            return true;
        }
        if (moduleContainment == null || ModuleUtilCore.findModuleForFile((VirtualFile)moduleContainment, (Project)this.myProject) == null) {
            return false;
        }
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        if (gemFile != null && !GemScannerSuppressor.isFileSuppressed(gemFile, module)) {
            return false;
        }
        return GemUtil.findGemspecFile(module) == null;
    }

    private void blackListKeyFiles(@NotNull Collection<? extends VirtualFile> keyFiles) {
        if (keyFiles == null) {
            RubyModuleManager.$$$reportNull$$$0(5);
        }
        this.blackListRoots(ContainerUtil.mapNotNull(keyFiles, keyFile -> keyFile.getParent()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blackListRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            RubyModuleManager.$$$reportNull$$$0(6);
        }
        SynchronizedClearableLazy<Set<VirtualFile>> synchronizedClearableLazy = this.myBlackListedRootsSetProvider;
        synchronized (synchronizedClearableLazy) {
            this.getBlackListedRoots().addAll(roots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unblacklistRootsAndAddModuleIfNecessary(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            RubyModuleManager.$$$reportNull$$$0(7);
        }
        if (roots.isEmpty()) {
            return;
        }
        SynchronizedClearableLazy<Set<VirtualFile>> synchronizedClearableLazy = this.myBlackListedRootsSetProvider;
        synchronized (synchronizedClearableLazy) {
            this.getBlackListedRoots().removeAll(roots);
        }
        this.addModulesIfNecessary(RubyModuleManager.findKeyFiles(this.myProject, roots));
    }

    @NotNull
    static Collection<VirtualFile> findKeyFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        if (project == null) {
            RubyModuleManager.$$$reportNull$$$0(8);
        }
        if (roots == null) {
            RubyModuleManager.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.mapNotNull(roots, root -> RubyModuleManager.findKeyFile(project, root));
        if (list == null) {
            RubyModuleManager.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    static VirtualFile findKeyFile(@NotNull Project project, @NotNull VirtualFile root) {
        VirtualFile gemFile;
        if (project == null) {
            RubyModuleManager.$$$reportNull$$$0(11);
        }
        if (root == null) {
            RubyModuleManager.$$$reportNull$$$0(12);
        }
        return (gemFile = BundlerUtil.getGemfile(project, root)) == null ? GemUtil.findGemspecFile(root) : gemFile;
    }

    private void addModulesIfNecessary(@NotNull Collection<VirtualFile> keyFiles) {
        if (keyFiles == null) {
            RubyModuleManager.$$$reportNull$$$0(13);
        }
        if (keyFiles.isEmpty()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            List contentRootsForNewModules = ContainerUtil.mapNotNull((Collection)keyFiles, this::getContentRootForNewModule);
            if (contentRootsForNewModules.isEmpty()) {
                return;
            }
            this.invokeLaterInternalWriteAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                List validRoots = ContainerUtil.filter((Collection)contentRootsForNewModules, VirtualFile::isValid);
                if (validRoots.isEmpty()) {
                    return;
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                ModifiableModuleModel modifiableModel = moduleManager.getModifiableModel();
                for (VirtualFile moduleRoot : validRoots) {
                    Module newModule = modifiableModel.newModule(FileUtil.join((String[])new String[]{this.getImlFileRoot(moduleRoot.getPath()), this.getNewModuleName(moduleRoot.getNameWithoutExtension()) + ".iml"}), "RUBY_MODULE");
                    this.configureModule(moduleRoot, newModule);
                }
                modifiableModel.commit();
            });
        }).expireWhen(() -> ((Project)this.myProject).isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresEdt
    private void configureModule(@NotNull VirtualFile moduleRoot, @NotNull Module newModule) {
        if (moduleRoot == null) {
            RubyModuleManager.$$$reportNull$$$0(14);
        }
        if (newModule == null) {
            RubyModuleManager.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.invokeLaterInternalWriteAction(() -> {
            if (newModule.isDisposed() || !moduleRoot.isValid()) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)newModule).getModifiableModel();
            model.setSdk(this.getPreferableSdk(moduleRoot));
            model.addContentEntry(moduleRoot);
            model.commit();
            RubyModuleProperties.getInstance(newModule).setAutoCreated(true);
            if ((!PlatformUtils.isIntelliJ() || ApplicationManager.getApplication().isUnitTestMode()) && RailsUtil.containsRailsApp(moduleRoot.getPath())) {
                RailsFacetUtil.configureRailsFacet(moduleRoot, newModule);
            } else {
                ModuleRootModificationUtil.updateModel((Module)newModule, rootModel -> RubyFrameworkProjectGenerator.setupStandardTestSourceRoots(moduleRoot, rootModel));
            }
        });
    }

    private void queueKeyFiles(@NotNull Collection<VirtualFile> keyFiles) {
        if (keyFiles == null) {
            RubyModuleManager.$$$reportNull$$$0(16);
        }
        this.myQueuedKeyFilesReference.get().addAll(keyFiles);
        this.queueSuggestion();
    }

    @RequiresReadLock
    @Nullable
    private VirtualFile getContentRootForNewModule(@NotNull VirtualFile keyFile) {
        if (keyFile == null) {
            RubyModuleManager.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!keyFile.isValid() || ProjectFileIndex.getInstance((Project)this.myProject).isExcluded(keyFile)) {
            return null;
        }
        VirtualFile keyFileRoot = keyFile.getParent();
        if (keyFileRoot == null || !keyFileRoot.isValid() || this.getBlackListedRoots().contains(keyFileRoot)) {
            return null;
        }
        Module containingModule = ModuleUtilCore.findModuleForFile((VirtualFile)keyFileRoot, (Project)this.myProject);
        if (containingModule != null) {
            if (GemScannerSuppressor.isFileSuppressed(keyFile, containingModule)) {
                return null;
            }
            for (VirtualFile moduleContentRoot : ModuleRootManager.getInstance((Module)containingModule).getContentRoots()) {
                if (!moduleContentRoot.equals(keyFileRoot)) continue;
                return null;
            }
        }
        return keyFileRoot;
    }

    private void queueSuggestion() {
        if (this.myProject.isDisposed() || this.myQueuedKeyFilesReference.get().isEmpty()) {
            return;
        }
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ((MergingUpdateQueue)this.mySuggestionQueueProvider.getValue()).queue(Update.create((Object)this, () -> {
            boolean hasNotification;
            if (DumbService.isDumb((Project)this.myProject)) {
                this.queueSuggestion();
                return;
            }
            if (this.myProject.isDisposed() || this.myQueuedKeyFilesReference.get().isEmpty()) {
                return;
            }
            boolean bl = hasNotification = ((MyNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MyNotification.class, this.myProject)).length > 0;
            if (hasNotification) {
                return;
            }
            Notifications.Bus.notify((Notification)new MyNotification(), (Project)this.myProject);
        })));
    }

    @NotNull
    private String getImlFileRoot(@NotNull String moduleContentRootPath) {
        String string;
        if (moduleContentRootPath == null) {
            RubyModuleManager.$$$reportNull$$$0(18);
        }
        if (this.mySettings.isPutImlFilesInsideModules()) {
            String string2 = moduleContentRootPath;
            if (string2 == null) {
                RubyModuleManager.$$$reportNull$$$0(19);
            }
            return string2;
        }
        VirtualFile projectBaseDir = this.myProject.getBaseDir();
        if (projectBaseDir == null) {
            String string3 = moduleContentRootPath;
            if (string3 == null) {
                RubyModuleManager.$$$reportNull$$$0(20);
            }
            return string3;
        }
        VirtualFile ideaDir = projectBaseDir.findChild(".idea");
        if (ideaDir == null) {
            String string4 = moduleContentRootPath;
            if (string4 == null) {
                RubyModuleManager.$$$reportNull$$$0(21);
            }
            return string4;
        }
        try {
            VirtualFile modulesDirectory = VfsUtil.createDirectoryIfMissing((VirtualFile)ideaDir, (String)"modules");
            string = modulesDirectory == null ? moduleContentRootPath : modulesDirectory.getPath();
        }
        catch (IOException e) {
            LOG.warn("Could not create a .idea/modules directory", (Throwable)e);
            String string5 = moduleContentRootPath;
            if (string5 == null) {
                RubyModuleManager.$$$reportNull$$$0(23);
            }
            return string5;
        }
        if (string == null) {
            RubyModuleManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @RequiresReadLock
    @NotNull
    private String getNewModuleName(@NotNull String baseName) {
        if (baseName == null) {
            RubyModuleManager.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.softAssertReadAccess();
        Object moduleName = baseName;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        int counter = 1;
        while (moduleManager.findModuleByName((String)moduleName) != null) {
            moduleName = baseName + counter++;
        }
        String string = moduleName;
        if (string == null) {
            RubyModuleManager.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    private Sdk getPreferableSdk(@NotNull VirtualFile gemFileRoot) {
        RModuleUtil rubyModuleUtil;
        Sdk sdk;
        if (gemFileRoot == null) {
            RubyModuleManager.$$$reportNull$$$0(26);
        }
        if ((sdk = (rubyModuleUtil = RModuleUtil.getInstance()).findRubySdkForVirtualFile(this.myProject, gemFileRoot.getParent())) != null) {
            return sdk;
        }
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        if (RubySdkUtil.isRubySDK(projectSdk)) {
            return projectSdk;
        }
        return Arrays.stream(rubyModuleUtil.getAllModulesWithRubySupport(this.myProject)).map(module -> rubyModuleUtil.findRubySdkForModule((Module)module)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void dispose() {
    }

    @RequiresReadLock
    @NotNull
    private Collection<VirtualFile> collectKeyFiles() {
        ThreadingAssertions.softAssertReadAccess();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        GlobalSearchScope projectContentScope = ProjectScope.getContentScope((Project)this.myProject);
        HashSet gemFiles = new HashSet(FilenameIndex.getVirtualFilesByName((String)"Gemfile", (GlobalSearchScope)projectContentScope));
        gemFiles.addAll(FilenameIndex.getVirtualFilesByName((String)"gems.rb", (GlobalSearchScope)projectContentScope));
        gemFiles.addAll(FilenameIndex.getAllFilesByExt((Project)this.myProject, (String)"gemspec", (GlobalSearchScope)projectContentScope));
        List list = ContainerUtil.filter(gemFiles, file -> !projectFileIndex.isExcluded(file));
        if (list == null) {
            RubyModuleManager.$$$reportNull$$$0(27);
        }
        return list;
    }

    private Set<VirtualFile> getBlackListedRoots() {
        return (Set)this.myBlackListedRootsSetProvider.getValue();
    }

    @TestOnly
    public boolean isBlackListed(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RubyModuleManager.$$$reportNull$$$0(28);
        }
        return this.getBlackListedRoots().contains(virtualFile);
    }

    @NotNull
    public RubyModuleManagerSettings getState() {
        PathMacroManager pathMacroManager = this.getPathMacroManager();
        this.mySettings.setBlackListedRootsPaths(this.getBlackListedRoots().stream().filter(virtualFile -> virtualFile != null && virtualFile.isValid() && virtualFile.isDirectory()).map(virtualFile -> pathMacroManager.collapsePath(virtualFile.getPath())).collect(Collectors.toList()));
        RubyModuleManagerSettings rubyModuleManagerSettings = this.mySettings;
        if (rubyModuleManagerSettings == null) {
            RubyModuleManager.$$$reportNull$$$0(29);
        }
        return rubyModuleManagerSettings;
    }

    public void loadState(@NotNull RubyModuleManagerSettings state) {
        if (state == null) {
            RubyModuleManager.$$$reportNull$$$0(30);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.mySettings);
        this.myBlackListedRootsSetProvider.drop();
    }

    @NotNull
    public static RubyModuleManager getInstance(@NotNull Project project) {
        if (project == null) {
            RubyModuleManager.$$$reportNull$$$0(31);
        }
        RubyModuleManager rubyModuleManager = (RubyModuleManager)project.getService(RubyModuleManager.class);
        if (rubyModuleManager == null) {
            RubyModuleManager.$$$reportNull$$$0(32);
        }
        return rubyModuleManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 19, 20, 21, 22, 23, 25, 27, 29, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFiles";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModule";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleContentRootPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFileRoot";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacroManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findKeyFiles";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getImlFileRoot";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewModuleName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectKeyFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 10: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterInternalWriteAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInternalWriteAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeModules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "blackListKeyFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "blackListRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unblacklistRootsAndAddModuleIfNecessary";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findKeyFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findKeyFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addModulesIfNecessary";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureModule";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "queueKeyFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForNewModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getImlFileRoot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNewModuleName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableSdk";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isBlackListed";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 19, 20, 21, 22, 23, 25, 27, 29, 32 -> new IllegalStateException(string);
        };
    }

    private final class MyFileListener
    implements BulkFileListener {
        private MyFileListener() {
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyFileListener.$$$reportNull$$$0(0);
            }
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)RubyModuleManager.this.myProject);
            for (VFileEvent vFileEvent : events) {
                VirtualFile eventFile;
                if (vFileEvent instanceof VFileContentChangeEvent || (eventFile = vFileEvent.getFile()) == null) continue;
                if (projectFileIndex.isInContent(eventFile)) {
                    RubyModuleManager.this.queueFullScan();
                    return;
                }
                VirtualFile parentFile = eventFile.getParent();
                if (!(vFileEvent instanceof VFileDeleteEvent) || parentFile == null || !projectFileIndex.isInContent(parentFile)) continue;
                RubyModuleManager.this.queueFullScan();
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyFileListener", "after"));
        }
    }

    private final class MyNotification
    extends Notification {
        private MyNotification() {
            super(RubyModuleManager.MODULE_MANAGER_NOTIFICATION_GROUP_ID, RBundle.message((String)"module.manager.notification.title"), RBundle.message((String)"module.manager.notification.text"), NotificationType.INFORMATION);
            this.setSuggestionType(true);
            this.addAction(new AnAction(RBundle.message((String)"button.configure")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyNotification.this.expire();
                    MyNotification.this.suggestKeyfiles();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyNotification$1", "actionPerformed"));
                }
            });
        }

        private void suggestKeyfiles() {
            Set<VirtualFile> keyFilesToScan = RubyModuleManager.this.myQueuedKeyFilesReference.getAndSet(ConcurrentCollectionFactory.createConcurrentSet());
            if (keyFilesToScan.isEmpty()) {
                return;
            }
            Set<VirtualFile> blackListedRoots = RubyModuleManager.this.getBlackListedRoots();
            List filteredKeyFilesToScan = ContainerUtil.filter(keyFilesToScan, keyFile -> {
                VirtualFile root = keyFile.getParent();
                return root != null && !blackListedRoots.contains(root);
            });
            if (filteredKeyFilesToScan.isEmpty()) {
                return;
            }
            MyDialog dialog = new MyDialog(RubyModuleManager.this.myProject, filteredKeyFilesToScan);
            dialog.show();
            if (dialog.isDontShowSelected()) {
                RubyModuleManager.this.mySettings.setShouldAskUser(false);
                RubyModuleManager.this.mySettings.setShouldCreateModules(dialog.isSilentCreateSelected());
            }
            if (dialog.isOK()) {
                List keyFilesToAdd = dialog.getMarkedElements();
                RubyModuleManager.this.blackListKeyFiles(ContainerUtil.subtract((Collection)filteredKeyFilesToScan, (Collection)keyFilesToAdd));
                RubyModuleManager.this.addModulesIfNecessary(keyFilesToAdd);
            } else {
                RubyModuleManager.this.blackListKeyFiles(filteredKeyFilesToScan);
            }
        }
    }

    private static class MyDialog
    extends ChooseElementsDialog<VirtualFile> {
        @Nullable
        private JCheckBox myDontShowCheckbox;
        @Nullable
        private JCheckBox mySilentCreateCheckbox;

        MyDialog(Project project, List<? extends VirtualFile> items) {
            super(project, items, RBundle.message((String)"module.manager.dialog.title"), RBundle.message((String)"module.manager.dialog.text"), true);
            this.getSilentCreateCheckbox().setVisible(false);
            this.getDontShowCheckbox().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.getSilentCreateCheckbox().setVisible(this.getDontShowCheckbox().isSelected());
                }
            });
        }

        protected boolean canElementsBeMarked() {
            return true;
        }

        protected boolean isElementMarkedByDefault(VirtualFile element) {
            return true;
        }

        protected String getItemText(VirtualFile item) {
            VirtualFile parent = item.getParent();
            return parent == null ? RBundle.message((String)"list.item.unknown.directory") : FileUtil.toSystemDependentName((String)parent.getPath());
        }

        @Nullable
        protected Icon getItemIcon(VirtualFile item) {
            return null;
        }

        protected JComponent createCenterPanel() {
            JComponent panel2 = super.createCenterPanel();
            assert (panel2 != null);
            JPanel checkBoxesPanel = new JPanel(new BorderLayout());
            checkBoxesPanel.add((Component)this.getDontShowCheckbox(), "West");
            checkBoxesPanel.add((Component)this.getSilentCreateCheckbox(), "Center");
            panel2.add((Component)checkBoxesPanel, "South");
            return panel2;
        }

        @NotNull
        private JCheckBox getSilentCreateCheckbox() {
            if (this.mySilentCreateCheckbox == null) {
                this.mySilentCreateCheckbox = new JCheckBox(RBundle.message((String)"module.manager.dialog.create"));
            }
            JCheckBox jCheckBox = this.mySilentCreateCheckbox;
            if (jCheckBox == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            return jCheckBox;
        }

        @NotNull
        private JCheckBox getDontShowCheckbox() {
            if (this.myDontShowCheckbox == null) {
                this.myDontShowCheckbox = new JCheckBox(RBundle.message((String)"module.manager.notification.dont.show"));
            }
            JCheckBox jCheckBox = this.myDontShowCheckbox;
            if (jCheckBox == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            return jCheckBox;
        }

        public boolean isDontShowSelected() {
            return this.getDontShowCheckbox().isSelected();
        }

        public boolean isSilentCreateSelected() {
            return this.getSilentCreateCheckbox().isSelected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/module/RubyModuleManager$MyDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSilentCreateCheckbox";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDontShowCheckbox";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

