/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.rename;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.api.PsiRenameUsage;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageSearchParameters;
import com.intellij.refactoring.rename.api.RenameUsageSearcher;
import com.intellij.refactoring.util.TextOccurrencesUtilBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.RenamablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.model.psi.RenamablePsiSymbolReference;
import org.jetbrains.plugins.ruby.model.psi.SearchablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.model.psi.SearchablePsiSymbolReference;
import org.jetbrains.plugins.ruby.model.rename.ReplaceReferenceTarget;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.model.psi.RubyPsiSymbolDeclarationsSearch;
import org.jetbrains.plugins.ruby.ruby.model.rename.RubyRenameTarget;

public final class RubyRenameUsageSearcher
implements RenameUsageSearcher {
    @NotNull
    public Collection<? extends Query<? extends RenameUsage>> collectSearchRequests(@NotNull RenameUsageSearchParameters parameters) {
        RubyRenameTarget renameTarget;
        if (parameters == null) {
            RubyRenameUsageSearcher.$$$reportNull$$$0(0);
        }
        if ((renameTarget = (RubyRenameTarget)ObjectUtils.tryCast((Object)parameters.getTarget(), RubyRenameTarget.class)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyRenameUsageSearcher.$$$reportNull$$$0(1);
            }
            return list;
        }
        Project project = parameters.getProject();
        SearchScope searchScope = parameters.getSearchScope();
        ArrayList<Query> searchRequests = new ArrayList<Query>();
        searchRequests.add(RubyPsiSymbolDeclarationsSearch.search(project, searchScope, (Symbol)renameTarget.getTarget()).transforming(declaration -> {
            if (declaration instanceof RenamablePsiSymbolDeclaration) {
                RenamablePsiSymbolDeclaration renamableDeclaration = (RenamablePsiSymbolDeclaration)declaration;
                return List.of(renamableDeclaration.getRenameUsage());
            }
            if (declaration instanceof SearchablePsiSymbolDeclaration) {
                SearchablePsiSymbolDeclaration searchableDeclaration = (SearchablePsiSymbolDeclaration)declaration;
                return List.of(PsiRenameUsage.defaultPsiRenameUsage((PsiUsage)searchableDeclaration.getUsage()));
            }
            return Collections.emptyList();
        }));
        Pointer<? extends RubyRenameTarget> renameTargetPointer = renameTarget.createPointer();
        renameTarget.getReferenceSearchRequests().forEach(request -> {
            SearchScope requestSearchScope = request.getSearchScope();
            Query query = SearchService.getInstance().searchWord(project, request.getSearchString()).inScope(requestSearchScope != null ? searchScope.intersectWith(requestSearchScope) : searchScope).inFilesWithLanguage((Language)RubyLanguage.INSTANCE).inContexts(SearchContext.inCode(), new SearchContext[0]).buildQuery(LeafOccurrenceMapper.withPointer((Pointer)renameTargetPointer, RubyRenameUsageSearcher::mapOccurrence));
            searchRequests.add(query);
        });
        List list = Collections.unmodifiableList(searchRequests);
        if (list == null) {
            RubyRenameUsageSearcher.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<? extends RenameUsage> mapOccurrence(@NotNull RubyRenameTarget target, @NotNull LeafOccurrence occurrence) {
        PsiElement element;
        if (target == null) {
            RubyRenameUsageSearcher.$$$reportNull$$$0(3);
        }
        if (occurrence == null) {
            RubyRenameUsageSearcher.$$$reportNull$$$0(4);
        }
        if (CommentUtilCore.isComment((PsiElement)(element = occurrence.getStart())) || TextOccurrencesUtilBase.isStringLiteralElement((PsiElement)element)) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyRenameUsageSearcher.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList references = new ArrayList();
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            references.addAll(PsiSymbolReferenceService.getService().getReferences(parent, SearchablePsiSymbolReference.class));
            if (!references.isEmpty()) break;
        }
        if (references.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                RubyRenameUsageSearcher.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<ReplaceReferenceTarget> referenceTargets = target.getReferenceTargets();
        List list = ContainerUtil.mapNotNull(references, reference -> {
            for (ReplaceReferenceTarget referenceTarget : referenceTargets) {
                if (!reference.resolvesTo(referenceTarget.target())) continue;
                if (reference instanceof RenamablePsiSymbolReference) {
                    RenamablePsiSymbolReference renamableReference = (RenamablePsiSymbolReference)reference;
                    return renamableReference.getRenameUsage(referenceTarget.usageTextByName());
                }
                return PsiRenameUsage.defaultPsiRenameUsage((PsiUsage)reference.getUsage());
            }
            return null;
        });
        if (list == null) {
            RubyRenameUsageSearcher.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/rename/RubyRenameUsageSearcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/rename/RubyRenameUsageSearcher";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSearchRequests";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mapOccurrence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSearchRequests";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mapOccurrence";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

