/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.navigation;

import com.intellij.codeInsight.navigation.SymbolTypeProvider;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.TypeAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RVariableBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyGlobalVariableDeclarationNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.model.api.RubySymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyNumberedParameterSymbol;

public final class RubySymbolTypeProvider
implements SymbolTypeProvider {
    @NotNull
    public List<? extends com.intellij.model.Symbol> getSymbolTypes(@NotNull Project project, @NotNull com.intellij.model.Symbol symbol) {
        List<? extends RType> types;
        if (project == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(1);
        }
        if (!(symbol instanceof RubySymbol)) {
            List list = Collections.emptyList();
            if (list == null) {
                RubySymbolTypeProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        if (symbol instanceof RubyGlobalVariableSymbol) {
            RubyGlobalVariableSymbol globalVariableSymbol = (RubyGlobalVariableSymbol)symbol;
            types = RubySymbolTypeProvider.getRubyTypes(project, (SearchScope)searchScope, globalVariableSymbol);
        } else if (symbol instanceof RubyNumberedParameterSymbol) {
            RubyNumberedParameterSymbol numberedParameterSymbol = (RubyNumberedParameterSymbol)symbol;
            types = RubySymbolTypeProvider.getRubyTypes(numberedParameterSymbol);
        } else {
            List list = Collections.emptyList();
            if (list == null) {
                RubySymbolTypeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList targets = new SmartList();
        for (RType type : new LinkedHashSet(ContainerUtil.flatMap(types, RTypeUtil::flattenUnionAndIntersectionType))) {
            Symbol target = RTypeUtilCore.getBirthTypeSymbol((RType)type);
            if (target == null) continue;
            for (PsiElement declaration : target.getAllDeclarations(null)) {
                targets.add(PsiSymbolService.getInstance().asSymbol(declaration));
            }
        }
        List list = Collections.unmodifiableList(targets);
        if (list == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<? extends RType> getRubyTypes(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyGlobalVariableSymbol symbol) {
        if (project == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(6);
        }
        if (symbol == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(7);
        }
        ArrayList types = new ArrayList();
        RubyGlobalVariableDeclarationNameIndex.getInstance().processElements(project, searchScope, symbol.getName(), declaration -> {
            if (!(declaration instanceof RVariableBase)) {
                return true;
            }
            RVariableBase variable = (RVariableBase)declaration;
            SymbolicExpression expression = variable.getAssignedSymbolicExpression();
            if (expression == null) {
                return true;
            }
            RType type = (RType)ObjectUtils.doIfNotNull((Object)((SerializableType)expression.getAttributeValue((AttributeKey)TypeAttribute.INSTANCE)), it -> it.resolve(project, null));
            if (RTypeUtilCore.isNotEmpty((RType)type)) {
                types.add(type);
            }
            return true;
        });
        List list = Collections.unmodifiableList(types);
        if (list == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<? extends RType> getRubyTypes(@NotNull RubyNumberedParameterSymbol symbol) {
        ScopeHolder holder;
        RIdentifier identifier;
        RType type;
        if (symbol == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(9);
        }
        List<Object> list = RTypeUtilCore.isNotEmpty((RType)(type = RTypeUtil.getType((PsiElement)(identifier = (RIdentifier)ContainerUtil.find((Iterable)(holder = symbol.getScopeHolder()).getScope().getNumberedParameters((PsiElement)holder), it -> (it.isNumberedParameterAlias() ? "_1" : it.getText()).equals(symbol.getFullName())))))) ? List.of(type) : Collections.emptyList();
        if (list == null) {
            RubySymbolTypeProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/navigation/RubySymbolTypeProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/navigation/RubySymbolTypeProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolTypes";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRubyTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8, 10 -> new IllegalStateException(string);
        };
    }
}

