/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyGlobalVariableDeclarationNameIndex;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyTopLevelSymbolProvider;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;

public final class RubyStandardGlobalVariableSymbolProvider
implements RubyTopLevelSymbolProvider<RubyGlobalVariableSymbol> {
    private static final Key<Map<SearchScope, CachedValue<Set<String>>>> CACHE_KEY = Key.create((String)(RubyStandardGlobalVariableSymbolProvider.class.getName() + ".CACHE_KEY"));

    @Nullable
    public RubyGlobalVariableSymbol find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(2);
        }
        if (!RubyGlobalVariableDeclarationNameIndex.getInstance().containsElements(project, searchScope, name)) {
            return null;
        }
        return new RubyGlobalVariableSymbol(name);
    }

    @NotNull
    public Stream<RubyGlobalVariableSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(4);
        }
        Stream<RubyGlobalVariableSymbol> stream = RubyStandardGlobalVariableSymbolProvider.getGlobalVariableNames(project, searchScope).stream().map(RubyGlobalVariableSymbol::new);
        if (stream == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    private static Set<String> getGlobalVariableNames(@NotNull Project project, @NotNull SearchScope searchScope) {
        ConcurrentHashMap<SearchScope, CachedValue> cache;
        if (project == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(7);
        }
        if ((cache = (ConcurrentHashMap<SearchScope, CachedValue>)project.getUserData(CACHE_KEY)) == null) {
            cache = new ConcurrentHashMap<SearchScope, CachedValue>();
            project.putUserData(CACHE_KEY, cache);
        }
        Set set = (Set)cache.computeIfAbsent(searchScope, __ -> new CachedValueImpl((CachedValueProvider)new MyCachedValueProvider(project, searchScope))).getValue();
        if (set == null) {
            RubyStandardGlobalVariableSymbolProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/extensions/RubyStandardGlobalVariableSymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/extensions/RubyStandardGlobalVariableSymbolProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVariableNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalVariableNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }

    private record MyCachedValueProvider(Project project, SearchScope searchScope) implements CachedValueProvider<Set<String>>
    {
        @NotNull
        public CachedValueProvider.Result<Set<String>> compute() {
            Set names = RubyGlobalVariableDeclarationNameIndex.getInstance().getAllKeysWithElements(this.project, this.searchScope);
            ProjectRootManager rootTracker = ProjectRootManager.getInstance((Project)this.project);
            ModificationTracker indexTracker = ((StubIndexImpl)StubIndex.getInstance()).getIndexModificationTracker(RubyGlobalVariableDeclarationNameIndex.KEY, this.project);
            return new CachedValueProvider.Result((Object)names, new Object[]{rootTracker, indexTracker});
        }
    }
}

