/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyDeclarationFqnIndex;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyTopLevelSymbolProvider;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;

public final class RubyStandardConstantSymbolProvider
implements RubyTopLevelSymbolProvider<RubyConstantSymbol> {
    private static final Key<Map<SearchScope, CachedValue<Set<FQN>>>> CACHE_KEY = Key.create((String)(RubyStandardConstantSymbolProvider.class.getName() + ".CACHE_KEY"));

    @Nullable
    public RubyConstantSymbol find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull FQN fqn) {
        if (project == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(2);
        }
        return RubyStandardConstantSymbolProvider.getConstantFqns(project, searchScope).contains(fqn) ? new RubyConstantSymbol(fqn) : null;
    }

    @NotNull
    public Stream<RubyConstantSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(4);
        }
        Stream<RubyConstantSymbol> stream = RubyStandardConstantSymbolProvider.getConstantFqns(project, searchScope).stream().map(RubyConstantSymbol::new);
        if (stream == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    private static Set<FQN> getConstantFqns(@NotNull Project project, @NotNull SearchScope searchScope) {
        ConcurrentHashMap<SearchScope, CachedValue> cache;
        if (project == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(7);
        }
        if ((cache = (ConcurrentHashMap<SearchScope, CachedValue>)project.getUserData(CACHE_KEY)) == null) {
            cache = new ConcurrentHashMap<SearchScope, CachedValue>();
            project.putUserData(CACHE_KEY, cache);
        }
        Set set = (Set)cache.computeIfAbsent(searchScope, __ -> new CachedValueImpl((CachedValueProvider)new MyCachedValueProvider(project, searchScope))).getValue();
        if (set == null) {
            RubyStandardConstantSymbolProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/extensions/RubyStandardConstantSymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/extensions/RubyStandardConstantSymbolProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConstantFqns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }

    private record MyCachedValueProvider(Project project, SearchScope searchScope) implements CachedValueProvider<Set<FQN>>
    {
        @NotNull
        public CachedValueProvider.Result<Set<FQN>> compute() {
            Set fqns = RubyDeclarationFqnIndex.getAllValues((Project)this.project, (SearchScope)this.searchScope, (RubyDeclarationFqnIndex.Type)RubyDeclarationFqnIndex.Type.CONSTANT);
            ProjectRootManager rootTracker = ProjectRootManager.getInstance((Project)this.project);
            ModificationTracker indexTracker = () -> FileBasedIndex.getInstance().getIndexModificationStamp(RubyDeclarationFqnIndex.KEY, this.project);
            return new CachedValueProvider.Result((Object)fqns, new Object[]{rootTracker, indexTracker});
        }
    }
}

