/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl;

import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.UtilKt;

public final class RubySingletonSymbol
implements RubyContainerSymbol {
    private final RubyContainerSymbol myOriginalSymbol;
    private final boolean myIsAnonymous;

    public RubySingletonSymbol(@NotNull RubyContainerSymbol originalSymbol) {
        if (originalSymbol == null) {
            RubySingletonSymbol.$$$reportNull$$$0(0);
        }
        this.myOriginalSymbol = originalSymbol;
        this.myIsAnonymous = AnonymousDefiningCallType.isAnonymousFQN((FQN)originalSymbol.getFqn());
    }

    @NotNull
    public Pointer<RubySingletonSymbol> createPointer() {
        Pointer pointer = Pointer.delegatingPointer(this.myOriginalSymbol.createPointer(), RubySingletonSymbol::new);
        if (pointer == null) {
            RubySingletonSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myOriginalSymbol.equals(((RubySingletonSymbol)obj).myOriginalSymbol);
    }

    @Override
    @NotNull
    public FQN getFqn() {
        FQN fQN = this.myOriginalSymbol.getFqn();
        if (fQN == null) {
            RubySingletonSymbol.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @Override
    @NotNull
    public String getName() {
        String string = RBundle.message((String)"ruby.model.singleton.name");
        if (string == null) {
            RubySingletonSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public RubyContainerSymbol getOriginalSymbol() {
        RubyContainerSymbol rubyContainerSymbol = this.myOriginalSymbol;
        if (rubyContainerSymbol == null) {
            RubySingletonSymbol.$$$reportNull$$$0(4);
        }
        return rubyContainerSymbol;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        if (this.myIsAnonymous) {
            String name = RBundle.message((String)"ruby.model.singleton.name");
            @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.singleton.anonymous.shortDescription");
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.singleton.shortDescription", (Object[])new Object[]{name});
        FQN parentFqn = this.getFqn().getCallerFQN();
        if (parentFqn == FQN.INVALID) {
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.singleton.longDescription", (Object[])new Object[]{name, UtilKt.humanize(parentFqn)});
        return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = RBundle.message((String)"ruby.model.singleton.qualifiedName");
        if (string == null) {
            RubySingletonSymbol.$$$reportNull$$$0(5);
        }
        return string;
    }

    public int hashCode() {
        return this.myOriginalSymbol.hashCode();
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    @NotNull
    public String toString() {
        String string = "RubySingletonSymbol{myOriginalSymbol=%s}".formatted(this.myOriginalSymbol);
        if (string == null) {
            RubySingletonSymbol.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSymbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubySingletonSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubySingletonSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

