/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl;

import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.PsiElementNavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyGlobalVariableDeclarationNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.model.api.RubySymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyTopLevelSymbolProvider;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RubyGlobalVariableSymbol
implements RubySymbol,
NavigatableSymbol,
PresentableSymbol {
    @NlsSafe
    private final String myName;

    public RubyGlobalVariableSymbol(@NlsSafe @NotNull String name) {
        if (name == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NotNull
    public Pointer<RubyGlobalVariableSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myName.equals(((RubyGlobalVariableSymbol)obj).myName);
    }

    @NlsSafe
    @NotNull
    public String getFullName() {
        String string = "$" + this.myName;
        if (string == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(4);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        Function<PsiElement, TextRange> rangeInElementSupplier = element -> {
            if (element instanceof RAliasStatement) {
                RAliasStatement aliasStatement = (RAliasStatement)element;
                return Objects.requireNonNull(aliasStatement.getPsiNewName()).getTextRangeInParent().shiftRight(1).grown(-1);
            }
            if (element instanceof RGlobalVariable) {
                return TextRange.from((int)1, (int)(element.getTextLength() - 1));
            }
            throw new UnsupportedOperationException("Unrecognised class: " + String.valueOf(element.getClass()));
        };
        List<PsiElementNavigationTarget> list = RubyGlobalVariableDeclarationNameIndex.getInstance().getElements(project, (SearchScope)maximalSearchScope, this.myName).stream().map(it -> new PsiElementNavigationTarget<RPsiElement>((RPsiElement)it, (Function<RPsiElement, TextRange>)rangeInElementSupplier, TargetPresentationUtil.createTargetPresentation(this, (PsiElement)it))).sorted().toList();
        if (list == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(5);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.global.variable.shortDescription", (Object[])new Object[]{this.myName});
        return new SymbolPresentation(AllIcons.Nodes.Gvariable, this.myName, shortDescriptionSupplier);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @NotNull
    public String toString() {
        String string = "RubyGlobalVariableSymbol{myName='%s'}".formatted(this.myName);
        if (string == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(6);
        }
        return string;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RubyGlobalVariableSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull String name) {
        if (project == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(8);
        }
        if (name == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.softAssertReadAccess();
        for (RubyTopLevelSymbolProvider provider : RubyTopLevelSymbolProvider.EP.forKey(RubyGlobalVariableSymbol.class)) {
            RubySymbol rubySymbol = provider.find(project, searchScope, name);
            if (!(rubySymbol instanceof RubyGlobalVariableSymbol)) continue;
            RubyGlobalVariableSymbol symbol = (RubyGlobalVariableSymbol)rubySymbol;
            Optional<RubyGlobalVariableSymbol> optional = Optional.of(symbol);
            if (optional == null) {
                RubyGlobalVariableSymbol.$$$reportNull$$$0(10);
            }
            return optional;
        }
        Optional<RubyGlobalVariableSymbol> optional = Optional.empty();
        if (optional == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(11);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RubyGlobalVariableSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.softAssertReadAccess();
        Stream<RubyGlobalVariableSymbol> stream = RubyTopLevelSymbolProvider.EP.forKey(RubyGlobalVariableSymbol.class).stream().flatMap(it -> it.stream(project, searchScope)).mapMulti(StreamUtil.select(RubyGlobalVariableSymbol.class, (Class[])new Class[0])).distinct();
        if (stream == null) {
            RubyGlobalVariableSymbol.$$$reportNull$$$0(14);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyGlobalVariableSymbol";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyGlobalVariableSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 10, 11, 14 -> new IllegalStateException(string);
        };
    }
}

