/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl;

import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubySymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyTopLevelSymbolProvider;
import org.jetbrains.plugins.ruby.ruby.model.impl.UtilKt;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public final class RubyConstantSymbol
implements RubyQualifiedNameSymbol {
    private final FQN myFqn;

    public RubyConstantSymbol(@NotNull FQN fqn) {
        if (fqn == null) {
            RubyConstantSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
    }

    @NotNull
    public Pointer<RubyConstantSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RubyConstantSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.equals(((RubyConstantSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public FQN getFqn() {
        FQN fQN = this.myFqn;
        if (fQN == null) {
            RubyConstantSymbol.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.constant.shortDescription", (Object[])new Object[]{name});
        FQN parentFqn = this.myFqn.getCallerFQN();
        if (parentFqn == FQN.INVALID) {
            return new SymbolPresentation(AllIcons.Nodes.Constant, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.constant.longDescription", (Object[])new Object[]{name, UtilKt.humanize(parentFqn)});
        return new SymbolPresentation(AllIcons.Nodes.Constant, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    @NotNull
    public String toString() {
        String string = "RubyConstantSymbol{myFqn=%s}".formatted(this.myFqn);
        if (string == null) {
            RubyConstantSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RubyConstantSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull FQN fqn) {
        if (project == null) {
            RubyConstantSymbol.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RubyConstantSymbol.$$$reportNull$$$0(5);
        }
        if (fqn == null) {
            RubyConstantSymbol.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == FQN.INVALID) {
            Optional<RubyConstantSymbol> optional = Optional.empty();
            if (optional == null) {
                RubyConstantSymbol.$$$reportNull$$$0(7);
            }
            return optional;
        }
        FQN normalizedFqn = fqn.normalize();
        for (RubyTopLevelSymbolProvider provider : RubyTopLevelSymbolProvider.EP.forKey(RubyConstantSymbol.class)) {
            RubySymbol rubySymbol = provider.find(project, searchScope, normalizedFqn);
            if (!(rubySymbol instanceof RubyConstantSymbol)) continue;
            RubyConstantSymbol symbol = (RubyConstantSymbol)rubySymbol;
            Optional<RubyConstantSymbol> optional = Optional.of(symbol);
            if (optional == null) {
                RubyConstantSymbol.$$$reportNull$$$0(8);
            }
            return optional;
        }
        Optional<RubyConstantSymbol> optional = Optional.empty();
        if (optional == null) {
            RubyConstantSymbol.$$$reportNull$$$0(9);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RubyConstantSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyConstantSymbol.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            RubyConstantSymbol.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.softAssertReadAccess();
        SmartCancellationChecker checker = new SmartCancellationChecker(1000);
        Stream<RubyConstantSymbol> stream = RubyTopLevelSymbolProvider.EP.forKey(RubyConstantSymbol.class).stream().flatMap(it -> it.stream(project, searchScope)).mapMulti(StreamUtil.select(RubyConstantSymbol.class, (Class[])new Class[0])).distinct().peek(__ -> checker.checkCancelled());
        if (stream == null) {
            RubyConstantSymbol.$$$reportNull$$$0(12);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyConstantSymbol";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyConstantSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 8, 9, 12 -> new IllegalStateException(string);
        };
    }
}

