/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.impl;

import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubySymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyTopLevelSymbolProvider;
import org.jetbrains.plugins.ruby.ruby.model.impl.UtilKt;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public final class RubyClassSymbol
implements RubyContainerSymbol {
    private final FQN myFqn;
    private final boolean myIsAnonymous;

    public RubyClassSymbol(@NotNull FQN fqn) {
        if (fqn == null) {
            RubyClassSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
        this.myIsAnonymous = AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn);
    }

    @NotNull
    public Pointer<RubyClassSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RubyClassSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.equals(((RubyClassSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public FQN getFqn() {
        FQN fQN = this.myFqn;
        if (fQN == null) {
            RubyClassSymbol.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.isAnonymous() ? RBundle.message((String)"ruby.model.class.anonymous.name") : RubyContainerSymbol.super.getName();
        if (string == null) {
            RubyClassSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.isAnonymous() ? RBundle.message((String)"ruby.model.class.anonymous.qualifiedName") : RubyContainerSymbol.super.getQualifiedName();
        if (string == null) {
            RubyClassSymbol.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        if (this.myIsAnonymous) {
            String name = RBundle.message((String)"ruby.model.class.anonymous.name");
            @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.class.anonymous.shortDescription");
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.class.shortDescription", (Object[])new Object[]{name});
        FQN parentFqn = this.myFqn.getCallerFQN();
        if (parentFqn == FQN.INVALID) {
            return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RBundle.messagePointer((String)"ruby.model.class.longDescription", (Object[])new Object[]{name, UtilKt.humanize(parentFqn)});
        return new SymbolPresentation(AllIcons.Nodes.Class, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    @NotNull
    public String toString() {
        String string = "RubyClassSymbol{myFqn=%s}".formatted(this.myFqn);
        if (string == null) {
            RubyClassSymbol.$$$reportNull$$$0(5);
        }
        return string;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RubyClassSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull FQN fqn) {
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(7);
        }
        if (fqn == null) {
            RubyClassSymbol.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == FQN.INVALID) {
            Optional<RubyClassSymbol> optional = Optional.empty();
            if (optional == null) {
                RubyClassSymbol.$$$reportNull$$$0(9);
            }
            return optional;
        }
        FQN normalizedFqn = fqn.normalize();
        for (RubyTopLevelSymbolProvider provider : RubyTopLevelSymbolProvider.EP.forKey(RubyClassSymbol.class)) {
            RubySymbol rubySymbol = provider.find(project, searchScope, normalizedFqn);
            if (!(rubySymbol instanceof RubyClassSymbol)) continue;
            RubyClassSymbol symbol = (RubyClassSymbol)rubySymbol;
            Optional<RubyClassSymbol> optional = Optional.of(symbol);
            if (optional == null) {
                RubyClassSymbol.$$$reportNull$$$0(10);
            }
            return optional;
        }
        Optional<RubyClassSymbol> optional = Optional.empty();
        if (optional == null) {
            RubyClassSymbol.$$$reportNull$$$0(11);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RubyClassSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubyClassSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RubyClassSymbol.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.softAssertReadAccess();
        SmartCancellationChecker checker = new SmartCancellationChecker(1000);
        Stream<RubyClassSymbol> stream = RubyTopLevelSymbolProvider.EP.forKey(RubyClassSymbol.class).stream().flatMap(it -> it.stream(project, searchScope)).mapMulti(StreamUtil.select(RubyClassSymbol.class, (Class[])new Class[0])).distinct().peek(__ -> checker.checkCancelled());
        if (stream == null) {
            RubyClassSymbol.$$$reportNull$$$0(14);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 9, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyClassSymbol";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/impl/RubyClassSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 9, 10, 11, 14 -> new IllegalStateException(string);
        };
    }
}

