/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.documentation;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.model.Pointer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.model.documentation.RubyDocumentationChunk;
import org.jetbrains.plugins.ruby.ruby.model.documentation.RubyDocumentationTargetBase;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;

@ApiStatus.Internal
public final class RubyGlobalVariableDocumentationTarget
extends RubyDocumentationTargetBase<RubyGlobalVariableSymbol> {
    @Nullable
    private final PsiElement myDeclaration;

    RubyGlobalVariableDocumentationTarget(@NotNull Project project, @NotNull RubyGlobalVariableSymbol symbol) {
        if (project == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(1);
        }
        super(project, symbol);
        this.myDeclaration = null;
    }

    @ApiStatus.Internal
    public RubyGlobalVariableDocumentationTarget(@NotNull Project project, @NotNull RubyGlobalVariableSymbol symbol, @NotNull PsiElement declaration) {
        if (project == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(2);
        }
        if (symbol == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(3);
        }
        if (declaration == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(4);
        }
        super(project, symbol);
        this.myDeclaration = declaration;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        if (this.myDeclaration == null) {
            return null;
        }
        @Nls StringBuilder sb = new StringBuilder();
        sb.append("<div class='definition'><pre>");
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)sb, (Project)this.myProject, (Language)RubyLanguage.INSTANCE, (String)((RubyGlobalVariableSymbol)this.mySymbol).getFullName());
        sb.append("</pre></div>");
        RubyDocumentationChunk.declaration(this.myDeclaration).appendTo(sb);
        return DocumentationResult.documentation((String)sb.toString());
    }

    @NlsContexts.HintText
    @NotNull
    public String computeDocumentationHint() {
        String string = RubyDocumentationChunk.highlighted(RubyHighlighter.GVAR, ((RubyGlobalVariableSymbol)this.mySymbol).getFullName());
        if (string == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        if (this.myDeclaration == null) {
            TargetPresentation targetPresentation = TargetPresentation.builder((String)((RubyGlobalVariableSymbol)this.mySymbol).getName()).icon(((RubyGlobalVariableSymbol)this.mySymbol).getPresentation().icon()).presentation();
            if (targetPresentation == null) {
                RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(6);
            }
            return targetPresentation;
        }
        TargetPresentation targetPresentation = TargetPresentationUtil.createTargetPresentation((PresentableSymbol)this.mySymbol, this.myDeclaration);
        if (targetPresentation == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(7);
        }
        return targetPresentation;
    }

    @Override
    @NotNull
    public Pointer<RubyGlobalVariableDocumentationTarget> createPointer() {
        Pointer<RubyGlobalVariableSymbol> symbolPointer = ((RubyGlobalVariableSymbol)this.mySymbol).createPointer();
        SmartPsiElementPointer declarationPointer = this.myDeclaration != null ? SmartPointerManager.createPointer((PsiElement)this.myDeclaration) : null;
        Pointer pointer = () -> {
            if (this.myProject.isDisposed()) {
                return null;
            }
            RubyGlobalVariableSymbol symbol = (RubyGlobalVariableSymbol)symbolPointer.dereference();
            if (symbol == null || declarationPointer == null) {
                return symbol != null ? new RubyGlobalVariableDocumentationTarget(this.myProject, symbol) : null;
            }
            PsiElement declaration = declarationPointer.dereference();
            return declaration != null ? new RubyGlobalVariableDocumentationTarget(this.myProject, symbol, declaration) : null;
        };
        if (pointer == null) {
            RubyGlobalVariableDocumentationTarget.$$$reportNull$$$0(8);
        }
        return pointer;
    }

    @Nullable
    public Navigatable getNavigatable() {
        int offset;
        if (this.myDeclaration == null) {
            return null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)this.myDeclaration);
        PsiElement psiElement = this.myDeclaration;
        if (psiElement instanceof RAliasStatement) {
            RAliasStatement aliasStatement = (RAliasStatement)psiElement;
            RPsiElement nameElement = aliasStatement.getPsiNewName();
            if (nameElement == null) {
                return null;
            }
            offset = this.myDeclaration.getTextRange().getStartOffset() + nameElement.getTextRangeInParent().getStartOffset() + 1;
        } else if (this.myDeclaration instanceof RGlobalVariable) {
            offset = this.myDeclaration.getTextRange().getStartOffset() + 1;
        } else {
            throw new UnsupportedOperationException("Unrecognised class: " + String.valueOf(this.myDeclaration.getClass()));
        }
        return file != null ? new OpenFileDescriptor(this.myProject, file, offset) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/documentation/RubyGlobalVariableDocumentationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/documentation/RubyGlobalVariableDocumentationTarget";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDocumentationHint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

