/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.model.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.cache.IdempotentCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;

@Service(value={Service.Level.PROJECT})
public final class RubySymbolsCache
implements Disposable {
    private final Project myProject;
    private final LoadingCache<@NotNull SearchScope, @NotNull Instance> myCache;
    private final AtomicLong myStamp;

    public RubySymbolsCache(@NotNull Project project) {
        if (project == null) {
            RubySymbolsCache.$$$reportNull$$$0(0);
        }
        this.myStamp = new AtomicLong();
        this.myProject = project;
        this.myCache = Caffeine.newBuilder().build(__ -> new Instance(project));
        LowMemoryWatcher.register(() -> this.myCache.invalidateAll(), (Disposable)this);
    }

    public void dispose() {
        this.myCache.invalidateAll();
    }

    @RequiresReadLock
    @NotNull
    private Instance getCache(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            RubySymbolsCache.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        long stamp = ProjectRootManager.getInstance((Project)this.myProject).getModificationCount();
        for (ModificationTracker modificationTracker : RubyModificationTrackers.getModelModificationTrackers(this.myProject)) {
            stamp += modificationTracker.getModificationCount();
        }
        if (this.myStamp.getAndSet(stamp) != stamp) {
            this.myCache.invalidateAll();
        }
        Instance instance = (Instance)this.myCache.get((Object)searchScope);
        if (instance == null) {
            RubySymbolsCache.$$$reportNull$$$0(2);
        }
        return instance;
    }

    @NotNull
    public static Instance getInstance(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RubySymbolsCache.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RubySymbolsCache.$$$reportNull$$$0(4);
        }
        return ((RubySymbolsCache)project.getService(RubySymbolsCache.class)).getCache(searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/cache/RubySymbolsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/cache/RubySymbolsCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class Instance {
        private final Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> myAllAncestors;
        private final Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> myAncestors;
        private final Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyQualifiedNameSymbol>> myConstants;
        private final Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> mySuperclasses;

        private Instance(@NotNull Project project) {
            if (project == null) {
                Instance.$$$reportNull$$$0(0);
            }
            this.myAllAncestors = new IdempotentCache<RubyContainerSymbol, List<RubyContainerSymbol>>(project, Caffeine.newBuilder().maximumSize(1000L).build());
            this.myAncestors = new IdempotentCache<RubyContainerSymbol, List<RubyContainerSymbol>>(project, Caffeine.newBuilder().maximumSize(1000L).build());
            this.myConstants = new IdempotentCache<RubyContainerSymbol, List<RubyQualifiedNameSymbol>>(project, Caffeine.newBuilder().maximumSize(1000L).build());
            this.mySuperclasses = new IdempotentCache<RubyContainerSymbol, List<RubyContainerSymbol>>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        }

        @NotNull
        public @NotNull Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> getAllAncestors() {
            Cache<RubyContainerSymbol, List<RubyContainerSymbol>> cache = this.myAllAncestors;
            if (cache == null) {
                Instance.$$$reportNull$$$0(1);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> getAncestors() {
            Cache<RubyContainerSymbol, List<RubyContainerSymbol>> cache = this.myAncestors;
            if (cache == null) {
                Instance.$$$reportNull$$$0(2);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyQualifiedNameSymbol>> getConstants() {
            Cache<RubyContainerSymbol, List<RubyQualifiedNameSymbol>> cache = this.myConstants;
            if (cache == null) {
                Instance.$$$reportNull$$$0(3);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull RubyContainerSymbol, @NotNull List<RubyContainerSymbol>> getSuperclasses() {
            Cache<RubyContainerSymbol, List<RubyContainerSymbol>> cache = this.mySuperclasses;
            if (cache == null) {
                Instance.$$$reportNull$$$0(4);
            }
            return cache;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/model/cache/RubySymbolsCache$Instance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/model/cache/RubySymbolsCache$Instance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllAncestors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAncestors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstants";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuperclasses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

