/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.structure;

import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.symbol.SymbolBasedStructureViewModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.psi.PsiSymbolDeclarationService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.CallTypeWithStructurePresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyNaturalOrderSorter;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewCustomizer;
import org.jetbrains.plugins.ruby.ruby.lang.structure.RubyStructureViewElement;

public class RubyStructureViewModel
extends SymbolBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider,
StructureViewModel.ExpandInfoProvider {
    @Nullable
    private final Module myModule;
    protected static final Class[] SUITABLE_CLASSES = (Class[])ContainerUtil.ar((Object[])new Class[]{RFile.class, RModule.class, RClass.class, RObjectClass.class, RMethod.class, RSingletonMethod.class, RAliasStatement.class, RField.class, RCall.class, RConstant.class, RGlobalVariable.class});
    private static final String DEFAULTS_CONFIGURED = "ruby.structure.view.model.defaults.configured";

    public RubyStructureViewModel(@NotNull RFile file, @Nullable Editor editor) {
        if (file == null) {
            RubyStructureViewModel.$$$reportNull$$$0(0);
        }
        super(editor, (PsiFile)file);
        this.myModule = ModuleUtilCore.findModuleForFile((PsiFile)file);
        RubyStructureViewModel.configureDefaults(file.getProject());
    }

    public Filter @NotNull [] getFilters() {
        RubyStructureViewCustomizer filterProvider = (RubyStructureViewCustomizer)RubyStructureViewCustomizer.EP_NAME.findFirstSafe(it -> it.isApplicable((PsiFile)this.getPsiFile(), this.myModule));
        Filter[] filterArray = filterProvider == null ? super.getFilters() : (Filter[])ArrayUtil.mergeArrays((Object[])super.getFilters(), (Object[])filterProvider.getFilters().toArray(Filter.EMPTY_ARRAY));
        if (filterArray == null) {
            RubyStructureViewModel.$$$reportNull$$$0(1);
        }
        return filterArray;
    }

    @NotNull
    public Collection<NodeProvider<?>> getNodeProviders() {
        RubyStructureViewCustomizer nodeProvider = (RubyStructureViewCustomizer)RubyStructureViewCustomizer.EP_NAME.findFirstSafe(it -> it.isApplicable((PsiFile)this.getPsiFile(), this.myModule));
        List<Object> list = nodeProvider == null ? Collections.emptyList() : nodeProvider.getNodeProviders();
        if (list == null) {
            RubyStructureViewModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected RFile getPsiFile() {
        return (RFile)super.getPsiFile();
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new RubyStructureViewElement((RPsiElement)this.getPsiFile());
    }

    protected Class @NotNull [] getSuitableClasses() {
        if (SUITABLE_CLASSES == null) {
            RubyStructureViewModel.$$$reportNull$$$0(3);
        }
        return SUITABLE_CLASSES;
    }

    protected boolean isSuitable(PsiElement element) {
        if (!super.isSuitable(element)) {
            return !PsiSymbolDeclarationService.getInstance().getDeclarations(element).isEmpty();
        }
        return !(element instanceof RPossibleCall) || ((RPossibleCall)element).getCallType() instanceof CallTypeWithStructurePresentation || element instanceof RConstant && element.getParent() instanceof RAssignmentExpression;
    }

    public Sorter @NotNull [] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER, RubyNaturalOrderSorter.INSTANCE};
        if (sorterArray == null) {
            RubyStructureViewModel.$$$reportNull$$$0(4);
        }
        return sorterArray;
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof RClass;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof RClass || value instanceof RModule;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof RAliasStatement || value instanceof RField || value instanceof RConstant;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            RubyStructureViewModel.$$$reportNull$$$0(5);
        }
        return false;
    }

    public boolean isSmartExpand() {
        return true;
    }

    private static void configureDefaults(@NotNull Project project) {
        PropertiesComponent component;
        if (project == null) {
            RubyStructureViewModel.$$$reportNull$$$0(6);
        }
        if ((component = PropertiesComponent.getInstance((Project)project)).getBoolean(DEFAULTS_CONFIGURED, false)) {
            return;
        }
        component.setValue(DEFAULTS_CONFIGURED, true);
        StructureViewFactoryEx.getInstanceEx((Project)project).setActiveAction("SHOW_MIGRATION_FIELDS", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/structure/RubyStructureViewModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/structure/RubyStructureViewModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureDefaults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

