/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.symbol.PsiSymbolTreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.psi.PsiSymbolDeclarationService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RGlobalVarHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.CallTypeWithStructurePresentation;

public class RubyStructureViewElement
extends PsiTreeElementBase<RPsiElement> {
    private final boolean myInherited;

    public RubyStructureViewElement(@Nullable RPsiElement element) {
        this(element, false);
    }

    public RubyStructureViewElement(@Nullable RPsiElement element, boolean inherited) {
        super((PsiElement)element);
        this.myInherited = inherited;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        RPsiElement element = (RPsiElement)this.getElement();
        if (element == null) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                RubyStructureViewElement.$$$reportNull$$$0(0);
            }
            return list;
        }
        LinkedHashSet<RPsiElement> elements = new LinkedHashSet<RPsiElement>();
        if (this.canElementHaveChildren()) {
            List<? extends RPsiElement> childrenList = this.getElementPsiChildren();
            for (RPsiElement rPsiElement : childrenList) {
                this.processPsiChild(rPsiElement, elements);
            }
            if (!this.myInherited && element instanceof RGlobalVarHolder) {
                elements.addAll(((RGlobalVarHolder)element).getGlobalVarDefinitions());
            }
            if (!this.myInherited && element instanceof RConstantHolder) {
                elements.addAll(((RConstantHolder)element).getConstantDeclarations());
            }
            if (element instanceof RFieldHolder) {
                elements.addAll(((RFieldHolder)element).getFieldsDeclarations());
            }
        }
        List list = ContainerUtil.flatMap(elements, it -> {
            Collection declarations = PsiSymbolDeclarationService.getInstance().getDeclarations((PsiElement)it);
            return !declarations.isEmpty() ? ContainerUtil.map((Collection)declarations, PsiSymbolTreeElement::new) : List.of(this.createTreeElement((RPsiElement)it, this.myInherited));
        });
        if (list == null) {
            RubyStructureViewElement.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected boolean canElementHaveChildren() {
        if (RubyPsiUtil.isCallOfType((PsiElement)this.getOriginalElement(), CallTypeWithStructurePresentation.class::isInstance)) {
            RPossibleCall call = (RPossibleCall)this.getOriginalElement();
            return ((CallTypeWithStructurePresentation)call.getCallType()).canHaveChildren(call);
        }
        return this.getElement() instanceof RContainer;
    }

    @NotNull
    protected RubyStructureViewElement createTreeElement(@NotNull RPsiElement element, boolean inherited) {
        if (element == null) {
            RubyStructureViewElement.$$$reportNull$$$0(2);
        }
        if (RubyPsiUtil.isCallOfType((PsiElement)element, CallTypeWithStructurePresentation.class::isInstance)) {
            RPossibleCall call = (RPossibleCall)element;
            return new RubyStructureViewElement(((CallTypeWithStructurePresentation)call.getCallType()).getStructureViewElement(call), inherited);
        }
        return new RubyStructureViewElement(element, inherited);
    }

    protected List<? extends RPsiElement> getElementPsiChildren() {
        RPsiElement element = (RPsiElement)this.getElement();
        if (RubyPsiUtil.isCallOfType((PsiElement)this.getOriginalElement(), CallTypeWithStructurePresentation.class::isInstance)) {
            RPossibleCall call = (RPossibleCall)this.getOriginalElement();
            return ((CallTypeWithStructurePresentation)call.getCallType()).getChildren(call);
        }
        if (element instanceof RContainer) {
            return ((RContainer)element).getStructureElements();
        }
        return Collections.emptyList();
    }

    protected boolean processPsiChild(@NotNull RPsiElement child, @NotNull Collection<RPsiElement> elements) {
        if (child == null) {
            RubyStructureViewElement.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            RubyStructureViewElement.$$$reportNull$$$0(4);
        }
        if (child instanceof RContainer) {
            if (!this.myInherited || !(child instanceof RMethodHolder)) {
                elements.add(child);
                return true;
            }
        } else if (child instanceof RAliasStatement || child instanceof RPossibleCall && ((RPossibleCall)child).getCallType() instanceof CallTypeWithStructurePresentation) {
            elements.add(child);
            return true;
        }
        return false;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        final ItemPresentation presentation = (ItemPresentation)ObjectUtils.doIfNotNull((Object)this.getOriginalElement(), NavigationItem::getPresentation);
        if (presentation == null) {
            RubyStructureViewElement rubyStructureViewElement = this;
            if (rubyStructureViewElement == null) {
                RubyStructureViewElement.$$$reportNull$$$0(5);
            }
            return rubyStructureViewElement;
        }
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return presentation.getPresentableText();
            }

            public String getLocationString() {
                if (!RubyStructureViewElement.this.myInherited || RubyStructureViewElement.this.getElement() == null) {
                    return null;
                }
                return (String)ObjectUtils.doIfNotNull((Object)presentation.getLocationString(), it -> UIUtil.rightArrow() + it.replaceAll("\\(|\\)|( in .*)", ""));
            }

            public Icon getIcon(boolean open) {
                return presentation.getIcon(open);
            }

            public TextAttributesKey getTextAttributesKey() {
                if (RubyStructureViewElement.this.myInherited) {
                    return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
                }
                return (TextAttributesKey)ObjectUtils.doIfCast((Object)presentation, ColoredItemPresentation.class, ColoredItemPresentation::getTextAttributesKey);
            }
        };
    }

    public boolean canNavigateToSource() {
        RPsiElement element = (RPsiElement)this.getElement();
        return element != null && element.canNavigateToSource();
    }

    @Nullable
    public String getPresentableText() {
        return null;
    }

    @Nullable
    protected RPsiElement getOriginalElement() {
        RPsiElement element = (RPsiElement)this.getElement();
        return element == null ? null : (RPsiElement)ObjectUtils.coalesce((Object)ArgumentFakePsiElement.getCallByArgument((PsiElement)element), (Object)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/structure/RubyStructureViewElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/structure/RubyStructureViewElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTreeElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processPsiChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

