/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.search;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.AttributeFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.search.RubyFindUsagesSecondaryElementsProvider;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriding.RubyOverridingMethodsSearch;

final class RubyFindUsagesHandler
extends FindUsagesHandler {
    RubyFindUsagesHandler(PsiElement psiElement) {
        super(psiElement);
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        RCall call = RubyPsiUtil.getCoveringRCall(this.getPsiElement());
        if (call != null) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            RubyCallTypes.processElementsAtArgument(call, this.getPsiElement(), null, (Processor<? super PsiElement>)collector);
            PsiElement[] elements = (PsiElement[])collector.getResults().stream().filter(element -> !(element instanceof AttributeFakePsiElement)).toArray(PsiElement[]::new);
            if (elements.length > 0) {
                if (elements == null) {
                    RubyFindUsagesHandler.$$$reportNull$$$0(0);
                }
                return elements;
            }
        }
        PsiElement[] psiElementArray = super.getPrimaryElements();
        if (psiElementArray == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        PsiElement[] psiElementArray = RubyFindUsagesSecondaryElementsProvider.getAllSecondaryElements(this.myPsiElement).toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<? super UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(4);
        }
        if (options == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(5);
        }
        if (!super.processElementUsages(element, processor, options)) {
            return false;
        }
        if (!options.isUsages) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (element instanceof RClass || element instanceof RModule) {
                for (PsiElement psiElement : RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)element, false, element)) {
                    if (RubyFindUsagesHandler.processClassOrModulePartialDeclaration(psiElement, processor)) continue;
                    return false;
                }
            }
            if (element instanceof RMethod && !this.processMethodUsages((RMethod)element, processor, options)) {
                return false;
            }
            return true;
        });
    }

    private boolean processMethodUsages(@NotNull RMethod method, @NotNull Processor<? super UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (method == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(7);
        }
        if (options == null) {
            RubyFindUsagesHandler.$$$reportNull$$$0(8);
        }
        return RubyOverridingMethodsSearch.search(method).forEach(overridingMethod -> ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters((PsiElement)overridingMethod, options.searchScope, options)).forEach(ref -> processor.process((Object)new UsageInfo(ref))));
    }

    private static boolean processClassOrModulePartialDeclaration(PsiElement psiElement, Processor<? super UsageInfo> processor) {
        RName namedElement = null;
        if (psiElement instanceof RClass) {
            namedElement = ((RClass)psiElement).getClassName();
        } else if (psiElement instanceof RModule) {
            namedElement = ((RModule)psiElement).getModuleName();
        }
        if (namedElement == null) {
            return true;
        }
        int startRange = namedElement.getTextOffset() - RubyPsiUtil.getOriginalTextOffset(psiElement);
        int endRange = startRange + namedElement.getTextLength();
        return processor.process((Object)new UsageInfo(psiElement, startRange, endRange, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/search/RubyFindUsagesHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/search/RubyFindUsagesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMethodUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

