/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.search;

import com.intellij.CommonBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.findUsages.RubyFindUsagesProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.search.RubyFindUsagesHandler;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;

public final class RubyFindUsagesFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(0);
        }
        return new RubyFindUsagesProvider().canFindUsagesFor(element);
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(1);
        }
        FindUsagesHandler findUsagesHandler = this.createFindUsagesHandler(element, forHighlightUsages ? FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES : FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS);
        if (findUsagesHandler == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(2);
        }
        return findUsagesHandler;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        if (element == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(3);
        }
        if (operationMode == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(4);
        }
        return new RubyFindUsagesHandler(operationMode == FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS ? RubyFindUsagesFactory.getTargetArgument(element) : element);
    }

    @NotNull
    private static PsiElement getTargetArgument(@NotNull PsiElement element) {
        RMethod method;
        PsiElement superMethod;
        if (element == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(5);
        }
        if (element instanceof RMethod && (superMethod = RubyFindUsagesFactory.getSuperMethod(method = (RMethod)element)) != null && RubyFindUsagesFactory.askShouldSearchForSuperMethod(method.getProject(), method, superMethod)) {
            PsiElement psiElement = superMethod;
            if (psiElement == null) {
                RubyFindUsagesFactory.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    private static boolean askShouldSearchForSuperMethod(@NotNull Project project, @NotNull RMethod method, @NotNull PsiElement superMethod) {
        if (project == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(8);
        }
        if (method == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(9);
        }
        if (superMethod == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(10);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String name = method.getName();
        RContainer superContainer = RubyPsiUtilCore.getParentContainer((PsiElement)superMethod);
        if (StringUtil.isEmpty((String)name) || superContainer == null) {
            return false;
        }
        Type superType = superContainer.getSymbolType();
        String superName = superContainer.getFQNWithNesting().getFullPath();
        if (superType == null || StringUtil.isEmpty((String)superName)) {
            return false;
        }
        return Messages.showOkCancelDialog((Project)project, (String)RubyFindUsagesFactory.getDialogMessage(name, StringUtil.notNullize((String)superType.getPresentableName()), superName), (String)RBundle.message((String)"find.usages.search.for.super.title"), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getDialogMessage(@NotNull @NlsSafe String name, @NotNull @NlsSafe String superTypePresentableName, @NotNull @NlsSafe String superName) {
        if (name == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(11);
        }
        if (superTypePresentableName == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(12);
        }
        if (superName == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(13);
        }
        String string = new HtmlBuilder().appendRaw(RBundle.message((String)"find.usages.search.for.super.message", (Object[])new Object[]{RubyFindUsagesFactory.bold(name), RubyFindUsagesFactory.bold(superTypePresentableName), RubyFindUsagesFactory.bold(superName)})).wrapWithHtmlBody().toString();
        if (string == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static HtmlChunk.Element bold(@NotNull @NlsSafe String text) {
        if (text == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(15);
        }
        HtmlChunk.Element element = HtmlChunk.text((String)text).bold();
        if (element == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(16);
        }
        return element;
    }

    @Nullable
    private static PsiElement getSuperMethod(@NotNull RMethod method) {
        if (method == null) {
            RubyFindUsagesFactory.$$$reportNull$$$0(17);
        }
        return RubySuperMethodsSearch.search(method).findAll().stream().map(Symbol::getPsiElement).reduce(null, (first, second) -> second);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/search/RubyFindUsagesFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationMode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypePresentableName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/search/RubyFindUsagesFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindUsagesHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetArgument";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "bold";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetArgument";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "askShouldSearchForSuperMethod";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDialogMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "bold";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 14, 16 -> new IllegalStateException(string);
        };
    }
}

