/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyRequireLoadIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeReferenceContributorsRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyFileCallType;

public final class RubyFileReferenceSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters params, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement elementToSearch;
        if (params == null) {
            RubyFileReferenceSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            RubyFileReferenceSearch.$$$reportNull$$$0(1);
        }
        if (!((elementToSearch = params.getElementToSearch()) instanceof RFile)) {
            return true;
        }
        RFile fileToSearch = (RFile)elementToSearch;
        String name = (String)ReadAction.compute(() -> {
            VirtualFile vFile = fileToSearch.getVirtualFile();
            return vFile != null ? vFile.getNameWithoutExtension() : null;
        });
        if (StringUtil.isEmpty((String)name)) {
            return true;
        }
        Project project = fileToSearch.getProject();
        SearchScope searchScope = params.getEffectiveSearchScope();
        return (Boolean)ReadAction.compute(() -> {
            for (RPossibleCall call : RubyRequireLoadIndex.getInstance().getElements(project, searchScope, name)) {
                RubyCallType callType = call.getCallType();
                if (!(callType instanceof RubyFileCallType)) continue;
                for (PsiReference reference : RubyCallTypeReferenceContributorsRegistry.createReferences((RubyCallType)callType, (RPossibleCall)call, (List)call.getArguments())) {
                    if (!ResolveUtil.isReferenceTo(reference, (PsiElement)fileToSearch) || consumer.process((Object)reference)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "params";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/lang/search/RubyFileReferenceSearch";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

