/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.rename;

import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;
import org.jetbrains.plugins.ruby.ruby.usages.rules.RubySymbolFilteringSettings;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RubyRenameProcessor
extends RenamePsiElementProcessor {
    public static final ExtensionPointName<RenameProcessor> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.rubyRenameProcessor");
    private boolean myForceShowPreview;

    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            RubyRenameProcessor.$$$reportNull$$$0(1);
        }
        if (elementListener == null) {
            RubyRenameProcessor.$$$reportNull$$$0(2);
        }
        for (RenameProcessor processor : EP_NAME.getExtensionList()) {
            if (processor.getPostRenameCallback(element, newName, elementListener) == null) continue;
            return processor.getPostRenameCallback(element, newName, elementListener);
        }
        return null;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            RubyRenameProcessor.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiFile) {
            return new RenamePsiFileProcessor.PsiFileRenameDialog(project, element, nameSuggestionContext, editor);
        }
        RenameDialog renameDialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
        if (renameDialog == null) {
            RubyRenameProcessor.$$$reportNull$$$0(5);
        }
        return renameDialog;
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(6);
        }
        if (ref == null) {
            RubyRenameProcessor.$$$reportNull$$$0(7);
        }
        if (referenceElement == null) {
            RubyRenameProcessor.$$$reportNull$$$0(8);
        }
        if (!(element instanceof RPsiElement)) {
            UsageInfo usageInfo = super.createUsageInfo(element, ref, referenceElement);
            if (usageInfo == null) {
                RubyRenameProcessor.$$$reportNull$$$0(9);
            }
            return usageInfo;
        }
        boolean nonCodeUsage = !ref.isReferenceTo(element) && (referenceElement instanceof RStringLiteral || referenceElement instanceof PsiComment);
        MoveRenameUsageInfo usageInfo = new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, nonCodeUsage);
        usageInfo.setDynamicUsage(false);
        MoveRenameUsageInfo moveRenameUsageInfo = usageInfo;
        if (moveRenameUsageInfo == null) {
            RubyRenameProcessor.$$$reportNull$$$0(10);
        }
        return moveRenameUsageInfo;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(11);
        }
        if (element instanceof PsiFile && !RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_FILE) {
            return false;
        }
        if (element instanceof RPsiElement && element instanceof PsiNamedElement) {
            return true;
        }
        if (element instanceof RBaseString && RubyCallTypesCore.getDefinedAttributeName((PsiElement)element) != null) {
            return true;
        }
        for (RenameProcessor processor : EP_NAME.getExtensionList()) {
            if (!processor.canProcessElement(element)) continue;
            return true;
        }
        return false;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        Map.Entry[] arr;
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            RubyRenameProcessor.$$$reportNull$$$0(13);
        }
        if (allRenames == null) {
            RubyRenameProcessor.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            RubyRenameProcessor.$$$reportNull$$$0(15);
        }
        this.myForceShowPreview = RubyRenameProcessor.forcesShowPreview(element);
        RubySymbolFilteringSettings.getInstance().setShowSymbols(true);
        RubyRenameProcessor.handleRename(element, newName, allRenames);
        RubyRenameProcessor.addAttrArguments(element, newName, allRenames);
        if (element instanceof RFile) {
            RubyRenameProcessor.processFileContent((RFile)element, newName, allRenames);
        }
        if (element instanceof RClass || element instanceof RModule) {
            RubyRenameProcessor.processPartialDeclarations(element, newName, allRenames);
            RubyRenameProcessor.processContainingFile(element, newName, allRenames);
            RubyRenameProcessor.processSpecFile(element, newName, allRenames);
        }
        if (element instanceof RMethod) {
            RubyRenameProcessor.processMethods((RMethod)element, newName, allRenames);
        }
        Set<Map.Entry<PsiElement, String>> entries = allRenames.entrySet();
        for (Map.Entry entry : arr = entries.toArray(new Map.Entry[0])) {
            RubyRenameProcessor.handleRename((PsiElement)entry.getKey(), (String)entry.getValue(), allRenames);
        }
    }

    private static void processFileContent(RFile rFile, String newName, Map<PsiElement, String> allRenames) {
        List<RClass> classes = RContainerUtil.getTopLevelClasses((RContainer)rFile);
        int classesQuantity = classes.size();
        if (classesQuantity > 1) {
            return;
        }
        List<RModule> modules = RContainerUtil.getTopLevelModules((RContainer)rFile);
        if (classesQuantity + modules.size() == 1) {
            RContainer classOrModule = classesQuantity == 1 ? (RContainer)classes.get(0) : (RContainer)modules.get(0);
            String name = rFile.getName();
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)rFile);
            if (name.equals(NamingConventions.toUnderscoreCase((String)classOrModule.getName(), (Module)module) + ".rb")) {
                String newCamelCaseName = NamingConventions.toCamelCase((String)newName, (Module)module);
                newCamelCaseName = newCamelCaseName.substring(0, newCamelCaseName.length() - 1 - "rb".length());
                RubyRenameProcessor.addElementToRename((PsiElement)classOrModule, newCamelCaseName, allRenames);
                RubyRenameProcessor.processPartialDeclarations((PsiElement)classOrModule, newCamelCaseName, allRenames);
            }
        }
    }

    public boolean forcesShowPreview() {
        return this.myForceShowPreview;
    }

    public static boolean forcesShowPreview(PsiElement element) {
        RIdentifier id;
        return !(element instanceof RIdentifier) || !(id = (RIdentifier)element).isParameterDeclaration() && !id.isLocalVariable();
    }

    private static void processContainingFile(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RContainer classOrModule = (RContainer)element;
        PsiFile file = classOrModule.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (file instanceof RFile) {
            RFile rFile = (RFile)file;
            if ((NamingConventions.toUnderscoreCase((String)classOrModule.getName(), (Module)module) + ".rb").equals(rFile.getName())) {
                RubyRenameProcessor.addElementToRename((PsiElement)rFile, NamingConventions.toUnderscoreCase((String)newName, (Module)module) + ".rb", allRenames);
            }
        }
    }

    private static void processSpecFile(@NotNull PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(16);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        TestsLocationProviderUtil.collectCandidates((Project)element.getProject(), (String)RubyRenameProcessor.specFileName(((RContainer)element).getFQN().getShortName(), module), (boolean)false).stream().map(TestsLocationProviderUtil.FileInfo::getFile).map(file -> element.getManager().findFile(file)).filter(Objects::nonNull).forEach(specPsiFile -> RubyRenameProcessor.addElementToRename((PsiElement)specPsiFile, RubyRenameProcessor.specFileName(newName, module), allRenames));
    }

    @NotNull
    private static String specFileName(@NotNull String name, @Nullable Module module) {
        if (name == null) {
            RubyRenameProcessor.$$$reportNull$$$0(17);
        }
        String string = NamingConventions.toUnderscoreCase((String)name, (Module)module) + "_spec.rb";
        if (string == null) {
            RubyRenameProcessor.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void handleRename(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        for (RenameProcessor processor : EP_NAME.getExtensionList()) {
            if (!processor.canProcessElement(element)) continue;
            processor.prepareRenaming(element, newName, allRenames);
        }
    }

    private static void processMethods(@NotNull RMethod method, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (method == null) {
            RubyRenameProcessor.$$$reportNull$$$0(19);
        }
        if (newName == null) {
            RubyRenameProcessor.$$$reportNull$$$0(20);
        }
        if (allRenames == null) {
            RubyRenameProcessor.$$$reportNull$$$0(21);
        }
        boolean isUnderVendor = RailsUtil.isUnderVendor((PsiElement)method);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)method.getProject());
        Consumer<PsiElement> consumer = element -> {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (!RubyPsiUtil.isLocatedInStubs(element) && (isUnderVendor || !RailsUtil.isUnderVendor(element)) && file != null && scope.contains(file)) {
                RubyRenameProcessor.addElementToRename(element, newName, allRenames);
            }
        };
        RubyOverrideImplementUtil.getOverriddenMethods(method).forEach(consumer);
        RubyOverrideImplementUtil.getOverridingElements((RContainer)method).forEach(consumer);
    }

    public static void processPartialDeclarations(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        assert (element instanceof RModule || element instanceof RClass) : "Class or module expected here";
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        boolean isUnderVendor = RailsUtil.isUnderVendor(element);
        PsiManager psiManager = element.getManager();
        for (PsiElement psiElement : RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)element, false, element)) {
            if (!psiManager.isInProject(psiElement) || !isUnderVendor && RailsUtil.isUnderVendor(psiElement)) continue;
            RubyRenameProcessor.addElementToRename(psiElement, newName, allRenames);
        }
    }

    private static void addElementToRename(PsiElement psiElement, String newName, Map<PsiElement, String> allRenames) {
        if (psiElement.isWritable()) {
            allRenames.put(psiElement, newName);
        }
    }

    public String getHelpID(PsiElement element) {
        return "refactoring.renameDialogs";
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyRenameProcessor.$$$reportNull$$$0(22);
        }
        if (!(psiElement instanceof RIdentifier)) {
            return false;
        }
        RIdentifier id = (RIdentifier)psiElement;
        return id.isParameter() || id.isLocalVariable();
    }

    private static void addAttrArguments(@NotNull PsiElement element, final @NotNull String newName, final @NotNull Map<PsiElement, String> allRenames) {
        String attrName;
        if (element == null) {
            RubyRenameProcessor.$$$reportNull$$$0(23);
        }
        if (newName == null) {
            RubyRenameProcessor.$$$reportNull$$$0(24);
        }
        if (allRenames == null) {
            RubyRenameProcessor.$$$reportNull$$$0(25);
        }
        if ((attrName = RubyCallTypesCore.getDefinedAttributeName((PsiElement)element)) == null) {
            return;
        }
        Symbol context = SymbolUtil.getScopeContextWithCaching(element);
        assert (context != null);
        Function<String, SymbolProcessor> processorFn = name -> {
            if (attrName == null) {
                RubyRenameProcessor.$$$reportNull$$$0(26);
            }
            return new SymbolProcessor(){
                final /* synthetic */ String val$name;
                final /* synthetic */ PsiElement val$element;
                {
                    this.val$name = string3;
                    this.val$element = psiElement;
                }

                @Override
                public boolean process(@NotNull Symbol symbol) {
                    if (symbol == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!Types.ATTR_METHODS.contains(symbol.getType())) {
                        return false;
                    }
                    PsiElement arg = symbol.getPsiElement();
                    if (arg == null) {
                        return false;
                    }
                    String argumentName = RubyCallTypesCore.getDefinedAttributeName((PsiElement)arg);
                    if (attrName.equals(argumentName)) {
                        RubyRenameProcessor.addElementToRename(arg.getNavigationElement(), newName, allRenames);
                    }
                    return true;
                }

                @Override
                @NotNull
                public String getName() {
                    String string = this.val$name;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                public PsiElement getInvocationPoint() {
                    PsiElement psiElement = this.val$element;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiElement;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "symbol";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/rename/RubyRenameProcessor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/rename/RubyRenameProcessor$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getInvocationPoint";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            };
        };
        SymbolHierarchy.processSymbolChildren(context, processorFn.apply(attrName));
        SymbolHierarchy.processSymbolChildren(context, processorFn.apply(attrName + "="));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 13: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/rename/RubyRenameProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 14: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/rename/RubyRenameProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "specFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 18: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processSpecFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "specFileName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showRenamePreviewButton";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addAttrArguments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAttrArguments$3";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10, 18 -> new IllegalStateException(string);
        };
    }
}

