/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.SummaryUtilService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyConstantDeclarationFqnIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubySymbolNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RConstantStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RubyStubSerializingElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.impl.RConstantStubImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/types/RConstantStubSerializingElementFactory;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RubyStubSerializingElementFactory;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/stubs/RConstantStub;", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/variables/RConstant;", "<init>", "()V", "createPsi", "stub", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "serialize", "", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.ruby.backend"})
public final class RConstantStubSerializingElementFactory
extends RubyStubSerializingElementFactory<RConstantStub, RConstant> {
    public RConstantStubSerializingElementFactory() {
        super("CONSTANT");
    }

    @NotNull
    public RConstant createPsi(@NotNull RConstantStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        return (RConstant)new RConstantImpl(stub);
    }

    @NotNull
    public RConstantStub createStub(@NotNull RConstant psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return (RConstantStub)new RConstantStubImpl(parentStub, psi.getFQN(), SummaryUtilService.Companion.instance().getSymbolicExpression((RPsiElement)psi));
    }

    public void serialize(@NotNull RConstantStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        FQN.Serialization.serialize((FQN)stub.getFQN(), (StubOutputStream)dataStream);
        SymbolicExpressionUtil.serialize(CollectionsKt.listOf((Object)stub.getAssignedSymbolicExpression()), dataStream);
    }

    @NotNull
    public RConstantStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        FQN fQN = FQN.Serialization.deserialize((StubInputStream)dataStream);
        Intrinsics.checkNotNullExpressionValue((Object)fQN, (String)"deserialize(...)");
        FQN fqn = fQN;
        SymbolicExpression symbolicExpression = SymbolicExpressionUtil.deserializeLastExpression(dataStream);
        Intrinsics.checkNotNullExpressionValue((Object)symbolicExpression, (String)"deserializeLastExpression(...)");
        SymbolicExpression expression = symbolicExpression;
        return (RConstantStub)new RConstantStubImpl(parentStub, fqn, expression);
    }

    public void indexStub(@NotNull RConstantStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.occurrence(RubySymbolNameIndex.KEY, (Object)stub.getName());
        sink.occurrence(RubyClassModuleNameIndex.KEY, (Object)stub.getName());
        RubyResolutionIndex.sink((FQN)stub.getFQNWithNesting(), (IndexSink)sink);
        RubyConstantDeclarationFqnIndex.sink((RConstantStub)stub, (IndexSink)sink);
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RConstant element = (RConstant)node.getPsi(RConstant.class);
        return element.getName() != null && RubyPsiUtilCore.isDeclarationImpl((PsiElement)((PsiElement)element)) && element.getFQNWithNesting() != FQN.INVALID;
    }
}

