/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyIncludedExtendedFQNIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeIndexer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendReceiverFqnProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubNamespaceElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RBlockCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RCodeBlockStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.containers.RMethodStub;

public class RubyIncludeExtendCallTypeIndexer
implements RubyCallTypeIndexer<List<FQN>> {
    private static final Set<String> INCLUDED_EXTENDED_NAMES = Set.of("included", "extended");

    public void indexStub(@NotNull RubyCallType<List<FQN>> callType, @NotNull RPossibleCallStub<?> stub, @NotNull IndexSink sink) {
        if (callType == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(0);
        }
        if (stub == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(2);
        }
        RubyIncludeExtendCallTypeIndexer.indexIncludeExtend(stub, sink);
    }

    static void indexIncludeExtend(RPossibleCallStub<?> stub, IndexSink sink) {
        FQN receiver;
        List data = (List)stub.getCallData().getData((RubyCallType)((RubyIncludeExtendCallType)stub.getCallData().getCallType()), new RubyCallType[0]);
        if (data.isEmpty()) {
            return;
        }
        if (stub instanceof RCallStub) {
            for (FQN fqn : data) {
                sink.occurrence(RubyInheritanceIndex.KEY, (Object)fqn.getShortName());
            }
        }
        if ((receiver = RubyIncludeExtendCallTypeIndexer.getIncludeExtendReceiver(stub)).getCallerFQN().getShortName().equals("$$HOOK$$")) {
            RubyIncludedExtendedFQNIndex.sink((FQN)receiver, (IndexSink)sink);
            return;
        }
        if (receiver == FQN.INVALID) {
            receiver = FQN.Builder.fromString((String)stub.getCommand()).getCallerFQN();
            StubElement directParentContainer = stub.getParentStub();
            if (directParentContainer instanceof RMethodStub) {
                return;
            }
            FQN parentFQN = RStubNamespaceElement.getFQNForStub(stub, (String)"");
            receiver = receiver != FQN.INVALID && parentFQN.getFullPath().endsWith(receiver.getFullPath()) ? parentFQN : FQN.Builder.concat((FQN)parentFQN, (FQN)receiver);
        }
        RubyInheritanceResolutionIndex.sink((FQN)receiver, (IndexSink)sink);
    }

    @NotNull
    static FQN getIncludeExtendReceiver(@NotNull RPossibleCallStub<?> callStub) {
        RBlockCallStub blockCallStub;
        String blockCallCommand;
        FQN fqnFromProvider;
        RCodeBlockStub codeBlockStub;
        StubElement stubElement;
        StubElement stubElement2;
        if (callStub == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(3);
        }
        if ((stubElement2 = callStub.getParentStub()) instanceof RCodeBlockStub && (stubElement = (codeBlockStub = (RCodeBlockStub)stubElement2).getParentStub()) instanceof RBlockCallStub && (fqnFromProvider = RubyIncludeExtendReceiverFqnProvider.getReceiverFqnInBlockCall(blockCallCommand = (blockCallStub = (RBlockCallStub)stubElement).getReferenceReceiver() == null ? blockCallStub.getCommandName() : blockCallStub.getReferenceReceiver() + "." + blockCallStub.getCommandName(), codeBlockStub.getParameterNames(), callStub.getCommand(), RubyCallTypesCore.isIncludeOrPrependCall((RPossibleCall)((RPossibleCall)callStub.getPsi())))) != null) {
            FQN fQN = fqnFromProvider;
            if (fQN == null) {
                RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(4);
            }
            return fQN;
        }
        FQN fqnFromProvider2 = RubyIncludeExtendCallTypeIndexer.getReceiverFromContainingMethod(callStub, callStub.getCommand());
        if (fqnFromProvider2 != null) {
            FQN fQN = fqnFromProvider2;
            if (fQN == null) {
                RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(5);
            }
            return fQN;
        }
        FQN fQN = FQN.INVALID;
        if (fQN == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(6);
        }
        return fQN;
    }

    @Nullable
    public static FQN getReceiverFromContainingMethod(@NotNull RStubElement<?> callStub, @NotNull String command) {
        RMethod method;
        if (callStub == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(7);
        }
        if (command == null) {
            RubyIncludeExtendCallTypeIndexer.$$$reportNull$$$0(8);
        }
        if ((method = RubyPsiUtil.getContainingRMethod(callStub.getPsi())) != null) {
            FQN methodQualifiedName = method.getFQNWithNesting();
            List methodArgs = ContainerUtil.map((Collection)method.getArgumentInfos(), ArgumentInfo::getName);
            List callComponents = StringUtil.split((String)command, (String)".");
            if (INCLUDED_EXTENDED_NAMES.contains(methodQualifiedName.getShortName()) && RObjectClass.isSingletonFQN((FQN)methodQualifiedName) && methodArgs.size() == 1 && callComponents.size() == 2 && ((String)methodArgs.get(0)).equals(callComponents.get(0))) {
                return FQN.Builder.concat((FQN)FQN.Builder.concat((FQN)methodQualifiedName.getCallerFQN().getCallerFQN(), (FQN)RubyIncludedExtendedFQNIndex.DELEGATE_HOOK_FQN), (String)methodQualifiedName.getShortName());
            }
        } else if (callStub instanceof RBlockCallStub && command.equals(RubyCallTypesCore.INCLUDED_DO.getCommandName())) {
            return FQN.Builder.concat((FQN)RStubNamespaceElement.getFQNForStub(callStub, (String)"$$HOOK$$"), (String)RubyCallTypesCore.INCLUDED_DO.getCommandName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStub";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyIncludeExtendCallTypeIndexer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyIncludeExtendCallTypeIndexer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeExtendReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeExtendReceiver";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverFromContainingMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

