/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ModuleNewCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAliasMethodCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAutoLoadCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAutoLoadUnderCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyDataDefineCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyDefineSingletonMethodCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyIncludeExtendCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyModuleFunctionCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubySymbolDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.presentation.RFieldAttrPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;

public final class RubyCallTypes {
    public static final RubyCallType<List<String>> AUTOLOAD_CALL = new RubyAutoLoadCallType("autoload");
    public static final RubyCallType<List<String>> AUTOLOAD_UNDER_CALL = new RubyAutoLoadUnderCallType("autoload_under");
    public static final RubyDataDefineCallType DATA_DEFINE = new RubyDataDefineCallType();
    public static final ClassNewCallType CLASS_NEW = new ClassNewCallType();
    public static final ModuleNewCallType MODULE_NEW = new ModuleNewCallType();
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_READER_CALL = new RubyAttrCallTypeImpl("attr_reader", true, false).withIcon(() -> RFieldAttrPresentationUtil.ATTR_READER_ICON);
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_CALL = new RubyAttrCallTypeImpl("attr", true, false).withIcon(() -> RFieldAttrPresentationUtil.ATTR_READER_ICON);
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_WRITER_CALL = new RubyAttrCallTypeImpl("attr_writer", false, true).withIcon(() -> RFieldAttrPresentationUtil.ATTR_WRITER_ICON);
    public static final RubyCallType<List<Pair<String, SerializableType>>> ATTR_ACCESSOR_CALL = new RubyAttrCallTypeImpl("attr_accessor", true, true).withIcon(() -> RFieldAttrPresentationUtil.ATTR_ACCESSOR_ICON);
    public static final RubyCallType<List<String>> MODULE_FUNCTION_CALL = new RubyModuleFunctionCallType();
    public static final RubyCallType<List<String>> DEFINE_METHOD_CALL = new RubySymbolDefiningCallType("define_method", Type.INSTANCE_METHOD).withIcon(() -> RMethodPresentationUtil.getIcon(null));
    public static final RubyCallType<List<String>> DEFINE_SINGLETON_METHOD_CALL = new RubyDefineSingletonMethodCallType().withIcon(() -> RMethodPresentationUtil.getIcon(null));
    public static final RubyCallType<List<String>> PRIVATE_CALL = new RubyVisibilityCallTypeImpl("private", Visibility.PRIVATE);
    public static final RubyCallType<List<String>> PROTECTED_CALL = new RubyVisibilityCallTypeImpl("protected", Visibility.PROTECTED);
    public static final RubyCallType<List<String>> PUBLIC_CALL = new RubyVisibilityCallTypeImpl("public", Visibility.PUBLIC);
    public static final List<RubyCallType<?>> VISIBILITY_MODIFIER_CALLS = List.of(PRIVATE_CALL, PROTECTED_CALL, PUBLIC_CALL);
    public static final RubyCallType<List<String>> ALIAS_METHOD_CALL = new RubyAliasMethodCallType();
    public static final RubyCallType<List<FQN>>[] INCLUDE_EXTEND_CALLS = new RubyCallType[]{RubyIncludeExtendCallTypes.INCLUDE_CALL, RubyIncludeExtendCallTypes.PREPEND_CALL, RubyIncludeExtendCallTypes.EXTEND_CALL, RubyCallTypesCore.SEND_CALL};

    private RubyCallTypes() {
    }

    public static boolean isIgnoredIncludeExtendArgument(RPossibleCall rCall, FQN qualifiedName) {
        if (rCall.getCallType() == RubyCallTypesCore.SEND_CALL && ("include".equals(qualifiedName.getShortName()) || "extend".equals(qualifiedName.getShortName()))) {
            return true;
        }
        return !RubyFQNUtil.isConstantFqn(qualifiedName) && !FQN.same((FQN)qualifiedName, (String)"self");
    }

    public static void processElements(@NotNull RCall call, @Nullable PsiElement invocationPoint, @NotNull Processor<? super PsiElement> processor) {
        if (call == null) {
            RubyCallTypes.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            RubyCallTypes.$$$reportNull$$$0(1);
        }
        RubyCallType callType = call.getCallType();
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        Symbol context = SymbolUtil.getScopeContextWithCaching((PsiElement)call);
        if (context == null) {
            return;
        }
        Symbol singletonContext = context.getSingletonClassSymbol();
        if (singletonContext != null && !callType.processElements((Processor)uniqueProcessor, singletonContext, call, invocationPoint)) {
            return;
        }
        callType.processElements((Processor)uniqueProcessor, context, call, invocationPoint);
    }

    public static void processElementsAtArgument(@NotNull RCall call, @NotNull PsiElement argument, @Nullable PsiElement invocationPoint, @NotNull Processor<? super PsiElement> processor) {
        if (call == null) {
            RubyCallTypes.$$$reportNull$$$0(2);
        }
        if (argument == null) {
            RubyCallTypes.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            RubyCallTypes.$$$reportNull$$$0(4);
        }
        PsiManager manager = call.getManager();
        FilteringProcessor filteringProcessor = new FilteringProcessor(element -> manager.areElementsEquivalent(argument, element), processor);
        RubyCallTypes.processElements(call, invocationPoint, (Processor<? super PsiElement>)filteringProcessor);
    }

    public static boolean hasClassContext(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            RubyCallTypes.$$$reportNull$$$0(5);
        }
        return RubyCallTypesCore.isIncludedDo((RubyCallType)(callType = call.getCallType())) || callType == RailsCallTypeProvider.CLASS_METHODS_CALL;
    }

    @Nullable
    public static RCall getAliasMethodCallByNewName(@NotNull RPsiElement element) {
        RCall call;
        if (element == null) {
            RubyCallTypes.$$$reportNull$$$0(6);
        }
        if ((call = RCallNavigator.getByFirstRArgument((PsiElement)element)) != null && call.getCallType() == ALIAS_METHOD_CALL) {
            return call;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyCallTypes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsAtArgument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasClassContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAliasMethodCallByNewName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

