/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.DocumentationMember;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.AttributeAccessorSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyCommentsHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RDocumentationSymbolsHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubySymbolNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.RStubNamespaceElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public class RubyAttrCallTypeImpl
extends RubyCallTypeBase<List<Pair<String, SerializableType>>>
implements RubyAttrCallType {
    private boolean myHasReadAccessor;
    private boolean myHasWriteAccessor;
    private Type myReadAccessorType;
    private Type myWriteAccessorType;

    public RubyAttrCallTypeImpl(@NotNull String debugName, boolean hasReadAccessor, boolean hasWriteAccessor) {
        if (debugName == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(0);
        }
        super(debugName);
        this.myReadAccessorType = Type.FIELD_READER;
        this.myWriteAccessorType = Type.FIELD_WRITER;
        this.myHasReadAccessor = hasReadAccessor;
        this.myHasWriteAccessor = hasWriteAccessor;
    }

    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol symbol, @NotNull RCall call, PsiElement invocationPoint) {
        if (processor == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(2);
        }
        if (call == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(3);
        }
        for (Pair pair : (List)call.getData(new RubyCallType[]{this})) {
            if (this.processArgument(symbol, call, processor, (String)pair.first, (SerializableType)pair.second)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<Pair<String, SerializableType>> getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(4);
        }
        List<Pair<String, SerializableType>> list = call.getArguments().stream().flatMap(argument -> {
            StringValue stringValue = RubyCallTypesService.instance().evaluateArgument(argument, true);
            List argumentNames = stringValue.getAllStrings();
            return argumentNames.stream();
        }).map(argumentName -> Pair.create((Object)argumentName, (Object)this.parseSerializableType(call, (String)argumentName))).collect(Collectors.toList());
        if (list == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isCompatible(@NotNull RPossibleCall call) {
        block6: {
            block5: {
                if (call == null) {
                    RubyAttrCallTypeImpl.$$$reportNull$$$0(6);
                }
                if (call.getArguments().isEmpty()) break block5;
                if (!RubyCallTypeRegistry.hasReceiver((RPossibleCall)call, RConstant.class::isInstance)) break block6;
            }
            return false;
        }
        if (!(call.getPsiCommand() instanceof RReference)) {
            return true;
        }
        RContainer container = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)call);
        return container != null && !container.getFQNWithNesting().equals(CoreFqns.OBJECT);
    }

    public boolean hasReadAccessor() {
        return this.myHasReadAccessor;
    }

    public boolean hasWriteAccessor() {
        return this.myHasWriteAccessor;
    }

    public String getFieldName(String name) {
        return name;
    }

    public RubyAttrCallTypeImpl withReadClassAccessor() {
        this.myHasReadAccessor = true;
        this.myReadAccessorType = Type.CLASS_FIELD_READER;
        return this;
    }

    public RubyAttrCallTypeImpl withWriteClassAccessor() {
        this.myHasWriteAccessor = true;
        this.myWriteAccessorType = Type.CLASS_FIELD_WRITER;
        return this;
    }

    protected boolean processArgument(Symbol symbol, RCall rCall, Processor<? super Symbol> processor, String name, SerializableType serializableType) {
        if (this.hasReadAccessor() && !processor.process((Object)new AttributeAccessorSymbol(rCall, serializableType, name, this.myReadAccessorType, symbol))) {
            return false;
        }
        return !this.hasWriteAccessor() || processor.process((Object)new AttributeAccessorSymbol(rCall, serializableType, name + "=", this.myWriteAccessorType, symbol));
    }

    public void indexArgument(RPossibleCallStub<?> stub, IndexSink sink, @NotNull String name) {
        if (name == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(7);
        }
        boolean isSingleton = Types.STATIC_CONTEXT_TYPES.contains(this.myReadAccessorType) || Types.STATIC_CONTEXT_TYPES.contains(this.myWriteAccessorType);
        FQN fqn = RStubNamespaceElement.getFQNForStub(stub, (String)name, (boolean)isSingleton);
        RubyAttrCallTypeImpl.sinkName(sink, name, this.getFieldName(name), fqn.getCallerFQN(), this.hasReadAccessor(), this.hasWriteAccessor());
    }

    @NotNull
    public ItemPresentation getPresentation(final @NotNull RPossibleCall call) {
        if (call == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(8);
        }
        return new ItemPresentation(){

            @NotNull
            @NlsSafe
            public String getPresentableText() {
                if (call.getUserData(RubyAttrCallType.ATTR_CALL_NAME) != null) {
                    String string = call.getCommand() + call.getName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = call.getCommand() + " " + StringUtil.join((Collection)ContainerUtil.map((Collection)((Collection)call.getData(new RubyCallType[]{RubyAttrCallTypeImpl.this})), it -> ":" + (String)it.first), (String)", ");
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = TextUtil.wrapInParens((String)RContainerPresentationUtil.getLocation((RPsiElement)call));
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return RubyAttrCallTypeImpl.this.getIcon();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyAttrCallTypeImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static void sinkName(@NotNull IndexSink sink, @NotNull String name, @NotNull String fieldName, @NotNull FQN fqn, boolean hasReadAccessor, boolean hasWriteAccessor) {
        if (sink == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(9);
        }
        if (name == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(11);
        }
        if (fqn == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(12);
        }
        if (hasReadAccessor) {
            RubyResolutionIndex.sink((FQN)FQN.Builder.concat((FQN)fqn, (String)name), (IndexSink)sink);
            sink.occurrence(RubySymbolNameIndex.KEY, (Object)name);
            if (!name.equals(fieldName)) {
                sink.occurrence(RubySymbolNameIndex.KEY, (Object)fieldName);
            }
        }
        if (hasWriteAccessor) {
            String nameWithAssignment = name + "=";
            RubyResolutionIndex.sink((FQN)FQN.Builder.concat((FQN)fqn, (String)nameWithAssignment), (IndexSink)sink);
            sink.occurrence(RubySymbolNameIndex.KEY, (Object)nameWithAssignment);
            if (!name.equals(fieldName)) {
                sink.occurrence(RubySymbolNameIndex.KEY, (Object)(fieldName + "="));
            }
        }
    }

    @NotNull
    private static SerializableType getTypeFromReturnComment(@NotNull RPsiElement argument) {
        String helpWithoutSharps;
        if (argument == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(13);
        }
        if ((helpWithoutSharps = RubyCommentsUtilCore.getPsiHelpWithoutLeadingSharps((PsiElement)argument)) == null) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                RubyAttrCallTypeImpl.$$$reportNull$$$0(14);
            }
            return serializableType;
        }
        SerializableType serializableType = RubyCommentsHelper.extractYARDReturnTypeAnnotationFromComment((String)helpWithoutSharps);
        if (serializableType == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(15);
        }
        return serializableType;
    }

    @NotNull
    private static SerializableType getTypeFromYARDAttrAnnotation(@NotNull RPsiElement argument, @NotNull Type type, @NotNull String name) {
        PsiElement psiElement;
        if (argument == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(16);
        }
        if (type == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(17);
        }
        if (name == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(18);
        }
        if (!((psiElement = PsiTreeUtil.getParentOfType((PsiElement)argument, (Class[])new Class[]{RContainer.class, RBlockCall.class})) instanceof RDocumentationSymbolsHolder)) {
            SerializableType serializableType = SerializableTypeUtil.EMPTY;
            if (serializableType == null) {
                RubyAttrCallTypeImpl.$$$reportNull$$$0(19);
            }
            return serializableType;
        }
        RDocumentationSymbolsHolder holder = (RDocumentationSymbolsHolder)psiElement;
        DocumentationSymbol documentationSymbol = (DocumentationSymbol)holder.getDocumentationSymbols().get(name);
        if (documentationSymbol instanceof DocumentationMember && documentationSymbol.getType() == type) {
            SerializableType serializableType = ((DocumentationMember)documentationSymbol).getReturnType();
            if (serializableType == null) {
                RubyAttrCallTypeImpl.$$$reportNull$$$0(20);
            }
            return serializableType;
        }
        SerializableType serializableType = SerializableTypeUtil.EMPTY;
        if (serializableType == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(21);
        }
        return serializableType;
    }

    @NotNull
    private SerializableType parseSerializableType(@NotNull RPossibleCall call, @NotNull String name) {
        SerializableType comment;
        if (call == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(22);
        }
        if (name == null) {
            RubyAttrCallTypeImpl.$$$reportNull$$$0(23);
        }
        if ((comment = RubyAttrCallTypeImpl.getTypeFromReturnComment((RPsiElement)call)) != SerializableTypeUtil.EMPTY) {
            SerializableType serializableType = comment;
            if (serializableType == null) {
                RubyAttrCallTypeImpl.$$$reportNull$$$0(24);
            }
            return serializableType;
        }
        comment = RubyAttrCallTypeImpl.getTypeFromYARDAttrAnnotation((RPsiElement)call, this.myReadAccessorType, name);
        if (comment != SerializableTypeUtil.EMPTY) {
            SerializableType serializableType = comment;
            if (serializableType == null) {
                RubyAttrCallTypeImpl.$$$reportNull$$$0(25);
            }
            return serializableType;
        }
        return RubyAttrCallTypeImpl.getTypeFromYARDAttrAnnotation((RPsiElement)call, this.myWriteAccessorType, "=" + name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 14, 15, 19, 20, 21, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyAttrCallTypeImpl";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyAttrCallTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromReturnComment";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromYARDAttrAnnotation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSerializableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCallData";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indexArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sinkName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromReturnComment";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromYARDAttrAnnotation";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseSerializableType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 14, 15, 19, 20, 21, 24, 25 -> new IllegalStateException(string);
        };
    }

    static class AttrStorage
    implements RubyCallTypeBase.Storage<List<Pair<String, SerializableType>>> {
        @NotNull
        final List<Pair<String, SerializableType>> myData;

        AttrStorage(@NotNull List<Pair<String, SerializableType>> data) {
            if (data == null) {
                AttrStorage.$$$reportNull$$$0(0);
            }
            this.myData = Collections.unmodifiableList(new ArrayList<Pair<String, SerializableType>>(data));
        }

        @NotNull
        public List<Pair<String, SerializableType>> getData() {
            List<Pair<String, SerializableType>> list = this.myData;
            if (list == null) {
                AttrStorage.$$$reportNull$$$0(1);
            }
            return list;
        }

        public String toString() {
            return "AttrStorage{myData=" + String.valueOf(this.myData) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyAttrCallTypeImpl$AttrStorage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RubyAttrCallTypeImpl$AttrStorage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

