/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RFileReference;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RFileReferenceSet;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class RequireRelativeFileReference
extends FileReference {
    @NotNull
    private final RFileReference myReference;
    @Nullable
    private final VirtualFile myFile;
    @Nullable
    private final VirtualFile myDirectory;
    @NotNull
    private final InsertHandler<LookupElement> myAddSeparatorInsertHandler;
    private static final List<String> FILE_EXTENSIONS = Arrays.asList("", RFileUtilCore.RB_FILE_SUFFIX, ".so", ".dll", ".bundle");

    public RequireRelativeFileReference(@NotNull RFileReferenceSet set, @NotNull RFileReference reference, TextRange range, int index, String text) {
        if (set == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(1);
        }
        super((FileReferenceSet)set, range, index, text);
        this.myReference = reference;
        this.myFile = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
        this.myDirectory = this.myFile == null ? null : this.myFile.getParent();
        this.myAddSeparatorInsertHandler = (context, item) -> {
            Editor editor = context.getEditor();
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)set.getSeparatorString());
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
        };
    }

    @NotNull
    public RFileReference getRFileReference() {
        RFileReference rFileReference = this.myReference;
        if (rFileReference == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(2);
        }
        return rFileReference;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.isLastPathElementReference() ? this.myReference.multiResolve(incompleteCode) : super.multiResolve(incompleteCode);
        if (resolveResultArray == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (this.isLastPathElementReference()) {
            newName = newName.substring(this.getRangeInElement().getStartOffset() - this.myReference.getRangeInElement().getStartOffset());
            return this.myReference.handleElementRename(newName);
        }
        return super.rename(newName);
    }

    public Object @NotNull [] getVariants() {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
        PsiDirectory context = this.getContext();
        if (context != null) {
            PsiDirectory parent = context.getParent();
            if (parent != null && context.getManager().isInProject((PsiElement)parent)) {
                variants.add(LookupElementBuilder.create((Object)parent, (String)"..").withIcon(parent.getIcon(0)).withTypeText(parent.getName()).withInsertHandler(this.myAddSeparatorInsertHandler));
            }
            Set<VirtualFile> alreadyRequiredFiles = this.getAlreadyRequiredFiles();
            for (PsiElement child : context.getChildren()) {
                if (!(child instanceof PsiFileSystemItem) || !this.shouldAddToLookup((PsiFileSystemItem)child, alreadyRequiredFiles)) continue;
                if (child instanceof PsiFile) {
                    variants.add(LookupElementBuilder.create((Object)child, (String)StringUtil.trimEnd((String)((PsiFile)child).getName(), (String)RFileUtilCore.RB_FILE_SUFFIX)).withIcon(child.getIcon(0)));
                }
                if (!(child instanceof PsiDirectory)) continue;
                variants.add(LookupElementBuilder.create((PsiNamedElement)((PsiDirectory)child)).withIcon(child.getIcon(0)).withInsertHandler(this.myAddSeparatorInsertHandler));
            }
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @Nullable
    private PsiDirectory getContext() {
        if (this.myDirectory == null) {
            return null;
        }
        StringBuilder contextPath = new StringBuilder();
        for (FileReference reference : this.getFileReferenceSet().getAllReferences()) {
            if (reference.getText().contains("IntellijIdeaRulezzz")) break;
            contextPath.append(reference.getText()).append(this.getFileReferenceSet().getSeparatorString());
        }
        VirtualFile vfsContext = this.myDirectory.findFileByRelativePath(contextPath.toString());
        if (vfsContext == null || !vfsContext.isDirectory()) {
            return null;
        }
        return this.getElement().getManager().findDirectory(vfsContext);
    }

    private boolean shouldAddToLookup(@Nullable PsiFileSystemItem item, @NotNull @NotNull Set<@NotNull VirtualFile> alreadyRequiredFiles) {
        if (alreadyRequiredFiles == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(5);
        }
        return item instanceof PsiDirectory && !item.getName().startsWith(".") && !item.getVirtualFile().is(VFileProperty.HIDDEN) && !FileTypeIndex.processFiles((FileType)RubyFileType.RUBY, file -> !this.isValidForRequireRelative((VirtualFile)file, alreadyRequiredFiles), (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)((PsiDirectory)item), (boolean)true)) || item instanceof PsiFile && this.isValidForRequireRelative(item.getVirtualFile(), alreadyRequiredFiles);
    }

    private boolean isValidForRequireRelative(@Nullable VirtualFile file, @NotNull @NotNull Set<@NotNull VirtualFile> alreadyRequiredFiles) {
        if (alreadyRequiredFiles == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(6);
        }
        return file != null && !file.getName().startsWith(".") && !file.is(VFileProperty.HIDDEN) && RubyVirtualFileScanner.isRubyFile(file) && !file.equals(this.myFile) && !alreadyRequiredFiles.contains(file);
    }

    @NotNull
    private @NotNull Set<@NotNull VirtualFile> getAlreadyRequiredFiles() {
        HashSet<VirtualFile> alreadyRequiredFiles = new HashSet<VirtualFile>();
        if (this.myDirectory == null) {
            HashSet<VirtualFile> hashSet = alreadyRequiredFiles;
            if (hashSet == null) {
                RequireRelativeFileReference.$$$reportNull$$$0(7);
            }
            return hashSet;
        }
        block0: for (RequireInfo require : RFileUtil.computeRequires((RFile)this.getElement().getContainingFile())) {
            if (!require.isRelative()) continue;
            for (String extension : FILE_EXTENSIONS) {
                VirtualFile requiredFile = this.myDirectory.findFileByRelativePath(require.getPath() + extension);
                if (requiredFile == null) continue;
                alreadyRequiredFiles.add(requiredFile);
                continue block0;
            }
        }
        HashSet<VirtualFile> hashSet = alreadyRequiredFiles;
        if (hashSet == null) {
            RequireRelativeFileReference.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private boolean isLastPathElementReference() {
        return this.getRangeInElement().getEndOffset() == this.myReference.getRangeInElement().getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RequireRelativeFileReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyRequiredFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/methodCall/RequireRelativeFileReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRFileReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlreadyRequiredFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToLookup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidForRequireRelative";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

