/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUndefStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.CallTypeWithStructurePresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallTypeKt;
import org.jetbrains.plugins.ruby.ruby.lang.psi.stubs.calls.RPossibleCallStub;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class RContainerUtil {
    private static final Logger LOG = Logger.getInstance(RContainerUtil.class);

    private RContainerUtil() {
    }

    @Nullable
    public static RClass getClassByName(@NotNull RContainer container, @Nullable String className) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(0);
        }
        for (RClass rClass : RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RClass.class)) {
            if (!Comparing.strEqual((String)rClass.getName(), (String)className, (boolean)true)) continue;
            return rClass;
        }
        return null;
    }

    @Nullable
    public static RMethod getMethodByName(@NotNull RContainer container, @NonNls @Nullable String methodName) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(1);
        }
        for (RMethod rMethod : RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RMethod.class)) {
            if (!Comparing.strEqual((String)rMethod.getName(), (String)methodName, (boolean)true)) continue;
            return rMethod;
        }
        return null;
    }

    @Nullable
    public static RModule getModuleByName(@NotNull RContainer container, @Nullable String moduleName) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(2);
        }
        for (RModule rModule : RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RModule.class)) {
            if (!Comparing.strEqual((String)rModule.getName(), (String)moduleName, (boolean)true)) continue;
            return rModule;
        }
        return null;
    }

    @NotNull
    public static <E> List<RPsiStructureElement> getStructureElements(@NotNull RPsiElement container, StubElement<? extends E> stub) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(3);
        }
        ArrayList<RPsiStructureElement> elements = new ArrayList<RPsiStructureElement>();
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            RContainerUtil.addStubsRecursively(elements, stubs);
        } else {
            RPsiElementCollector myVisitor = new RPsiElementCollector(elements, container);
            container.acceptChildren((PsiElementVisitor)myVisitor);
        }
        ArrayList<RPsiStructureElement> arrayList = elements;
        if (arrayList == null) {
            RContainerUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void addStubsRecursively(List<? super RPsiStructureElement> elements, List<? extends StubElement<?>> stubs) {
        for (StubElement<?> child : stubs) {
            RBlockCall rBlockCall;
            PsiElement element = child.getPsi();
            if (element instanceof RCodeBlock || element instanceof RBlockCall && !RContainerUtil.isClassEval(rBlockCall = (RBlockCall)element)) {
                RContainerUtil.addStubsRecursively(elements, child.getChildrenStubs());
                continue;
            }
            if (!(element instanceof RPsiStructureElement)) continue;
            if (element instanceof RCall) {
                String arg;
                RCall rCall = (RCall)element;
                RubyCallType type = rCall.getCallType();
                String string = arg = type instanceof RubyVisibilityCallTypeImpl ? (String)ContainerUtil.getFirstItem((List)((List)rCall.getData(new RubyCallType[0]))) : null;
                if (RubyVisibilityCallTypeKt.isMethodArg(arg)) {
                    StubElement stub = (StubElement)ContainerUtil.getFirstItem((List)child.getChildrenStubs());
                    LOG.assertTrue(stub != null, (Object)("Null stub for " + String.valueOf(stub) + (child.getPsi().isValid() ? child.getPsi().getContainingFile().getVirtualFile().getPath() : "")));
                    RPsiStructureElement psi = (RPsiStructureElement)stub.getPsi();
                    elements.add((RPsiStructureElement)psi);
                }
            }
            elements.add((RPsiStructureElement)((RPsiStructureElement)element));
        }
    }

    public static boolean isClassEval(@NotNull RBlockCall call) {
        if (call == null) {
            RContainerUtil.$$$reportNull$$$0(5);
        }
        String command = call.getCommand();
        return "class_eval".equals(command);
    }

    public static boolean isContextChangingBlockCall(@NotNull RBlockCall call) {
        String command;
        if (call == null) {
            RContainerUtil.$$$reportNull$$$0(6);
        }
        if ("class_eval".equals(command = call.getCommand()) || "autoload_under".equals(command)) {
            return true;
        }
        call.getCall();
        return "RSpec.configure".equals(call.getCall().getText());
    }

    @NotNull
    public static List<RClass> getTopLevelClasses(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(7);
        }
        ArrayList<RClass> allClasses = new ArrayList<RClass>();
        RContainerUtil.gatherClasses(container, allClasses);
        ArrayList<RClass> arrayList = allClasses;
        if (arrayList == null) {
            RContainerUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static List<RClass> getAllClasses(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(9);
        }
        ArrayList<RClass> allClasses = new ArrayList<RClass>(RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RClass.class));
        for (RContainer element : RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RContainer.class)) {
            allClasses.addAll(RContainerUtil.getAllClasses(element));
        }
        ArrayList<RClass> arrayList = allClasses;
        if (arrayList == null) {
            RContainerUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void gatherClasses(@NotNull RContainer container, @NotNull List<? super RClass> allClasses) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(11);
        }
        if (allClasses == null) {
            RContainerUtil.$$$reportNull$$$0(12);
        }
        allClasses.addAll(RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RClass.class));
        for (RModule element : RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RModule.class)) {
            RContainerUtil.gatherClasses((RContainer)element, allClasses);
        }
    }

    public static List<RModule> getTopLevelModules(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(13);
        }
        return new ArrayList<RModule>(RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RModule.class));
    }

    public static List<String> getAllModulesNames(@NotNull RContainer container) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(14);
        }
        return RContainerUtil.getAllModulesNamesImpl(container, "");
    }

    private static List<String> getAllModulesNamesImpl(@NotNull RContainer container, @NotNull String parentModuleName) {
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(15);
        }
        if (parentModuleName == null) {
            RContainerUtil.$$$reportNull$$$0(16);
        }
        ArrayList<String> modules = new ArrayList<String>();
        Object prefix = Objects.equals(parentModuleName, "") ? "" : parentModuleName + "::";
        for (RModule element : RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RModule.class)) {
            String moduleName = (String)prefix + element.getFQN().getFullPath();
            modules.add(moduleName);
            modules.addAll(RContainerUtil.getAllModulesNamesImpl((RContainer)element, moduleName));
        }
        return modules;
    }

    @Nullable
    public static RClass getFirstClassInFile(@Nullable PsiFile psiFile) {
        List<RClass> allClasses;
        if (psiFile instanceof RFile && !(allClasses = RContainerUtil.getTopLevelClasses((RContainer)((RFile)psiFile))).isEmpty()) {
            return allClasses.get(0);
        }
        return null;
    }

    @Nullable
    public static RModule getFirstModuleInFile(@Nullable PsiFile psiFile) {
        List<RModule> allModules;
        if (psiFile instanceof RFile && !(allModules = RContainerUtil.getTopLevelModules((RContainer)((RFile)psiFile))).isEmpty()) {
            return allModules.get(0);
        }
        return null;
    }

    @Nullable
    public static RPossibleCall findCall(@NotNull RContainer container, @NotNull Predicate<RubyCallType<?>> predicate) {
        StubElement stub;
        if (container == null) {
            RContainerUtil.$$$reportNull$$$0(17);
        }
        if (predicate == null) {
            RContainerUtil.$$$reportNull$$$0(18);
        }
        if (container instanceof StubBasedPsiElementBase) {
            StubBasedPsiElementBase stubBasedContainer = (StubBasedPsiElementBase)container;
            v0 = stubBasedContainer.getGreenStub();
        } else {
            v0 = stub = null;
        }
        if (stub != null) {
            for (RPossibleCallStub child : ContainerUtil.filterIsInstance((Collection)stub.getChildrenStubs(), RPossibleCallStub.class)) {
                if (!predicate.test(child.getCallData().getCallType())) continue;
                return (RPossibleCall)ObjectUtils.tryCast((Object)child.getPsi(), RPossibleCall.class);
            }
            return null;
        }
        for (RPossibleCall statement : ContainerUtil.filterIsInstance((Collection)container.getCompoundStatement().getStatements(), RPossibleCall.class)) {
            if (!predicate.test(statement.getCallType())) continue;
            return statement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allClasses";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentModuleName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassByName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMethodByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStructureElements";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isClassEval";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isContextChangingBlockCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClasses";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "gatherClasses";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelModules";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesNamesImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static class RPsiElementCollector
    extends RubyRecursiveElementVisitor {
        @NotNull
        protected final Collection<? super RPsiStructureElement> myElements;
        @NotNull
        protected final RPsiElement myContainer;

        public RPsiElementCollector(@NotNull Collection<? super RPsiStructureElement> elements, @NotNull RPsiElement container) {
            if (elements == null) {
                RPsiElementCollector.$$$reportNull$$$0(0);
            }
            if (container == null) {
                RPsiElementCollector.$$$reportNull$$$0(1);
            }
            this.myElements = elements;
            this.myContainer = container;
        }

        public void visitRModule(@NotNull RModule rModule) {
            if (rModule == null) {
                RPsiElementCollector.$$$reportNull$$$0(2);
            }
            this.myElements.add((RPsiStructureElement)rModule);
        }

        public void visitRClass(@NotNull RClass rClass) {
            if (rClass == null) {
                RPsiElementCollector.$$$reportNull$$$0(3);
            }
            this.myElements.add((RPsiStructureElement)rClass);
        }

        public void visitRObjectClass(@NotNull RObjectClass rMetaClass) {
            if (rMetaClass == null) {
                RPsiElementCollector.$$$reportNull$$$0(4);
            }
            this.myElements.add((RPsiStructureElement)rMetaClass);
        }

        public void visitRMethod(@NotNull RMethod rMethod) {
            if (rMethod == null) {
                RPsiElementCollector.$$$reportNull$$$0(5);
            }
            this.myElements.add((RPsiStructureElement)rMethod);
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod rSingletonMethod) {
            if (rSingletonMethod == null) {
                RPsiElementCollector.$$$reportNull$$$0(6);
            }
            this.myElements.add((RPsiStructureElement)rSingletonMethod);
        }

        public void visitRBlockCall(@NotNull RBlockCall blockCall) {
            if (blockCall == null) {
                RPsiElementCollector.$$$reportNull$$$0(7);
            }
            if ((RContainerUtil.isClassEval(blockCall) || blockCall.getCallType() instanceof CallTypeWithStructurePresentation) && this.myContainer != blockCall) {
                this.myElements.add((RPsiStructureElement)blockCall);
            } else {
                super.visitRBlockCall(blockCall);
            }
        }

        public void visitRCall(@NotNull RCall rCall) {
            RubyCallType type;
            if (rCall == null) {
                RPsiElementCollector.$$$reportNull$$$0(8);
            }
            if ((type = rCall.getCallType()) instanceof RubyVisibilityCallTypeImpl) {
                for (String arg : (List)rCall.getData(new RubyCallType[]{(RubyVisibilityCallTypeImpl)type})) {
                    RPsiElement first;
                    if (!RubyVisibilityCallTypeKt.isMethodArg((String)arg) || !((first = (RPsiElement)ContainerUtil.getFirstItem((List)rCall.getArguments())) instanceof RMethodImpl)) continue;
                    this.visitRMethod((RMethod)((RMethodImpl)first));
                    break;
                }
            }
            if (type.isPersistent()) {
                RBlockCall call;
                if ((RubyCallTypesCore.isIncludeOrPrependCall((RPossibleCall)rCall) || RubyCallTypesCore.isExtendCall((RPossibleCall)rCall)) && (call = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)rCall, RBlockCall.class, (boolean)true, (Class[])new Class[]{RContainer.class, PsiFile.class})) != null && RContainerUtil.isContextChangingBlockCall(call) && this.myContainer != call) {
                    return;
                }
                this.myElements.add((RPsiStructureElement)rCall);
            }
        }

        public void visitRAliasStatement(@NotNull RAliasStatement rAliasStatement) {
            if (rAliasStatement == null) {
                RPsiElementCollector.$$$reportNull$$$0(9);
            }
            this.myElements.add((RPsiStructureElement)rAliasStatement);
        }

        public void visitRUndefStatement(@NotNull RUndefStatement rUndefStatement) {
            if (rUndefStatement == null) {
                RPsiElementCollector.$$$reportNull$$$0(10);
            }
            this.myElements.add((RPsiStructureElement)rUndefStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rModule";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rMetaClass";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rMethod";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rSingletonMethod";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockCall";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rCall";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rAliasStatement";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUndefStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/holders/utils/RContainerUtil$RPsiElementCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRModule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRObjectClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRSingletonMethod";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRBlockCall";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRCall";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAliasStatement";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUndefStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

