/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.regexp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.regexp.Ruby19RegexpLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.regexp.RubyVerboseRegexpLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RegexpInjector
implements LanguageInjector {
    private static final TokenSet REGEXP_SET = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tREGEXP_CONTENT, RubyTokenTypes.tESCAPE_SEQUENCE});
    private static final TokenSet STRING_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tSTRING_CONTENT, RubyTokenTypes.tESCAPE_SEQUENCE}), RubySpaceUtil.SOFT_WHITESPACES});
    private static final Set<FQN> REGEXP_CALL_FQNS = Set.of(CoreFqns.REGEXP_COMPILE, CoreFqns.REGEXP_INITIALIZE, CoreFqns.REGEXP_UNION);
    private static final Set<String> REGEXP_CALL_SHORT_NAMES = Set.of(CoreFqns.REGEXP_COMPILE.getShortName(), CoreFqns.REGEXP_NEW.getShortName(), CoreFqns.REGEXP_UNION.getShortName());

    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            RegexpInjector.$$$reportNull$$$0(0);
        }
        if (injectionPlacesRegistrar == null) {
            RegexpInjector.$$$reportNull$$$0(1);
        }
        if (host instanceof RRegexpLiteral || host instanceof RStringLiteral && RegexpInjector.isRegexpString((RStringLiteral)host)) {
            ASTNode[] children;
            if (PsiTreeUtil.getChildOfType((PsiElement)host, RExpressionSubstitution.class) != null) {
                return;
            }
            ASTNode hostNode = host.getNode();
            if (hostNode == null) {
                return;
            }
            ASTNode[] aSTNodeArray = children = host instanceof RRegexpLiteral ? hostNode.getChildren(REGEXP_SET) : hostNode.getChildren(STRING_SET);
            if (children.length > 0) {
                int startOffset = children[0].getStartOffset();
                int len = 0;
                for (ASTNode child : children) {
                    len += child.getTextLength();
                }
                if (len > 0) {
                    int offset = startOffset - hostNode.getStartOffset();
                    LanguageLevel languageLevel = RubyPsiUtilCore.getLanguageLevel((PsiElement)host);
                    boolean verbose = RegexpInjector.isVerbose((RStringLiteral)host);
                    RegExpLanguage language = RubyVMOptions.getInstance().isRuby18Enabled(languageLevel) ? RegExpLanguage.INSTANCE : (verbose ? RubyVerboseRegexpLanguage.INSTANCE : Ruby19RegexpLanguage.INSTANCE);
                    injectionPlacesRegistrar.addPlace((Language)language, new TextRange(offset, offset + len), null, null);
                }
            }
        }
    }

    private static boolean isRegexpString(@NotNull RStringLiteral literal) {
        RPossibleCall call;
        if (literal == null) {
            RegexpInjector.$$$reportNull$$$0(2);
        }
        if ((call = RCallNavigator.getRealCall((RPossibleCall)RCallNavigator.getByRArgument((PsiElement)literal))) == null || !REGEXP_CALL_SHORT_NAMES.contains(ObjectUtils.coalesce((Object)RubyPsiUtil.getCallCommand((PsiElement)call), (Object)""))) {
            return false;
        }
        RConstant receiver = (RConstant)ObjectUtils.tryCast((Object)call.getReceiver(), RConstant.class);
        if (receiver == null || !FQN.same((FQN)CoreFqns.REGEXP, (String)receiver.getCommand())) {
            return false;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)ObjectUtils.doIfNotNull((Object)call.getPsiCommand(), PsiElement::getReference));
        if (symbol == null) {
            return false;
        }
        FQN fqn = symbol.getFQNWithNesting();
        if (CoreFqns.REGEXP_UNION.equals(fqn)) {
            return true;
        }
        return REGEXP_CALL_FQNS.contains(fqn) && literal.equals(ContainerUtil.getFirstItem((List)call.getArguments()));
    }

    private static boolean isVerbose(@NotNull RStringLiteral host) {
        if (host == null) {
            RegexpInjector.$$$reportNull$$$0(3);
        }
        if (host instanceof RRegexpLiteral) {
            PsiElement end = host.getLastChild();
            String options = end instanceof TreeElement && ((TreeElement)end).getElementType() == RubyTokenTypes.tREGEXP_END && !end.getText().isEmpty() ? end.getText().substring(1) : StringUtil.substringAfterLast((String)host.getText(), (String)"/");
            return StringUtil.isNotEmpty((String)options) && options.contains("x");
        }
        RCall call = RCallNavigator.getByFirstRArgument((PsiElement)host);
        return call != null && ContainerUtil.exists((Iterable)call.getCallArguments().getElements(), it -> FQN.same((FQN)CoreFqns.REGEXP_EXTENDED, (String)it.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPlacesRegistrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/basicTypes/stringLiterals/regexp/RegexpInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegexpString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVerbose";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

