/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl;

import com.intellij.FilePropertyPusherBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.psi.FilePropertyKey;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Font;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelServiceBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyLanguageLevelPusher
extends FilePropertyPusherBase<String> {
    private static final Map<LanguageLevel, RowIcon> ourLanguageLevelToIconMap = new HashMap<LanguageLevel, RowIcon>();

    @NotNull
    public FilePropertyKey<String> getFilePropertyKey() {
        FilePropertyKey filePropertyKey = RubyLanguageLevelServiceBase.filePropertyKey;
        if (filePropertyKey == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        return filePropertyKey;
    }

    @Nullable
    public String getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        LanguageLevel languageLevel;
        if (project == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return (languageLevel = RubyLanguageLevelPusher.getLanguageLevelByFile(project, file)) == null ? null : languageLevel.name();
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public String getDefaultValue() {
        String string = LanguageLevel.latest().name();
        if (string == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getImmediateValue(@NotNull Module module) {
        if (module == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return RModuleUtil.getInstance().getLanguageLevelByModule(module).name();
    }

    public static void pushLanguageLevelIfNeeded(@NotNull LanguageLevel oldLanguageLevel, @NotNull LanguageLevel newLanguageLevel, Project ... affectedProjects) {
        if (oldLanguageLevel == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        if (newLanguageLevel == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        if (affectedProjects == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (affectedProjects.length == 0 || newLanguageLevel == oldLanguageLevel) {
            return;
        }
        for (Project project : affectedProjects) {
            if (project.isDefault()) continue;
            PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new RubyLanguageLevelPusher()});
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    @NotNull
    public static LanguageLevel getHighestLanguageLevel(@NotNull Project project) {
        if (project == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        LanguageLevel result = null;
        for (Module module : RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
            LanguageLevel languageLevel = RModuleUtil.getInstance().getLanguageLevelByModule(module);
            if (result != null && !result.isLessThan(languageLevel)) continue;
            result = languageLevel;
        }
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.coalesce(result, (Object)LanguageLevel.latest());
        if (languageLevel == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        return languageLevel;
    }

    @Nullable
    public static LanguageLevel getLanguageLevelByFile(@Nullable Project project, @Nullable VirtualFile file) {
        LanguageLevel forcedLanguageLevel = RubyVMOptions.getInstance().getForcedLanguageLevel();
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        LanguageLevel languageLevel = RubyLanguageLevelServiceBase.getLanguageLevelForFile((VirtualFile)file);
        if (languageLevel != null) {
            return languageLevel;
        }
        if (project == null || project.isDefault()) {
            return null;
        }
        RModuleUtil rModuleUtil = RModuleUtil.getInstance();
        if (file == null || file instanceof LightVirtualFile) {
            LanguageLevel result = null;
            for (Module rubyModule : rModuleUtil.getAllModulesWithRubySupport(project)) {
                LanguageLevel moduleLanguageLevel = rModuleUtil.getLanguageLevelByModule(rubyModule);
                if (result != null && !result.isLessThan(moduleLanguageLevel)) continue;
                result = moduleLanguageLevel;
            }
            return result != null ? result : LanguageLevel.latest();
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null) {
            return rModuleUtil.getLanguageLevelByModule(module);
        }
        LanguageLevel result = RubyLanguageLevelPusher.findForSdkOrGem(project, file);
        if (result != null) {
            return result;
        }
        return RubyLanguageLevelPusher.getLanguageLevelForProject(project);
    }

    @NotNull
    private static LanguageLevel getLanguageLevelForProject(@NotNull Project project) {
        if (project == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        Module primaryModule = ModuleAttachProcessor.getPrimaryModule((Project)project);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(primaryModule);
        LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk);
        if (languageLevel == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    @Contract(value="_,null -> null")
    @Nullable
    private static LanguageLevel findForSdkOrGem(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        if (file == null) {
            return null;
        }
        List orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry orderEntry : orderEntries) {
            Sdk sdk;
            LibraryOrderEntry entry;
            String name;
            String sdkName;
            if (orderEntry instanceof JdkOrderEntry) {
                return RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)((JdkOrderEntry)orderEntry).getJdk());
            }
            if (!(orderEntry instanceof LibraryOrderEntry) || (sdkName = GemInfo.getSdkName(name = (entry = (LibraryOrderEntry)orderEntry).getLibraryName())) == null || (sdk = ProjectJdkTable.getInstance().findJdk(sdkName)) == null) continue;
            return RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk);
        }
        return null;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (project == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        return true;
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String languageLevelString) {
        if (project == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (fileOrDir == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        if (languageLevelString == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, child -> FileTypeRegistry.getInstance().isFileOfType(child, (FileType)RubyFileType.RUBY));
    }

    @NotNull
    public static Icon getOrCreateLanguageLevelIcon(@NotNull LanguageLevel languageLevel) {
        RowIcon icon;
        if (languageLevel == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        if ((icon = ourLanguageLevelToIconMap.get(languageLevel)) != null) {
            RowIcon rowIcon = icon;
            if (rowIcon == null) {
                RubyLanguageLevelPusher.$$$reportNull$$$0(18);
            }
            return rowIcon;
        }
        icon = IconManager.getInstance().createRowIcon(2, RowIcon.Alignment.CENTER);
        TextIcon textIcon = new TextIcon(languageLevel.getShortName(), JBColor.foreground(), null, 0);
        textIcon.setFont((Font)JBUI.Fonts.smallFont());
        textIcon.setInsets((Insets)new JBInsets(0, 4, 0, 0));
        icon.setIcon((Icon)textIcon, 0);
        icon.setIcon(AllIcons.General.ArrowDown, 1);
        ourLanguageLevelToIconMap.put(languageLevel, icon);
        RowIcon rowIcon = icon;
        if (rowIcon == null) {
            RubyLanguageLevelPusher.$$$reportNull$$$0(19);
        }
        return rowIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelPusher";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLanguageLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLanguageLevel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedProjects";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelString";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelPusher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighestLanguageLevel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForProject";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLanguageLevelIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushLanguageLevelIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHighestLanguageLevel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelForProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findForSdkOrGem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLanguageLevelIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

