/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.RubyDataKeys;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.ConcatGraph;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.SubGraph;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"getInstructionGraph", "Lcom/intellij/util/graph/Graph;", "Lcom/intellij/codeInsight/controlflow/Instruction;", "Lorg/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/ControlFlowHolder;", "isTooBig", "", "collectBackWOBackEdges", "", "graph", "start", "concat", "firstGraph", "secondGraph", "exitElement", "Lcom/intellij/psi/PsiElement;", "intellij.ruby.backend"})
@JvmName(name="InstructionGraphUtil")
@SourceDebugExtension(value={"SMAP\nInstructionGraphUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionGraphUtil.kt\norg/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/InstructionGraphUtil\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n67#2:141\n295#3,2:142\n295#3,2:144\n*S KotlinDebug\n*F\n+ 1 InstructionGraphUtil.kt\norg/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/InstructionGraphUtil\n*L\n35#1:141\n40#1:142,2\n90#1:144,2\n*E\n"})
public final class InstructionGraphUtil {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Graph<Instruction> getInstructionGraph(@NotNull ControlFlowHolder $this$getInstructionGraph) {
        Graph graph;
        block10: {
            Object v5;
            PsiElement parentHolder;
            block9: {
                PsiElement psiElement;
                block12: {
                    block11: {
                        void $this$parentOfType$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$getInstructionGraph, (String)"<this>");
                        Graph graph2 = RControlFlowUtil.getGraphWithoutRBlockCall((RControlFlow)$this$getInstructionGraph.getControlFlow());
                        Intrinsics.checkNotNullExpressionValue((Object)graph2, (String)"getGraphWithoutRBlockCall(...)");
                        graph = graph2;
                        if (InstructionGraphUtil.isTooBig((Graph<Instruction>)graph)) {
                            return InstructionGraphUtilCore.TOO_BIG_GRAPH;
                        }
                        if ($this$getInstructionGraph instanceof RCodeBlock) {
                            ControlFlowHolder controlFlowHolder = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)$this$getInstructionGraph), ControlFlowHolder.class, (boolean)true);
                            if (controlFlowHolder == null) {
                                return graph;
                            }
                            ControlFlowHolder parentHolder2 = controlFlowHolder;
                            RPossibleCall rPossibleCall = (RPossibleCall)ObjectUtils.coalesce((Object)((RCodeBlock)$this$getInstructionGraph).getBlockCall(), (Object)((RCodeBlock)$this$getInstructionGraph).getLambdaCall());
                            if (rPossibleCall == null) {
                                return graph;
                            }
                            RPossibleCall exitElement = rPossibleCall;
                            return InstructionGraphUtil.concat(InstructionGraphUtil.getInstructionGraph(parentHolder2), (Graph<Instruction>)graph, (PsiElement)exitElement);
                        }
                        if (!($this$getInstructionGraph instanceof RubyExpressionCodeFragment)) break block10;
                        psiElement = ((RubyExpressionCodeFragment)$this$getInstructionGraph).getContext();
                        if (psiElement == null) break block11;
                        PsiElement psiElement2 = psiElement;
                        boolean withSelf$iv = true;
                        boolean $i$f$parentOfType = false;
                        psiElement = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, ControlFlowHolder.class, (boolean)false);
                        if (psiElement != null) break block12;
                    }
                    return graph;
                }
                parentHolder = psiElement;
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((RubyExpressionCodeFragment)$this$getInstructionGraph).getContext(), RExpression.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                Collection children = collection;
                Object object = ((RubyExpressionCodeFragment)$this$getInstructionGraph).getContext();
                int offset = object != null && (object = (Integer)object.getCopyableUserData(RubyDataKeys.RUBY_CONSOLE_CONTEXT_OFFSET_KEY)) != null ? (Integer)object : -1;
                Iterable $this$firstOrNull$iv = children;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RExpression it = (RExpression)element$iv;
                    boolean bl = false;
                    if (!(0 <= offset && offset <= it.getTextRange().getStartOffset())) continue;
                    v5 = element$iv;
                    break block9;
                }
                v5 = null;
            }
            RExpression exitElement = v5;
            if (exitElement != null) {
                return InstructionGraphUtil.concat(InstructionGraphUtil.getInstructionGraph((ControlFlowHolder)parentHolder), (Graph<Instruction>)graph, (PsiElement)exitElement);
            }
            return InstructionGraphUtil.concat(InstructionGraphUtil.getInstructionGraph((ControlFlowHolder)parentHolder), (Graph<Instruction>)graph);
        }
        return graph;
    }

    public static final boolean isTooBig(@NotNull Graph<Instruction> $this$isTooBig) {
        Intrinsics.checkNotNullParameter($this$isTooBig, (String)"<this>");
        return $this$isTooBig == InstructionGraphUtilCore.TOO_BIG_GRAPH || $this$isTooBig.getNodes().size() > RControlFlowBuilder.getMaxCfgSize();
    }

    private static final Set<Instruction> collectBackWOBackEdges(Graph<Instruction> graph, Instruction start) {
        LinkedHashSet<Instruction> set = new LinkedHashSet<Instruction>();
        Stack stack = new Stack();
        set.add(start);
        stack.push((Object)start);
        DFSTBuilder dfstBuilder = new DFSTBuilder((OutboundSemiGraph)graph, (Object)InstructionGraphUtilCore.getEntry(graph));
        Comparator comparator = dfstBuilder.comparator(true);
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"comparator(...)");
        Comparator comparator2 = comparator;
        while (!stack.empty()) {
            Iterator predecessorIterator;
            Instruction currentNode = (Instruction)stack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)graph.getIn((Object)currentNode), (String)"getIn(...)");
            while (predecessorIterator.hasNext()) {
                Instruction predecessor = (Instruction)predecessorIterator.next();
                if (comparator2.compare(predecessor, currentNode) >= 0 || !set.add(predecessor)) continue;
                stack.push((Object)predecessor);
            }
        }
        return set;
    }

    private static final Graph<Instruction> concat(Graph<Instruction> firstGraph, Graph<Instruction> secondGraph) {
        if (InstructionGraphUtil.isTooBig(firstGraph) || InstructionGraphUtil.isTooBig(secondGraph) || firstGraph.getNodes().size() + secondGraph.getNodes().size() > RControlFlowBuilder.getMaxCfgSize()) {
            return InstructionGraphUtilCore.TOO_BIG_GRAPH;
        }
        Collection collection = firstGraph.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
        Instruction instruction = (Instruction)CollectionsKt.lastOrNull((Iterable)collection);
        if (instruction == null) {
            return secondGraph;
        }
        Instruction firstExit = instruction;
        SubGraph graphBefore = new SubGraph(firstGraph, InstructionGraphUtil.collectBackWOBackEdges(firstGraph, firstExit));
        Instruction secondEntry = InstructionGraphUtilCore.getEntry(secondGraph);
        return new ConcatGraph((Graph<Instruction>)((Graph)graphBefore), secondGraph, firstExit, secondEntry);
    }

    private static final Graph<Instruction> concat(Graph<Instruction> firstGraph, Graph<Instruction> secondGraph, PsiElement exitElement) {
        Object v1;
        block3: {
            if (InstructionGraphUtil.isTooBig(firstGraph) || InstructionGraphUtil.isTooBig(secondGraph) || firstGraph.getNodes().size() + secondGraph.getNodes().size() > RControlFlowBuilder.getMaxCfgSize()) {
                return InstructionGraphUtilCore.TOO_BIG_GRAPH;
            }
            Collection collection = firstGraph.getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Instruction it = (Instruction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElement(), (Object)exitElement)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Instruction instruction = v1;
        if (instruction == null) {
            return secondGraph;
        }
        Instruction firstExit = instruction;
        SubGraph graphBefore = new SubGraph(firstGraph, InstructionGraphUtil.collectBackWOBackEdges(firstGraph, firstExit));
        Instruction secondEntry = InstructionGraphUtilCore.getEntry(secondGraph);
        return new ConcatGraph((Graph<Instruction>)((Graph)graphBefore), secondGraph, firstExit, secondEntry);
    }
}

