/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001f\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001f\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlFlow/ConcatGraph;", "Lcom/intellij/util/graph/Graph;", "Lcom/intellij/codeInsight/controlflow/Instruction;", "firstGraph", "secondGraph", "from", "to", "<init>", "(Lcom/intellij/util/graph/Graph;Lcom/intellij/util/graph/Graph;Lcom/intellij/codeInsight/controlflow/Instruction;Lcom/intellij/codeInsight/controlflow/Instruction;)V", "getFirstGraph", "()Lcom/intellij/util/graph/Graph;", "getSecondGraph", "getFrom", "()Lcom/intellij/codeInsight/controlflow/Instruction;", "getTo", "firstNodes", "", "kotlin.jvm.PlatformType", "getFirstNodes", "()Ljava/util/Set;", "secondNodes", "getSecondNodes", "allNodes", "getAllNodes", "getNodes", "", "getIn", "", "n", "getOut", "intellij.ruby.backend"})
final class ConcatGraph
implements Graph<Instruction> {
    @NotNull
    private final Graph<Instruction> firstGraph;
    @NotNull
    private final Graph<Instruction> secondGraph;
    @NotNull
    private final Instruction from;
    @NotNull
    private final Instruction to;
    @NotNull
    private final Set<Instruction> firstNodes;
    @NotNull
    private final Set<Instruction> secondNodes;
    @NotNull
    private final Set<Instruction> allNodes;

    public ConcatGraph(@NotNull Graph<Instruction> firstGraph, @NotNull Graph<Instruction> secondGraph, @NotNull Instruction from, @NotNull Instruction to) {
        Intrinsics.checkNotNullParameter(firstGraph, (String)"firstGraph");
        Intrinsics.checkNotNullParameter(secondGraph, (String)"secondGraph");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.firstGraph = firstGraph;
        this.secondGraph = secondGraph;
        this.from = from;
        this.to = to;
        Collection collection = this.firstGraph.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNodes(...)");
        this.firstNodes = CollectionsKt.toSet((Iterable)collection);
        Collection collection2 = this.secondGraph.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getNodes(...)");
        this.secondNodes = CollectionsKt.toSet((Iterable)collection2);
        this.allNodes = CollectionsKt.union((Iterable)this.firstNodes, (Iterable)this.secondNodes);
    }

    @NotNull
    public final Graph<Instruction> getFirstGraph() {
        return this.firstGraph;
    }

    @NotNull
    public final Graph<Instruction> getSecondGraph() {
        return this.secondGraph;
    }

    @NotNull
    public final Instruction getFrom() {
        return this.from;
    }

    @NotNull
    public final Instruction getTo() {
        return this.to;
    }

    @NotNull
    public final Set<Instruction> getFirstNodes() {
        return this.firstNodes;
    }

    @NotNull
    public final Set<Instruction> getSecondNodes() {
        return this.secondNodes;
    }

    @NotNull
    public final Set<Instruction> getAllNodes() {
        return this.allNodes;
    }

    @NotNull
    public Collection<Instruction> getNodes() {
        return this.allNodes;
    }

    @NotNull
    public Iterator<Instruction> getIn(@NotNull Instruction n) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        if (Intrinsics.areEqual((Object)n, (Object)this.to)) {
            iterator = CollectionsKt.listOf((Object)this.from).iterator();
        } else if (this.firstNodes.contains(n)) {
            Iterator iterator2 = this.firstGraph.getIn((Object)n);
            iterator = iterator2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getIn(...)");
        } else {
            Iterator iterator3 = this.secondGraph.getIn((Object)n);
            iterator = iterator3;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"getIn(...)");
        }
        return iterator;
    }

    @NotNull
    public Iterator<Instruction> getOut(@NotNull Instruction n) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        if (Intrinsics.areEqual((Object)n, (Object)this.from)) {
            iterator = CollectionsKt.listOf((Object)this.to).iterator();
        } else if (this.firstNodes.contains(n)) {
            Iterator iterator2 = this.firstGraph.getOut((Object)n);
            iterator = iterator2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"getOut(...)");
        } else {
            Iterator iterator3 = this.secondGraph.getOut((Object)n);
            iterator = iterator3;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"getOut(...)");
        }
        return iterator;
    }
}

