/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RFunctionArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RAliasStatementImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RSingletonMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.modules.RModuleImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArgumentToBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.impl.controlStructures.RLambdaNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.templates.TemplateIntegrationUtils;
import org.jetbrains.plugins.ruby.testing.BddTestsUtil;

public final class RubyPsiUtil {
    private static final Logger LOG = Logger.getInstance(RubyPsiUtil.class);
    public static final Key<Pair<RPsiElement, TextRange>> SELECTION_BREAKS_AST_NODE = new Key("ruby.selection.breaks.ast.node");

    private RubyPsiUtil() {
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile getVirtualFileFromElement(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile regularFile = containingFile.getVirtualFile();
        if (regularFile != null) {
            return regularFile;
        }
        PsiFile originalFile = containingFile.getOriginalFile();
        return originalFile != containingFile ? originalFile.getVirtualFile() : null;
    }

    public static boolean isBlockGivenToPsiElement(@Nullable PsiElement element) {
        RPossibleCall call = (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)element, RPossibleCall.class, (boolean)false);
        if (call == null) {
            return false;
        }
        RPossibleCall realCall = RCallNavigator.getRealCall((RPossibleCall)call);
        return RBlockCallNavigator.getByCall((RPsiElement)realCall) != null || ContainerUtil.or((Iterable)realCall.getArguments(), argument -> argument instanceof RArgumentToBlock);
    }

    public static boolean isLocatedInStubs(@NotNull VirtualFile file) {
        Path path;
        if (file == null) {
            RubyPsiUtil.$$$reportNull$$$0(0);
        }
        if ((path = file.getFileSystem().getNioPath(file)) == null) {
            return false;
        }
        return path.startsWith(RubySdkUtil.getRubystubsRoot()) || path.startsWith(RubySdkUtil.getRubysigsRoot());
    }

    public static boolean isLocatedInStubs(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(1);
        }
        if (!(element instanceof RPsiElement)) {
            return false;
        }
        LanguageLevel level = ((RPsiElement)element).getLanguageLevel();
        if (level == null) {
            return false;
        }
        Path stubsDirPath = RubySdkUtil.getStubsDir(level);
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return Paths.get(virtualFile.getPath(), new String[0]).startsWith(stubsDirPath);
    }

    public static boolean isCompoundPsiElement(@Nullable PsiElement element) {
        return element instanceof RCompoundStatement || element instanceof RBodyStatement;
    }

    public static List<? extends PsiElement> throughAllCompoundPsiElements(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(2);
        }
        if (!RubyPsiUtil.isCompoundPsiElement(element)) {
            return Collections.singletonList(element);
        }
        return Arrays.stream(element.getChildren()).flatMap(it -> RubyPsiUtil.throughAllCompoundPsiElements(it).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static PsiElement getParentSkippingAllCompoundPsiElements(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(3);
        }
        return ((StreamEx)((StreamEx)StreamEx.iterate((Object)element.getParent(), it -> it.getParent()).takeWhile(Objects::nonNull)).filter(it -> !RubyPsiUtil.isCompoundPsiElement(it))).findFirst().orElse(null);
    }

    @Nullable
    public static <T extends PsiElement> T getElementToLeftWithSameParent(@NotNull PsiElement element, Class<T> c) {
        PsiElement left;
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(4);
        }
        for (left = element.getPrevSibling(); left != null && !c.isInstance(left); left = left.getPrevSibling()) {
        }
        return (T)(left != null ? left : null);
    }

    public static boolean isRbiFile(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            RubyPsiUtil.$$$reportNull$$$0(5);
        }
        if ((virtualFile = file.getVirtualFile()) != null) {
            return "rbi".equals(virtualFile.getExtension());
        }
        return "rbi".equals(PathUtil.getFileExtension((String)file.getName()));
    }

    @Nullable
    public static RFile getRFile(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(6);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof RFile ? (RFile)containingFile : null;
    }

    public static void addBeforeInParent(@NotNull PsiElement anchor, PsiElement ... newElements) {
        PsiElement psiParent;
        if (anchor == null) {
            RubyPsiUtil.$$$reportNull$$$0(7);
        }
        if (newElements == null) {
            RubyPsiUtil.$$$reportNull$$$0(8);
        }
        LOG.assertTrue((psiParent = anchor.getParent()) != null);
        ASTNode parentNode = psiParent.getNode();
        ASTNode anchorNode = anchor.getNode();
        LOG.assertTrue(parentNode != null);
        LOG.assertTrue(anchorNode != null);
        for (PsiElement newElement : newElements) {
            parentNode.addChild(newElement.getNode(), anchorNode);
        }
    }

    public static void removeElements(PsiElement ... elements) {
        ASTNode parentNode;
        if (elements == null) {
            RubyPsiUtil.$$$reportNull$$$0(9);
        }
        LOG.assertTrue((parentNode = elements[0].getParent().getNode()) != null);
        for (PsiElement element : elements) {
            parentNode.removeChild(element.getNode());
        }
    }

    @Nullable
    public static RCall getCoveringRCall(@Nullable PsiElement psiElement) {
        return (RCall)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{RCall.class});
    }

    @Nullable
    public static RExpression getCoveringExpression(@Nullable PsiElement psiElement) {
        RExpression expr;
        RExpression rExpression = expr = psiElement instanceof RExpression ? (RExpression)psiElement : (RExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RExpression.class);
        if (expr != null && expr.isValid()) {
            RBlockCall blockCall;
            RCall command;
            RExpression ref = RReferenceNavigator.getRRefenceOrTopReference((PsiElement)expr);
            if (ref != null) {
                expr = ref;
            }
            if ((command = RCallNavigator.getByCommand((PsiElement)expr)) != null) {
                expr = command;
            }
            if ((blockCall = RBlockCallNavigator.getByCall((RPsiElement)expr)) != null) {
                expr = blockCall;
            }
        }
        return expr;
    }

    @Nullable
    public static RClass getContainingUpperRClass(@NotNull RContainer rContainer) {
        if (rContainer == null) {
            RubyPsiUtil.$$$reportNull$$$0(10);
        }
        RClass upperRClass = rContainer instanceof RClass ? (RClass)rContainer : null;
        RClass curr = RubyPsiUtil.getContainingRClassByContainer(rContainer);
        while (curr != null) {
            upperRClass = curr;
            curr = RubyPsiUtil.getContainingRClassByContainer((RContainer)curr);
        }
        return upperRClass;
    }

    @Nullable
    public static RClass getContainingRClassByContainer(@NotNull RContainer rContainer) {
        if (rContainer == null) {
            RubyPsiUtil.$$$reportNull$$$0(11);
        }
        for (RContainer current = rContainer.getParentContainer(); current != null; current = current.getParentContainer()) {
            if (!(current instanceof RClass)) continue;
            return (RClass)current;
        }
        return null;
    }

    @Nullable
    public static RModule getContainingRModule(@NotNull PsiElement psiElement) {
        RContainer container;
        if (psiElement == null) {
            RubyPsiUtil.$$$reportNull$$$0(12);
        }
        if (psiElement instanceof RPsiElement) {
            rPsiElement = (RPsiElement)psiElement;
        } else {
            rPsiElement = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPsiElement.class);
            if (rPsiElement == null) {
                return null;
            }
            if (rPsiElement instanceof RModule) {
                return (RModule)rPsiElement;
            }
        }
        for (container = rPsiElement.getParentContainer(); container != null && !(container instanceof RModule); container = container.getParentContainer()) {
        }
        return (RModule)container;
    }

    @Nullable
    public static RContainer getContainingRClassOrRModuleOrRFile(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiUtil.$$$reportNull$$$0(13);
        }
        return (RContainer)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)psiElement, RConstantHolder.class);
    }

    @Nullable
    public static RClass getContainingRClass(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiUtil.$$$reportNull$$$0(14);
        }
        for (RContainer current = RubyPsiUtilCore.getParentContainerOrSelf((PsiElement)psiElement); current != null; current = current.getParentContainer()) {
            if (!(current instanceof RClass)) continue;
            return (RClass)current;
        }
        return null;
    }

    @Nullable
    public static RMethod getContainingRMethod(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyPsiUtil.$$$reportNull$$$0(15);
        }
        for (RContainer current = RubyPsiUtilCore.getParentContainerOrSelf((PsiElement)psiElement); current != null; current = current.getParentContainer()) {
            if (!(current instanceof RMethod)) continue;
            return (RMethod)current;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RBlockCall getContainingRBlockCall(@Nullable PsiElement element) {
        RCodeBlock codeBlock = (RCodeBlock)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RCodeBlock.class);
        return (RBlockCall)ObjectUtils.doIfNotNull((Object)codeBlock, RCodeBlock::getBlockCall);
    }

    @NotNull
    public static TextRange getContentTextRangeInElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(16);
        }
        if (element instanceof RSymbol) {
            PsiElement content = ((RSymbol)element).getContent();
            if (content instanceof RStringLiteral) {
                TextRange textRange = RubyPsiUtil.getContentTextRangeInElement(content).shiftRight(1);
                if (textRange == null) {
                    RubyPsiUtil.$$$reportNull$$$0(17);
                }
                return textRange;
            }
            TextRange textRange = TextRange.from((int)1, (int)(element.getTextLength() - 1));
            if (textRange == null) {
                RubyPsiUtil.$$$reportNull$$$0(18);
            }
            return textRange;
        }
        if (element instanceof RStringLiteral) {
            TextRange textRange = TextRangeUtil.getEnclosingTextRange((List)((RStringLiteral)element).getContentRanges());
            if (textRange == null) {
                RubyPsiUtil.$$$reportNull$$$0(19);
            }
            return textRange;
        }
        TextRange textRange = TextRange.from((int)0, (int)element.getTextLength());
        if (textRange == null) {
            RubyPsiUtil.$$$reportNull$$$0(20);
        }
        return textRange;
    }

    @Nullable
    public static RBlockCall getParentBlockCall(@NotNull PsiElement element, @NotNull Predicate<? super RBlockCall> predicate) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(21);
        }
        if (predicate == null) {
            RubyPsiUtil.$$$reportNull$$$0(22);
        }
        RBlockCall blockCall = RubyPsiUtil.getContainingRBlockCall(element);
        while (blockCall != null) {
            if (predicate.test((RBlockCall)blockCall)) {
                return blockCall;
            }
            blockCall = RubyPsiUtil.getContainingRBlockCall((PsiElement)blockCall);
        }
        return null;
    }

    @Nullable
    public static RMethod getMethodWithPossibleZeroArgsByName(@NotNull RContainer container, @Nullable String name) {
        if (container == null) {
            RubyPsiUtil.$$$reportNull$$$0(23);
        }
        List list = RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RMethod.class);
        for (int i = list.size() - 1; i >= 0; --i) {
            RMethod method = (RMethod)list.get(i);
            if (!Objects.equals(method.getName(), name) || ContainerUtil.exists((Iterable)method.getArgumentInfos(), it -> it.getType() == ArgumentInfo.Type.SIMPLE)) continue;
            return method;
        }
        return null;
    }

    public static boolean isClassModuleOrMethodName(@NotNull PsiElement element) {
        RName rName;
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(24);
        }
        return (rName = RNameNavigator.getRName((PsiElement)element)) != null && !(rName instanceof RSuperClass) && !(rName.getParent() instanceof RAliasStatement);
    }

    public static void markGenerated(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(25);
        }
        if (element.getNode() != null) {
            ((TreeElement)element.getNode()).acceptTree((TreeElementVisitor)new GeneratedMarkerVisitor());
        }
    }

    @NotNull
    public static SearchScope restrictScopeToRubyFiles(@NotNull SearchScope originalScope) {
        if (originalScope == null) {
            RubyPsiUtil.$$$reportNull$$$0(26);
        }
        SearchScope searchScope = PsiSearchScopeUtil.restrictScopeTo((SearchScope)originalScope, (FileType[])TemplateIntegrationUtils.getInstance().allKnownFileTypes(new FileType[]{RubyFileType.RUBY}));
        if (searchScope == null) {
            RubyPsiUtil.$$$reportNull$$$0(27);
        }
        return searchScope;
    }

    public static int getOriginalTextOffset(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(28);
        }
        if (element instanceof RAliasStatementImpl) {
            return ((RAliasStatementImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RClassImpl) {
            return ((RClassImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RModuleImpl) {
            return ((RModuleImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RSingletonMethodImpl) {
            return ((RSingletonMethodImpl)element).getOriginalTextOffset();
        }
        if (element instanceof RMethodImpl) {
            return ((RMethodImpl)element).getOriginalTextOffset();
        }
        return element.getTextOffset();
    }

    public static <T> List<T> collectNotNull(Collection<? extends T> collection) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : collection) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static boolean isInRaiseCall(PsiElement element) {
        PsiElement callOrBlockOrContainer = element;
        while ((callOrBlockOrContainer = PsiTreeUtil.getParentOfType((PsiElement)callOrBlockOrContainer, (Class[])new Class[]{RContainer.class, RCodeBlock.class, RCall.class})) != null) {
            if (!(callOrBlockOrContainer instanceof RCall)) {
                return false;
            }
            if (!RubyCallTypesCore.isRaiseCall((RPossibleCall)((RCall)callOrBlockOrContainer))) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBlockCall(@NotNull PsiElement element, @NotNull Predicate<? super RBlockCall> predicate) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(29);
        }
        if (predicate == null) {
            RubyPsiUtil.$$$reportNull$$$0(30);
        }
        return RubyPsiUtil.getParentBlockCall(element, predicate) != null;
    }

    public static boolean isInBlockCallOfType(@NotNull PsiElement element, @NotNull RubyCallType<?> callType) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(31);
        }
        if (callType == null) {
            RubyPsiUtil.$$$reportNull$$$0(32);
        }
        return RubyPsiUtil.getParentBlockCall(element, blockCall -> RubyPsiUtil.isCallOfType((PsiElement)blockCall, callType)) != null;
    }

    public static boolean isCallOfType(@Nullable PsiElement element, @NotNull RubyCallType<?> callType) {
        if (callType == null) {
            RubyPsiUtil.$$$reportNull$$$0(33);
        }
        return RubyPsiUtil.isCallOfType(element, callType::equals);
    }

    public static boolean isCallOfType(@Nullable PsiElement element, @NotNull Predicate<? super RubyCallType<?>> predicate) {
        if (predicate == null) {
            RubyPsiUtil.$$$reportNull$$$0(34);
        }
        return element instanceof RPossibleCall && predicate.test(((RPossibleCall)element).getCallType());
    }

    public static boolean isCallWithCommand(@Nullable PsiElement element, String ... commands) {
        if (commands == null) {
            RubyPsiUtil.$$$reportNull$$$0(35);
        }
        return RubyPsiUtil.isCallWithCommand(element, Arrays.asList(commands)::contains);
    }

    public static boolean isCallWithCommand(@Nullable PsiElement element, @NotNull Predicate<? super String> predicate) {
        String command;
        if (predicate == null) {
            RubyPsiUtil.$$$reportNull$$$0(36);
        }
        return (command = RubyPsiUtil.getCallCommand(element)) != null && predicate.test(command);
    }

    @NotNull
    public static List<? extends RPsiElement> getCallArgumentsIncludingIndexes(@NotNull RPossibleCall call) {
        RAssignmentExpression assignment;
        RPsiElement rPsiElement;
        if (call == null) {
            RubyPsiUtil.$$$reportNull$$$0(37);
        }
        if (call instanceof RAssignmentExpression && (rPsiElement = (assignment = (RAssignmentExpression)call).getObject()) instanceof RArrayIndexing) {
            RArrayIndexing indexing = (RArrayIndexing)rPsiElement;
            ArrayList arguments = new ArrayList(indexing.getIndexes());
            if (!arguments.isEmpty()) {
                arguments.addAll(call.getArguments());
            }
            ArrayList arrayList = arguments;
            if (arrayList == null) {
                RubyPsiUtil.$$$reportNull$$$0(38);
            }
            return arrayList;
        }
        List list = call.getArguments();
        if (list == null) {
            RubyPsiUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @Nullable
    public static String getCallCommand(@Nullable PsiElement element) {
        RBlockCall blockCall;
        if (!(element instanceof RPossibleCall)) {
            return null;
        }
        RPossibleCall call = (RPossibleCall)element;
        if (call instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)call;
            return (String)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getCallCommand((PsiElement)assignment.getObject()), it -> it + "=");
        }
        if (call instanceof RArrayIndexing) {
            return "[]";
        }
        if (call instanceof RLambdaCall || call instanceof RBlockCall && (blockCall = (RBlockCall)call).getCall() instanceof RLambdaCall) {
            return "call";
        }
        PsiElement commandElement = call.getPsiCommand();
        if (commandElement != null) {
            return commandElement instanceof RPossibleCall ? ((RPossibleCall)commandElement).getCommand() : call.getCommand();
        }
        return null;
    }

    @Nullable
    public static PsiElement getCallCommandElement(@Nullable PsiElement element) {
        PsiElement psiElement;
        if (!(element instanceof RPossibleCall)) {
            return null;
        }
        RPossibleCall call = (RPossibleCall)element;
        PsiElement command = call.getPsiCommand();
        if (command instanceof RPossibleCall) {
            RPossibleCall nestedCall = (RPossibleCall)command;
            psiElement = nestedCall.getPsiCommand();
        } else {
            psiElement = command;
        }
        return psiElement;
    }

    @Nullable
    public static String getCallCommandFollowingSuper(@NotNull RPossibleCall call) {
        if (call == null) {
            RubyPsiUtil.$$$reportNull$$$0(40);
        }
        return RubyPsiUtil.isSuperCall(call) ? (String)ObjectUtils.doIfNotNull((Object)RubyPsiUtil.getContainingRMethod((PsiElement)call), PsiNamedElement::getName) : RubyPsiUtil.getCallCommand((PsiElement)call);
    }

    public static boolean isSuperCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RubyPsiUtil.$$$reportNull$$$0(41);
        }
        return call.getPsiCommand() instanceof RPseudoConstant && RubyPsiUtil.isCallWithCommand((PsiElement)call, "super");
    }

    public static void addIncludeFQNCall(RContainer container, String fqn) {
        RExpression includeStatement = RubyElementFactoryCore.createExpressionFromText((PsiElement)container, (String)("include " + fqn));
        List statements = container.getStatements();
        if (statements.isEmpty()) {
            RCompoundStatement statement = container.getCompoundStatement();
            statement.getParent().addBefore((PsiElement)includeStatement, (PsiElement)statement);
        } else {
            for (RPsiElement statement : statements) {
                if (!RubyPsiUtil.isIncludeCall(statement)) continue;
                for (RPsiElement arg : ((RCall)statement).getArguments()) {
                    if (!fqn.equals(arg.getText())) continue;
                    return;
                }
            }
            boolean includeSectionFound = false;
            RPsiElement prevStatement = null;
            for (RPsiElement statement : statements) {
                boolean isInclude = RubyPsiUtil.isIncludeCall(statement);
                if (includeSectionFound && !isInclude) {
                    prevStatement.getParent().addAfter((PsiElement)includeStatement, (PsiElement)prevStatement);
                    return;
                }
                if (!includeSectionFound) {
                    includeSectionFound = isInclude;
                }
                prevStatement = statement;
            }
            if (!includeSectionFound) {
                RPsiElement anchorStatement = (RPsiElement)statements.get(0);
                anchorStatement.getParent().addBefore((PsiElement)includeStatement, (PsiElement)anchorStatement);
            }
        }
    }

    private static boolean isIncludeCall(RPsiElement statement) {
        return statement instanceof RCall && RubyCallTypesCore.isIncludeOrPrependCall((RPossibleCall)((RCall)statement));
    }

    public static boolean isConstantValue(PsiElement value) {
        if (value == null || value instanceof RStringLiteral || value instanceof RFloatConstant || value instanceof RIntegerConstant || value instanceof RPseudoConstant || value instanceof RConstant || value instanceof RColonReference || value instanceof RTopConstReference || value instanceof RIdentifier && (((RIdentifier)value).isParameter() || ((RIdentifier)value).isLocalVariable())) {
            return true;
        }
        if (value instanceof RUnaryExpression) {
            return RubyPsiUtil.isConstantValue((PsiElement)((RUnaryExpression)value).getElement());
        }
        if (value instanceof RBinaryExpression) {
            return RubyPsiUtil.isConstantValue((PsiElement)((RBinaryExpression)value).getLeftOperand()) && RubyPsiUtil.isConstantValue((PsiElement)((RBinaryExpression)value).getRightOperand());
        }
        return false;
    }

    @NotNull
    public static String deparenthesize(@NotNull RGroupedExpression element) {
        RPsiElement expression;
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(42);
        }
        if ((expression = element.getExpression()) != null) {
            String string = StringUtil.notNullize((String)expression.getText());
            if (string == null) {
                RubyPsiUtil.$$$reportNull$$$0(43);
            }
            return string;
        }
        return "";
    }

    public static boolean isInParentheses(RPsiElement element) {
        String elementText = element.getText();
        return elementText.startsWith("(") && elementText.endsWith(")");
    }

    @Nullable
    public static IElementType getNegativeKeyword(@NotNull RConditionalStatement conditional) {
        if (conditional == null) {
            RubyPsiUtil.$$$reportNull$$$0(44);
        }
        if (conditional instanceof RBlockStatement) {
            if (conditional instanceof RIfStatement) {
                return RubyTokenTypes.kUNLESS;
            }
            if (conditional instanceof RUnlessStatement) {
                return RubyTokenTypes.kIF;
            }
            if (conditional instanceof RWhileStatement) {
                return RubyTokenTypes.kUNTIL;
            }
            if (conditional instanceof RUntilStatement) {
                return RubyTokenTypes.kWHILE;
            }
        } else if (conditional instanceof RModifierStatement) {
            if (conditional instanceof RIfModStatement) {
                return RubyTokenTypes.kUNLESS;
            }
            if (conditional instanceof RUnlessModStatement) {
                return RubyTokenTypes.kIF;
            }
            if (conditional instanceof RWhileModStatement) {
                return RubyTokenTypes.kUNTIL;
            }
            if (conditional instanceof RUntilModStatement) {
                return RubyTokenTypes.kWHILE;
            }
        }
        return null;
    }

    public static Comparator<PsiElement> getRelativePositionComparator() {
        return RelativePositionComparator.INSTANCE;
    }

    @Contract(value="null -> false")
    public static boolean isSimpleStringOrSymbol(@Nullable PsiElement element) {
        return element instanceof RSymbol || element instanceof RStringLiteral && !((RStringLiteral)element).hasExpressionSubstitutions();
    }

    @Contract(value="null -> false")
    public static boolean isStringWithExpressionSubstitutions(@Nullable PsiElement element) {
        return element instanceof RStringLiteral && ((RStringLiteral)element).hasExpressionSubstitutions();
    }

    public static boolean interpretCallsOnPathFromElement(@NotNull PsiElement psiElement, BddTestsUtil.ActivePsiCallable ... callables) {
        RPsiElement element;
        if (psiElement == null) {
            RubyPsiUtil.$$$reportNull$$$0(45);
        }
        if (callables == null) {
            RubyPsiUtil.$$$reportNull$$$0(46);
        }
        RPsiElement rPsiElement = element = psiElement instanceof RPsiElement ? (RPsiElement)psiElement : (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPsiElement.class);
        if (element == null) {
            return false;
        }
        RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
        for (BddTestsUtil.ActivePsiCallable callable : callables) {
            callable.register(interpreter);
        }
        interpreter.interpretCallsTreePath((PsiElement)element, null);
        return true;
    }

    public static boolean isPsiAfterNumberLiteral(@NotNull PsiElement element) {
        PsiElement previousLeaf;
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(47);
        }
        if ((previousLeaf = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true)) == null) {
            return false;
        }
        return TokenBNF.tNUMBERS.contains(previousLeaf.getNode().getElementType());
    }

    public static boolean isPsiInStringLiteral(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(48);
        }
        ASTNode node = element.getNode();
        return TokenBNF.tSTRING_LIKE_CONTENTS.contains(node.getElementType());
    }

    public static boolean isInArgumentDeclaration(@NotNull PsiElement element) {
        RArgument argument;
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(49);
        }
        if ((argument = (RArgument)PsiTreeUtil.getParentOfType((PsiElement)element, RArgument.class)) == null) {
            return false;
        }
        if (!argument.getType().isOptional()) {
            return true;
        }
        RPsiElement argumentValue = argument.getValue();
        return !PsiTreeUtil.isAncestor((PsiElement)argumentValue, (PsiElement)element, (boolean)false);
    }

    public static boolean isSignaturesSame(@NotNull RMethod method1, @NotNull RMethod method2) {
        if (method1 == null) {
            RubyPsiUtil.$$$reportNull$$$0(50);
        }
        if (method2 == null) {
            RubyPsiUtil.$$$reportNull$$$0(51);
        }
        List args1 = method1.getArgumentInfos();
        List args2 = method2.getArgumentInfos();
        HashMap namedArgs1 = new HashMap();
        HashMap namedArgs2 = new HashMap();
        if (args1.size() != args2.size()) {
            return false;
        }
        BiPredicate<ArgumentInfo, Map> argumentWithName = (element, set) -> {
            if (element.getType().isKeyword()) {
                set.put(element.getName(), element.getType() == ArgumentInfo.Type.NAMED);
                return true;
            }
            return false;
        };
        args1.removeIf(element -> argumentWithName.test((ArgumentInfo)element, namedArgs1));
        args2.removeIf(element -> argumentWithName.test((ArgumentInfo)element, namedArgs2));
        if (args1.size() != args2.size()) {
            return false;
        }
        if (!namedArgs1.equals(namedArgs2)) {
            return false;
        }
        for (int i = 0; i < args1.size(); ++i) {
            if (((ArgumentInfo)args1.get(i)).getType() == ((ArgumentInfo)args2.get(i)).getType()) continue;
            return false;
        }
        return true;
    }

    public static boolean canInsertArgumentOfType(@NotNull RMethod method, @NotNull ArgumentInfo.Type type) {
        if (method == null) {
            RubyPsiUtil.$$$reportNull$$$0(52);
        }
        if (type == null) {
            RubyPsiUtil.$$$reportNull$$$0(53);
        }
        return switch (type) {
            case ArgumentInfo.Type.SIMPLE -> true;
            case ArgumentInfo.Type.PREDEFINED -> RubyPsiUtil.canInsertPredefinedArgument(method);
            case ArgumentInfo.Type.KEYREQ -> RubyPsiUtilCore.getLanguageLevel((PsiElement)method).isGreaterThan(LanguageLevel.RUBY20);
            case ArgumentInfo.Type.NAMED -> RubyPsiUtilCore.getLanguageLevel((PsiElement)method).isGreaterThan(LanguageLevel.RUBY19);
            case ArgumentInfo.Type.ARRAY -> RubyPsiUtil.canInsertArrayArgument(method);
            default -> false;
        };
    }

    private static boolean canInsertPredefinedArgument(@NotNull RMethod method) {
        if (method == null) {
            RubyPsiUtil.$$$reportNull$$$0(54);
        }
        List arguments = method.getArguments();
        for (RArgument argument : arguments) {
            if (argument.getType() != ArgumentInfo.Type.ARRAY) continue;
            return false;
        }
        return true;
    }

    private static boolean canInsertArrayArgument(@NotNull RMethod method) {
        if (method == null) {
            RubyPsiUtil.$$$reportNull$$$0(55);
        }
        List arguments = method.getArguments();
        for (RArgument argument : arguments) {
            if (argument.getType() != ArgumentInfo.Type.ARRAY && argument.getType() != ArgumentInfo.Type.PREDEFINED) continue;
            return false;
        }
        return true;
    }

    public static boolean isNil(@NotNull RPsiElement element) {
        ASTNode node;
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(56);
        }
        if ((node = element.getNode()) instanceof CompositeElement) {
            node = node.getFirstChildNode();
        }
        return node.getElementType() == RubyTokenTypesCore.kNIL;
    }

    @Nullable
    public static RAssignmentExpression getAnyAssignmentByLeftPart(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiUtil.$$$reportNull$$$0(57);
        }
        RAssignmentExpression assignment = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)element);
        RSelfAssignmentExpression selfAssignment = RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)element);
        return assignment != null ? assignment : selfAssignment;
    }

    public static boolean isInSameFile(@Nullable PsiElement firstElement, @Nullable PsiElement secondElement) {
        if (firstElement == null || secondElement == null) {
            return false;
        }
        PsiFile firstFile = (PsiFile)ObjectUtils.doIfNotNull((Object)firstElement.getContainingFile(), PsiFile::getOriginalFile);
        PsiFile secondFile = (PsiFile)ObjectUtils.doIfNotNull((Object)secondElement.getContainingFile(), PsiFile::getOriginalFile);
        return firstElement.getManager().areElementsEquivalent((PsiElement)firstFile, (PsiElement)secondFile);
    }

    public static boolean hasBlockOrLambdaArguments(@NotNull ScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            RubyPsiUtil.$$$reportNull$$$0(58);
        }
        if (!(scopeHolder instanceof RCodeBlock)) {
            return false;
        }
        RCodeBlock codeBlock = (RCodeBlock)scopeHolder;
        if (codeBlock.getBlockArguments() != null) {
            return true;
        }
        RLambda lambda = RLambdaNavigator.getByCodeBlock((RCodeBlock)codeBlock);
        if (lambda == null) {
            return false;
        }
        RArgumentList argumentList = lambda.getArgumentList();
        return argumentList != null && (argumentList instanceof RFunctionArgumentList || StringUtil.isNotEmpty((String)argumentList.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 20, 27, 38, 39, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rContainer";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 38: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyPsiUtil";
                break;
            }
            case 22: 
            case 30: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callables";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 52: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyPsiUtil";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTextRangeInElement";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeToRubyFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallArgumentsIncludingIndexes";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "deparenthesize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLocatedInStubs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "throughAllCompoundPsiElements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkippingAllCompoundPsiElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToLeftWithSameParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRbiFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeInParent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContainingUpperRClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRClassByContainer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRClassOrRModuleOrRFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContainingRMethod";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContentTextRangeInElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 38: 
            case 39: 
            case 43: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getParentBlockCall";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMethodWithPossibleZeroArgsByName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isClassModuleOrMethodName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "markGenerated";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeToRubyFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalTextOffset";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInBlockCall";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isInBlockCallOfType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCallOfType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isCallWithCommand";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCallArgumentsIncludingIndexes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCallCommandFollowingSuper";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isSuperCall";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "deparenthesize";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNegativeKeyword";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "interpretCallsOnPathFromElement";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isPsiAfterNumberLiteral";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isPsiInStringLiteral";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isInArgumentDeclaration";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isSignaturesSame";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "canInsertArgumentOfType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "canInsertPredefinedArgument";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "canInsertArrayArgument";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isNil";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getAnyAssignmentByLeftPart";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockOrLambdaArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 20, 27, 38, 39, 43 -> new IllegalStateException(string);
        };
    }

    private static class RelativePositionComparator
    implements Comparator<PsiElement> {
        private static final RelativePositionComparator INSTANCE = new RelativePositionComparator();

        private RelativePositionComparator() {
        }

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            PsiElement c1 = o1;
            PsiElement c2 = o2;
            if (o1 instanceof FakePsiElement) {
                c1 = o1.getParent();
            }
            if (o2 instanceof FakePsiElement) {
                c2 = o2.getParent();
            }
            if (c1 instanceof StubBasedPsiElementBase && c2 instanceof StubBasedPsiElementBase) {
                StubElement s1 = ((StubBasedPsiElementBase)c1).getGreenStub();
                StubElement s2 = ((StubBasedPsiElementBase)c2).getGreenStub();
                if (s1 != null && s2 != null) {
                    return -((StubBase)s1).compareByOrderWith((ObjectStubBase)((StubBase)s2));
                }
            }
            return o2.getTextRange().getEndOffset() - o1.getTextRange().getEndOffset();
        }
    }
}

