/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RubyProjectAndLibrariesScope
extends ProjectAndLibrariesScope {
    private VirtualFile myGemRoot;
    private List<VirtualFile> myGemLibRoots;

    RubyProjectAndLibrariesScope(Project project) {
        super(project);
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null && projectSdk.getSdkType() instanceof RubySdkType) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = RubySdkUtil.getSdkRoots(projectSdk)) {
                if (!GemUtil.isGemsRootUrl(root.getUrl())) continue;
                this.myGemRoot = root;
                this.myGemLibRoots = GemUtil.getAllGemsLibUrls(root);
            }
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            RubyProjectAndLibrariesScope.$$$reportNull$$$0(0);
        }
        if (this.myGemRoot != null && VfsUtilCore.isAncestor((VirtualFile)this.myGemRoot, (VirtualFile)file, (boolean)false)) {
            for (VirtualFile gemLibRoot : this.myGemLibRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)gemLibRoot, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
            return false;
        }
        return super.contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyProjectAndLibrariesScope", "contains"));
    }
}

