/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.OverriddenMethodGenerator;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyExpressionCodeFragmentImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArgumentToBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public final class RubyElementFactory {
    public static final Map<IElementType, IElementType> CLOSING_TO_OPENING_PAIRS = new HashMap<IElementType, IElementType>();

    private RubyElementFactory() {
    }

    @NotNull
    public static PsiFile createPseudoPhysicalFile(@NotNull Project project, @NotNull FileType fileType, @NotNull String text) {
        if (project == null) {
            RubyElementFactory.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            RubyElementFactory.$$$reportNull$$$0(1);
        }
        if (text == null) {
            RubyElementFactory.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("temp." + fileType.getDefaultExtension(), fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (psiFile == null) {
            RubyElementFactory.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @NotNull
    public static RubyExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, @NotNull CharSequence text, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            RubyElementFactory.$$$reportNull$$$0(4);
        }
        if (text == null) {
            RubyElementFactory.$$$reportNull$$$0(5);
        }
        String name = "fragment." + RubyFileType.RUBY.getDefaultExtension();
        RubyExpressionCodeFragmentImpl codeFragment = new RubyExpressionCodeFragmentImpl(project, name, text, isPhysical);
        codeFragment.setContext(context);
        RubyExpressionCodeFragmentImpl rubyExpressionCodeFragmentImpl = codeFragment;
        if (rubyExpressionCodeFragmentImpl == null) {
            RubyElementFactory.$$$reportNull$$$0(6);
        }
        return rubyExpressionCodeFragmentImpl;
    }

    @NotNull
    public static RArgumentToBlock createArgumentToBlockFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            RubyElementFactory.$$$reportNull$$$0(7);
        }
        if (text == null) {
            RubyElementFactory.$$$reportNull$$$0(8);
        }
        String codeFragment = "foo " + text;
        RCall call = (RCall)RubyElementFactoryCore.createExpressionFromText((PsiElement)context, (String)codeFragment);
        RArgumentToBlock rArgumentToBlock = (RArgumentToBlock)call.getCallArguments().getFirstChild();
        if (rArgumentToBlock == null) {
            RubyElementFactory.$$$reportNull$$$0(9);
        }
        return rArgumentToBlock;
    }

    @Nullable
    public static RExpressionSubstitution createExpressionSubstitutionFromText(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            RubyElementFactory.$$$reportNull$$$0(10);
        }
        if (text == null) {
            RubyElementFactory.$$$reportNull$$$0(11);
        }
        RExpression expression = RubyElementFactoryCore.createExpressionFromText((PsiElement)context, (String)("\"" + text + "\""));
        return (RExpressionSubstitution)PsiTreeUtil.getChildOfType((PsiElement)expression, RExpressionSubstitution.class);
    }

    @Nullable
    public static RExpression createExpressionWithSubstitution(@NotNull RPsiElement element, @NotNull TextRange range, @NotNull String text) {
        RExpressionSubstitution expressionSubstitution;
        if (element == null) {
            RubyElementFactory.$$$reportNull$$$0(12);
        }
        if (range == null) {
            RubyElementFactory.$$$reportNull$$$0(13);
        }
        if (text == null) {
            RubyElementFactory.$$$reportNull$$$0(14);
        }
        if ((expressionSubstitution = RubyElementFactory.createExpressionSubstitutionFromText((PsiElement)element, "#{" + text + "}")) == null) {
            return null;
        }
        Object stringText = element.getText();
        if ('\'' == ((String)stringText).charAt(0)) {
            stringText = "\"" + ((String)stringText).substring(1, ((String)stringText).length() - 1) + "\"";
        }
        String newText = ((String)stringText).substring(0, range.getStartOffset()) + expressionSubstitution.getText() + ((String)stringText).substring(range.getEndOffset());
        if (element instanceof RHeredocValue) {
            String heredocText = "def foo\n<<-RUBY_MINE\n" + newText + "RUBY_MINE\nend";
            RMethod methodWithHeredoc = (RMethod)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)heredocText);
            return (RExpression)PsiTreeUtil.findChildOfType((PsiElement)methodWithHeredoc.getCompoundStatement(), RHeredocValue.class);
        }
        return RubyElementFactoryCore.createExpressionFromText((PsiElement)element, (String)newText);
    }

    @Nullable
    public static String createMethodByElement(@NotNull ClassMember member, @NotNull LanguageLevel languageLevel, @Nullable Visibility currentPositionVisibility) {
        PsiElement element;
        if (member == null) {
            RubyElementFactory.$$$reportNull$$$0(15);
        }
        if (languageLevel == null) {
            RubyElementFactory.$$$reportNull$$$0(16);
        }
        PsiElement psiElement = element = member instanceof PsiElementMemberChooserObject ? ((PsiElementMemberChooserObject)member).getPsiElement() : null;
        if (element instanceof RMethod) {
            boolean isItMeaningfulToSpecifyVisibility;
            RMethod method = (RMethod)element;
            StringBuilder builder2 = new StringBuilder();
            boolean passMethodDirectlyToAccessModifierMethod = !languageLevel.isLessThan(LanguageLevel.RUBY21);
            boolean bl = isItMeaningfulToSpecifyVisibility = method.getVisibility() != currentPositionVisibility && !((String)ObjectUtils.chooseNotNull((Object)method.getName(), (Object)"")).equals("initialize");
            if (isItMeaningfulToSpecifyVisibility && passMethodDirectlyToAccessModifierMethod) {
                builder2.append(method.getVisibility().getPresentableName()).append(" ");
            }
            builder2.append("def ");
            if (method instanceof RSingletonMethod) {
                builder2.append("self.");
            }
            builder2.append(method.getName());
            RubyCodeStyleSettings settings = RubyCodeStyleSettings.getInstance((PsiElement)element);
            if (!method.getArgumentInfos().isEmpty()) {
                builder2.append(settings.PARENTHESES_AROUND_METHOD_ARGUMENTS ? (char)'(' : ' ');
            }
            boolean first = true;
            for (ArgumentInfo info : method.getArgumentInfos()) {
                if (!first) {
                    builder2.append(", ");
                }
                first = false;
                ArgumentInfo.Type type = info.getType();
                switch (type) {
                    case SIMPLE: {
                        builder2.append(info.getName());
                        break;
                    }
                    case PREDEFINED: {
                        builder2.append(info.getName()).append("=nil");
                        break;
                    }
                    case ARRAY: {
                        builder2.append('*').append(info.getName());
                        break;
                    }
                    case KEYREQ: {
                        builder2.append(info.getName()).append(":");
                        break;
                    }
                    case NAMED: {
                        builder2.append(info.getName()).append(":nil");
                        break;
                    }
                    case HASH: {
                        builder2.append("**").append(info.getName());
                        break;
                    }
                    case BLOCK: 
                    case BLOCK_REQUIRED: {
                        builder2.append('&').append(info.getName());
                        break;
                    }
                    case CAPTURE: {
                        builder2.append("...");
                    }
                }
            }
            if (!method.getArgumentInfos().isEmpty()) {
                builder2.append(settings.PARENTHESES_AROUND_METHOD_ARGUMENTS ? (char)')' : ' ');
            }
            builder2.append("\n  ").append("super").append("\nend");
            if (isItMeaningfulToSpecifyVisibility && !passMethodDirectlyToAccessModifierMethod) {
                builder2.append("\n").append(method.getVisibility().getPresentableName()).append(" :").append(method.getName());
            }
            return builder2.toString();
        }
        return OverriddenMethodGenerator.generate(member, languageLevel);
    }

    public static PsiElement createClosingBracket(@NotNull PsiElement context, @NotNull IElementType close) {
        IElementType open;
        if (context == null) {
            RubyElementFactory.$$$reportNull$$$0(17);
        }
        if (close == null) {
            RubyElementFactory.$$$reportNull$$$0(18);
        }
        if ((open = CLOSING_TO_OPENING_PAIRS.get(close)) == null) {
            return null;
        }
        return RubyElementFactoryCore.createElementFromText((PsiElement)context, (String)(String.valueOf(open) + " " + String.valueOf(close))).getLastChild();
    }

    static {
        CLOSING_TO_OPENING_PAIRS.put(RubyTokenTypes.tRPAREN, RubyTokenTypes.tLPAREN);
        CLOSING_TO_OPENING_PAIRS.put(RubyTokenTypes.tRBRACE, RubyTokenTypes.tLBRACE);
        CLOSING_TO_OPENING_PAIRS.put(RubyTokenTypes.tRBRACK, RubyTokenTypes.tLBRACK);
        CLOSING_TO_OPENING_PAIRS.put(RubyTokenTypes.kEND, RubyTokenTypes.kBEGIN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyElementFactory";
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPseudoPhysicalFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionCodeFragment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentToBlockFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPseudoPhysicalFile";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentToBlockFromText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionSubstitutionFromText";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionWithSubstitution";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMethodByElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createClosingBracket";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9 -> new IllegalStateException(string);
        };
    }
}

