/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public class RubyTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private Collection<PsiElement> myAllDeclarations;

    public RubyTypeHierarchyNodeDescriptor(NodeDescriptor parentDescriptor, PsiElement element, boolean isBase) {
        super(element.getProject(), parentDescriptor, element, isBase);
    }

    public RContainer getContainerElement() {
        return (RContainer)this.getPsiElement();
    }

    public boolean update() {
        NavigatablePsiElement element;
        boolean changes = super.update();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if ((element = (NavigatablePsiElement)this.getPsiElement()) == null) {
            return this.invalidElement();
        }
        ItemPresentation presentation = element.getPresentation();
        if (presentation != null) {
            RContainer container = this.getContainerElement();
            String nameWithLocation = RContainerPresentationUtil.getContainerNameWithLocation((RContainer)container, (boolean)false);
            this.myHighlightedText.getEnding().addText(nameWithLocation, classNameAttributes);
            if (this.myAllDeclarations != null) {
                this.myHighlightedText.getEnding().addText(RBundle.message((String)"multiple.declarations"), HierarchyNodeDescriptor.getPackageNameAttributes());
            } else {
                this.myHighlightedText.getEnding().addText(" (" + container.getContainingFile().getName() + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
            }
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    public Collection<PsiElement> getAllDeclarations() {
        return this.myAllDeclarations;
    }
}

