/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.AnnotationsHelperCore;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyAdditionalSpacingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubySpacingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubySorbetSpacingProcessor
implements RubyAdditionalSpacingProcessor {
    @Nullable
    public Spacing getSpacing(@NotNull Block parentBlock, @Nullable Block leftBlock, @NotNull Block rightBlock) {
        RMethod method;
        RCall call;
        if (parentBlock == null) {
            RubySorbetSpacingProcessor.$$$reportNull$$$0(0);
        }
        if (rightBlock == null) {
            RubySorbetSpacingProcessor.$$$reportNull$$$0(1);
        }
        ASTNode leftChild = RubySpacingUtil.extractNode((Block)leftBlock);
        ASTNode rightChild = RubySpacingUtil.extractNode((Block)rightBlock);
        if (leftChild == null || rightChild == null) {
            return null;
        }
        IElementType rightType = rightChild.getElementType();
        if (RubySorbetSpacingProcessor.isVisibilityCallRightBlock(rightBlock) && (call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)rightChild.getPsi(), RCall.class)) != null && (method = (RMethod)ObjectUtils.tryCast((Object)call.getCallArguments().getFirstElement(), RMethod.class)) != null && RubySorbetSpacingProcessor.hasSorbetSignature((PsiElement)method)) {
            return RubySorbetSpacingProcessor.createSorbetSignatureSpacing();
        }
        if ((rightType == RubyElementTypes.METHOD || rightType == RubyElementTypes.SINGLETON_METHOD) && RubySorbetSpacingProcessor.hasSorbetSignature(rightChild.getPsi())) {
            return RubySorbetSpacingProcessor.createSorbetSignatureSpacing();
        }
        return null;
    }

    static boolean isVisibilityCallRightBlock(@NotNull Block rightBlock) {
        if (rightBlock == null) {
            RubySorbetSpacingProcessor.$$$reportNull$$$0(2);
        }
        return RubySpacingUtil.isVisibilityCall((Block)rightBlock, (boolean)false);
    }

    static boolean hasSorbetSignature(@NotNull PsiElement element) {
        RMethod method;
        if (element == null) {
            RubySorbetSpacingProcessor.$$$reportNull$$$0(3);
        }
        if ((method = (RMethod)ObjectUtils.tryCast((Object)element, RMethod.class)) == null) {
            return false;
        }
        return AnnotationsHelperCore.findSorbetSignature((RMethod)method) != null;
    }

    static Spacing createSorbetSignatureSpacing() {
        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubySorbetSpacingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisibilityCallRightBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSorbetSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

