/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubySpacingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class RubyPostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            RubyPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            RubyPostFormatProcessor.$$$reportNull$$$0(1);
        }
        this.processText(source.getContainingFile(), source.getTextRange(), settings);
        PsiElement psiElement = source;
        if (psiElement == null) {
            RubyPostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@Nullable PsiFile psiFile, final @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (rangeToReformat == null) {
            RubyPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            RubyPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (psiFile == null || !psiFile.isValid() || !psiFile.getLanguage().isKindOf((Language)RubyLanguage.INSTANCE)) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                RubyPostFormatProcessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        final Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                RubyPostFormatProcessor.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        final ArrayList adjustments = new ArrayList();
        psiFile.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                TextRange elementRange = element.getTextRange();
                if (PsiUtilCore.getElementType((PsiElement)element) == RubyTokenTypes.tSEMICOLON && rangeToReformat.contains(elementRange) && ((TokenSet)RubySpacingProcessor.POSSIBLE_SINGLE_LINERS.get()).contains(PsiUtilCore.getElementType((PsiElement)element.getParent()))) {
                    PsiElement nextSibling = element.getNextSibling();
                    if (RubySpaceUtil.isSoftNewLine((PsiElement)nextSibling)) {
                        adjustments.add(() -> document.deleteString(elementRange.getStartOffset(), elementRange.getEndOffset()));
                    }
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyPostFormatProcessor$1", "visitElement"));
            }
        });
        int oldDocumentLength = document.getTextLength();
        for (int i = adjustments.size() - 1; i >= 0; --i) {
            ((Runnable)adjustments.get(i)).run();
        }
        psiDocumentManager.commitDocument(document);
        TextRange textRange = rangeToReformat.grown(document.getTextLength() - oldDocumentLength);
        if (textRange == null) {
            RubyPostFormatProcessor.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyPostFormatProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyPostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

