/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RForStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBracedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RubyFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    public static final long MAX_ALLOWED_TIME = 100L;
    private static final Logger LOG = Logger.getInstance(RubyFoldingBuilder.class);
    @NonNls
    public static final String CONTAINER_FOLD_TEXT = " ... end";
    @NonNls
    private static final String BLOCK_STATEMENT_FOLD_TEXT = " ... end";
    @NonNls
    private static final String BRACE_CODE_BLOCK_FOLD_TEXT = "{ ... }";
    @NonNls
    private static final String END_MARKER_FOLD_TEXT = "__END__";
    @NonNls
    private static final String BLOCK_COMMENT_FOLD_TEXT = "=begin ... =end";
    @NonNls
    private static final String HASH_FOLD_TEXT = "{ ... }";
    @NonNls
    private static final String ARRAY_FOLD_TEXT = "[ ... ]";
    @NonNls
    private static final String LBEGIN_FOLD_TEXT = "BEGIN {...}";
    @NonNls
    private static final String LEND_FOLD_TEXT = "END {...}";
    private static final String COMMENT_FOLD_TEST = "# ...";
    private static final TokenSet COLLAPSED_BY_DEFAULT = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tEND_MARKER});
    private static final NotNullLazyValue<TokenSet> FOLDED_ELEMENTS = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.MODULE, RubyElementTypes.CLASS, RubyElementTypes.OBJECT_CLASS, RubyElementTypes.METHOD, RubyElementTypes.SINGLETON_METHOD, RubyElementTypes.HEREDOC_ID, RubyElementTypes.DO_CODE_BLOCK, RubyElementTypes.BRACE_CODE_BLOCK, RubyTokenTypes.tEND_MARKER, RubyTokenTypes.tBLOCK_COMMENT, RubyElementTypes.IF_STATEMENT, RubyElementTypes.FOR_STATEMENT, RubyElementTypes.UNLESS_STATEMENT, RubyElementTypes.WHILE_STATEMENT, RubyElementTypes.UNTIL_STATEMENT, RubyElementTypes.CASE_STATEMENT, RubyElementTypes.BEGIN_END_BLOCK_STATEMENT, RubyElementTypes.LBEGIN_STATEMENT, RubyElementTypes.LEND_STATEMENT, RubyElementTypes.ASSOC_LIST, RubyElementTypes.ARRAY}));

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        long executionTime;
        if (descriptors == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (100L < (executionTime = TimeoutUtil.measureExecutionTime(() -> {
            try {
                this.collectDescriptors(root.getNode(), descriptors);
            }
            catch (StackOverflowError e) {
                LOG.warn(RBundle.message((String)"ruby.folding.too.complex.error") + " File: " + root.getContainingFile().getName() + ". File text: \n" + StringUtil.shortenTextWithEllipsis((String)root.getContainingFile().getText(), (int)512, (int)256), (Throwable)e);
            }
        }))) {
            LOG.warn("Folding regions building took too long: " + executionTime + "ms; Root size: " + root.getTextLength() + "; Ranges collected: " + descriptors.size());
        }
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors) {
        TextRange range;
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(4);
        }
        IElementType type = node.getElementType();
        if (((TokenSet)FOLDED_ELEMENTS.get()).contains(type) && (range = RubyFoldingBuilder.getFoldingTextRange(node)).getStartOffset() + 1 < range.getEndOffset()) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, range, FoldingGroup.newGroup((String)"group"), RubyFoldingBuilder.placeholderText(node), Boolean.valueOf(this.isRegionCollapsedByDefault(node)), Collections.emptySet()));
        }
        ASTNode[] children = node.getChildren(null);
        this.processLineCommentRanges(node, children, descriptors);
        for (ASTNode child : children) {
            this.collectDescriptors(child, descriptors);
        }
    }

    private void processLineCommentRanges(ASTNode node, ASTNode[] children, List<? super FoldingDescriptor> descriptors) {
        int commentsSeen = 0;
        int commentStartRange = -1;
        int commentEndRange = -1;
        boolean containsCustomRegionMarker = false;
        for (ASTNode child : children) {
            IElementType type = child.getElementType();
            if (commentStartRange == -1) {
                if (type != RubyTokenTypes.TLINE_COMMENT) continue;
                commentsSeen = 1;
                commentStartRange = child.getTextRange().getStartOffset();
                commentEndRange = child.getTextRange().getEndOffset();
                containsCustomRegionMarker |= RubyFoldingBuilder.isCustomRegionElement((PsiElement)child.getPsi());
                continue;
            }
            if (RubySpaceUtil.isAnyNewLine((IElementType)type) && !RubySpaceUtil.hasMultipleNewLines((ASTNode)child)) continue;
            if (type == RubyTokenTypes.TLINE_COMMENT) {
                ++commentsSeen;
                commentEndRange = child.getTextRange().getEndOffset();
                containsCustomRegionMarker |= RubyFoldingBuilder.isCustomRegionElement((PsiElement)child.getPsi());
                continue;
            }
            if (commentsSeen > 1 && commentEndRange - commentStartRange > 1 && !containsCustomRegionMarker) {
                TextRange range = new TextRange(commentStartRange, commentEndRange);
                String placeholderText = RubyFoldingBuilder.getLineCommentsPlaceholderText();
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, range, FoldingGroup.newGroup((String)"block_group"), placeholderText, Boolean.valueOf(this.isRegionCollapsedByDefault(node)), Collections.emptySet()));
            }
            commentStartRange = -1;
            commentEndRange = -1;
            containsCustomRegionMarker = false;
        }
        if (commentsSeen > 1 && commentStartRange != -1 && commentEndRange - commentStartRange > 1) {
            TextRange range = new TextRange(commentStartRange, node.getTextRange().getEndOffset());
            String placeholderText = RubyFoldingBuilder.getLineCommentsPlaceholderText();
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, range, FoldingGroup.newGroup((String)"block_group"), placeholderText, Boolean.valueOf(this.isRegionCollapsedByDefault(node)), Collections.emptySet()));
        }
    }

    @NotNull
    private static TextRange getFoldingTextRange(@NotNull ASTNode node) {
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = node.getPsi();
        int endOffset = node.getTextRange().getEndOffset();
        if (psiElement instanceof RContainer) {
            RName name;
            if (psiElement instanceof RObjectClass) {
                RObjectClass rObjectClass = (RObjectClass)psiElement;
                RClassObject classObject = rObjectClass.getObject();
                if (classObject != null) {
                    return new TextRange(RubyFoldingBuilder.getVisibleTextOffset((PsiElement)classObject), endOffset);
                }
                PsiElement shiftElem = RubyPsiUtilCore.getChildByFilter((PsiElement)rObjectClass, (IElementType)RubyTokenTypes.tLSHFT, (int)0);
                assert (shiftElem != null);
                return new TextRange(shiftElem.getTextRange().getEndOffset(), endOffset);
            }
            if (psiElement instanceof RMethod) {
                RMethod method = (RMethod)psiElement;
                PsiElement rparen = RubyPsiUtilCore.getChildByFilter((PsiElement)method, (IElementType)RubyTokenTypes.tRPAREN, (int)0);
                if (rparen != null) {
                    return new TextRange(RubyFoldingBuilder.getVisibleTextOffset(rparen), endOffset);
                }
                RArgumentList argumentList = method.getArgumentList();
                if (argumentList != null) {
                    return new TextRange(RubyFoldingBuilder.getVisibleTextOffset((PsiElement)argumentList), endOffset);
                }
            }
            if ((name = (RName)PsiTreeUtil.getChildOfType((PsiElement)psiElement, RName.class)) != null) {
                return new TextRange(RubyFoldingBuilder.getVisibleTextOffset((PsiElement)name), endOffset);
            }
            PsiElement firstChild = psiElement.getFirstChild();
            assert (firstChild != null);
            return new TextRange(node.getTextRange().getStartOffset() + firstChild.getTextLength(), endOffset);
        }
        if (psiElement instanceof RBracedExpression && !RubyFoldingBuilder.shouldFoldArrayOrHash(psiElement instanceof RArray ? PsiTreeUtil.getChildOfType((PsiElement)psiElement, RListOfExpressions.class) : psiElement)) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                RubyFoldingBuilder.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        if (psiElement instanceof RBlockStatement) {
            RCondition visibleElement = null;
            if (psiElement instanceof RConditionalStatement) {
                visibleElement = ((RConditionalStatement)psiElement).getCondition();
            } else if (psiElement instanceof RForStatement) {
                visibleElement = (PsiElement)ObjectUtils.coalesce((Object)((RForStatement)psiElement).getExpression(), (Object)((RForStatement)psiElement).getVariable());
            } else if (psiElement instanceof RCaseStatement) {
                visibleElement = ((RCaseStatement)psiElement).getExpression();
            }
            if (visibleElement == null) {
                visibleElement = PsiTreeUtil.getDeepestFirst((PsiElement)psiElement);
            }
            return new TextRange(visibleElement.getTextRange().getEndOffset(), endOffset);
        }
        if (psiElement instanceof RHeredocId) {
            RHeredocId heredoc = (RHeredocId)psiElement;
            PsiElement endElement = (PsiElement)ObjectUtils.coalesce((Object)heredoc.getHeredocEnd(), (Object)heredoc.getHeredocValue(), (Object)heredoc);
            return new TextRange(heredoc.getTextRange().getEndOffset(), endElement.getTextRange().getEndOffset());
        }
        TextRange textRange = node.getTextRange();
        if (textRange == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static boolean shouldFoldArrayOrHash(@Nullable PsiElement container) {
        if (container == null) {
            return false;
        }
        int numberOfElements = 0;
        for (PsiElement child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (RubySpaceUtil.isAnyNewLine((PsiElement)child)) {
                return true;
            }
            if (!(child instanceof RPsiElement) || ++numberOfElements < 5) continue;
            return true;
        }
        return false;
    }

    public static int getVisibleTextOffset(@NotNull PsiElement element) {
        if (element == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(8);
        }
        return element.getTextRange().getStartOffset() + element.getText().trim().length();
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (range == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @NotNull
    private static String placeholderText(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((type = node.getElementType()) == RubyElementTypes.BRACE_CODE_BLOCK) {
            return "{ ... }";
        }
        if (type == RubyTokenTypes.tEND_MARKER) {
            return END_MARKER_FOLD_TEXT;
        }
        if (type == RubyTokenTypes.tBLOCK_COMMENT) {
            return BLOCK_COMMENT_FOLD_TEXT;
        }
        if (type == RubyElementTypes.ASSOC_LIST) {
            return "{ ... }";
        }
        if (type == RubyElementTypes.ARRAY) {
            return ARRAY_FOLD_TEXT;
        }
        if (type == RubyElementTypes.LBEGIN_STATEMENT) {
            return LBEGIN_FOLD_TEXT;
        }
        if (type == RubyElementTypes.LEND_STATEMENT) {
            return LEND_FOLD_TEXT;
        }
        PsiElement psiElement = node.getPsi();
        if (psiElement instanceof RContainer && !(psiElement instanceof PsiFile)) {
            return " ... end";
        }
        if (psiElement instanceof RBlockStatement) {
            return " ... end";
        }
        if (psiElement instanceof RHeredocId) {
            RHeredocId heredoc = (RHeredocId)psiElement;
            String string = " ... " + heredoc.getId();
            if (string == null) {
                RubyFoldingBuilder.$$$reportNull$$$0(12);
            }
            return string;
        }
        return "...";
    }

    @NotNull
    private static String getLineCommentsPlaceholderText() {
        return COMMENT_FOLD_TEST;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(13);
        }
        return COLLAPSED_BY_DEFAULT.contains(nodeType = node.getElementType()) || nodeType == RubyElementTypes.METHOD && CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(14);
        }
        return node.getElementType() == RubyTokenTypes.TLINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            RubyFoldingBuilder.$$$reportNull$$$0(15);
        }
        IElementType nodeType = node.getElementType();
        return node.getPsi() instanceof RFile || nodeType == RubyElementTypes.CLASS || nodeType == RubyElementTypes.METHOD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/folding/RubyFoldingBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/folding/RubyFoldingBuilder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingTextRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "placeholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingTextRange";
                break;
            }
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleTextOffset";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "placeholderText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 12 -> new IllegalStateException(string);
        };
    }
}

