/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering;

import com.google.common.base.Strings;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.model.impl.YardMacroSymbol;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YardMacroDirective;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.BaseDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RenderedDocumentationText
extends BaseDocumentationItem {
    private static final String SECTIONS_START = "<table class='sections' width='100%'>";
    private static final String SECTIONS_END = "</table>";
    private static final String SECTION_HEADER_START = "<tr><td valign='top' class='section'><p>";
    private static final String SECTION_SEPARATOR = "</p></td><td valign='top' width='100%'>";
    private static final String SECTION_END = "</td></tr>";
    private static final String OVERLOAD_HEADER_START = "<tr><td valign='top' colspan='2'>";
    private static final String OVERLOAD_SEPARATOR = "</td></tr><tr><td valign='top' colspan='2' style='padding-left: 5px;'>";
    private static final String OVERLOAD_END = "</td></tr>";
    private static final String EXAMPLES_HEADER_START = "<tr><td valign='top' colspan='2'>";
    private static final Pattern myBoldPattern = Pattern.compile("\\*(\\S+)\\*");
    private static final Pattern myCodePattern = Pattern.compile("\\+(\\S+)\\+");
    private static final Pattern myCodeTagPattern = Pattern.compile("<code.*?>(.*?)</code>");
    private static final Pattern myTtTagPattern = Pattern.compile("<tt.*?>(.*?)</tt>");
    private static final Pattern myItalicPattern = Pattern.compile("(?:^|(\\s))_(\\S+)_(?:(\\s)|$)");
    private static final Pattern myBigHyphenPattern = Pattern.compile("([^-]|^)(---)([^-]|$)");
    private static final Pattern mySmallHyphenPattern = Pattern.compile("(^|[^-])(--)([^-]|$)");
    private static final Pattern myHorizontalLinePattern = Pattern.compile("^\\s*-{3,}\\s*$");
    private static final Pattern myLinkPattern = Pattern.compile("(^|[^\"])(https?://\\S+)([^\"]|$)");
    private static final Pattern myEscapeTagPattern = Pattern.compile("\\\\<(\\S+)>");
    private static final Pattern myMarkdownLinkPattern = Pattern.compile("(^|[^\\\\])\\{([^{}]+)}\\[([^\\[\\]]+)]");
    private static final Pattern myTrademarkPattern = Pattern.compile("\\(r\\)");
    private static final Pattern myCopyrightPattern = Pattern.compile("\\(c\\)");
    private static final Pattern myEllipsisPattern = Pattern.compile("(^|[^.])\\.\\.\\.([^.]|$)");
    private static final Pattern myRdocHeaderPattern = Pattern.compile("^=+\\s(.*)");
    private static final Pattern myDoubleQuotedPattern = Pattern.compile("(^|\\s)\"([^\"]*)\"(\\s|$)");
    private static final Pattern myBacktickQuotedPattern = Pattern.compile("(^|\\s)``([^`']*)''(\\s|$)");
    private static final Pattern myDoubleBackslashPattern = Pattern.compile("\\\\\\\\");
    private static final Pattern myBackslashPattern = Pattern.compile("\\\\([^ \\n\\t])");
    private static final Pattern myMarkdownHeaderPattern = Pattern.compile("^#+\\s(.*)");
    private static final String NAME_PATTERN = "([^\\s\\]\\[]+)";
    private static final String OPTION_NAME_PATTERN = "(:[^\\s\\]\\[]+)";
    private static final String TYPE_PATTERN = "\\[([^\\[]+)]";
    private static final String DEFAULT_VALUE_PATTERN = "\\(([^\\)]+)\\)";
    private static final String EXAMPLE_TAG = "@example";
    private static final String EXCEPTION_TAG = "@exception";
    private static final String OPTION_TAG = "@option";
    private static final String OVERLOAD_TAG = "@overload";
    private static final String PARAM_TAG = "@param";
    private static final String RAISE_TAG = "@raise";
    private static final String RETURN_TAG = "@return";
    private static final String SEE_TAG = "@see";
    private static final String SINCE_TAG = "@since";
    private static final Map<String, String> TAGS_TO_NAME = Map.ofEntries(Map.entry("@example", "Examples"), Map.entry("@exception", "Exceptions"), Map.entry("@option", "Options"), Map.entry("@overload", "Overload"), Map.entry("@param", "Params"), Map.entry("@raise", "Raises"), Map.entry("@return", "Returns"), Map.entry("@see", "See Also"), Map.entry("@since", "Since"));
    private static final Pattern myOptionsPattern = Pattern.compile(String.format("%s\\s+%s\\s+%s(?:\\s+%s)?(?:(?:\\s+((?:.|[\\n])*))|$)", "([^\\s\\]\\[]+)", "\\[([^\\[]+)]", "(:[^\\s\\]\\[]+)", "\\(([^\\)]+)\\)"));
    private static final Pattern myParamPattern = Pattern.compile(String.format("(?:(?:%s\\s+%s)|(?:%s\\s+%s))(?:(?:\\s+((?:.|[\\n])*))|$)", "([^\\s\\]\\[]+)", "\\[([^\\[]+)]", "\\[([^\\[]+)]", "([^\\s\\]\\[]+)"));
    private static final Pattern myTypePattern = Pattern.compile(String.format("(?:%s)((?:.|[\\n])*)", "\\[([^\\[]+)]"));
    private final Project myProject;
    @Nullable
    private final RContainer myTarget;
    private boolean myEndedByYardTagBlock;

    public RenderedDocumentationText(@NotNull Project project, @Nullable RContainer target) {
        if (project == null) {
            RenderedDocumentationText.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myTarget = target;
    }

    @Override
    public void addLine(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(1);
        }
        super.addLine(line);
        if (line.startsWith("@")) {
            this.myEndedByYardTagBlock = true;
        } else if (RubyDocumentationUtil.getIndent(line) == 0 && !StringUtil.isEmpty((String)line)) {
            this.myEndedByYardTagBlock = false;
        }
    }

    @Override
    @NotNull
    public String getRenderedText(boolean isFirstItem) {
        String string = RubyDocumentationUtil.trimLineBreaks(String.join((CharSequence)"\n", RubyDocumentationUtil.handleLineBreaks(this.processLines(this.getLines()))));
        if (string == null) {
            RenderedDocumentationText.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean hasPriorityToTakeLine(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(3);
        }
        return this.myEndedByYardTagBlock && RubyDocumentationUtil.getIndent(line) > 0;
    }

    @NotNull
    private List<String> processLines(@NotNull List<String> lines) {
        if (lines == null) {
            RenderedDocumentationText.$$$reportNull$$$0(4);
        }
        return RenderedDocumentationText.processRDocHeaderRules(this.processYardRules(this.preprocessMacroTags(lines), SymbolUtil.getSymbolByContainer((RElementWithFQN)this.myTarget)));
    }

    @NotNull
    private List<String> preprocessMacroTags(@NotNull List<String> lines) {
        if (lines == null) {
            RenderedDocumentationText.$$$reportNull$$$0(5);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String line : lines) {
            String name;
            YardMacroSymbol macro;
            String tag = RubyDocumentationUtil.getFirstWord(line);
            if (!YardMacroDirective.isMacroDirective((String)tag)) {
                result.add(line);
                continue;
            }
            if (StringUtil.getWordIndicesIn((String)line, Set.of(Character.valueOf(' '))).size() >= 4 || (macro = (YardMacroSymbol)YardMacroSymbol.find(this.myProject, (SearchScope)searchScope, name = RubyDocumentationUtil.getFirstWord(line.trim().substring(tag.length() + 1))).orElse(null)) == null) continue;
            int indent = RubyDocumentationUtil.getIndent(line);
            List<String> data = macro.getData(this.myProject, (SearchScope)searchScope);
            for (String datum : data) {
                if (this.myTarget instanceof RMethod) {
                    datum = datum.replaceAll("(?<!\\\\)\\$0", this.myTarget.getFQN().getFullPath());
                    List arguments = ((RMethod)this.myTarget).getArguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        datum = datum.replaceAll("(?<!\\\\)\\$" + (i + 1), ((RArgument)arguments.get(i)).getName());
                    }
                }
                result.add(Strings.repeat((String)" ", (int)indent) + datum);
            }
        }
        List<String> list = Collections.unmodifiableList(result);
        if (list == null) {
            RenderedDocumentationText.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<String> processYardRules(@NotNull List<String> lines) {
        if (lines == null) {
            RenderedDocumentationText.$$$reportNull$$$0(7);
        }
        return this.processYardRules(lines, null);
    }

    @NotNull
    private List<String> processYardRules(@NotNull List<String> lines, @Nullable Symbol target) {
        if (lines == null) {
            RenderedDocumentationText.$$$reportNull$$$0(8);
        }
        ArrayList<String> content = new ArrayList<String>();
        ArrayList<String> sections = new ArrayList<String>(List.of(SECTIONS_START));
        int i = 0;
        String currentBlockTitle = null;
        while (i < lines.size()) {
            String originalLine = lines.get(i);
            String line = originalLine.trim();
            StringBuilder itemContent = new StringBuilder(line);
            if (line.startsWith("@")) {
                int j;
                String tag = RubyDocumentationUtil.getFirstWord(line);
                String blockTitle = this.getBlockTitle(line, tag);
                int blockIndent = RubyDocumentationUtil.getIndent(originalLine);
                if (tag.equals(OVERLOAD_TAG)) {
                    ArrayList<String> overloadLines = new ArrayList<String>();
                    ++i;
                    while (i < lines.size() && (RubyDocumentationUtil.getIndent(lines.get(i)) > blockIndent || StringUtil.isEmpty((String)lines.get(i)))) {
                        overloadLines.add(lines.get(i));
                        ++i;
                    }
                    sections.addAll(List.of("<tr><td valign='top' colspan='2'>", blockTitle + " " + this.processInlineCode(line.substring(tag.length())), OVERLOAD_SEPARATOR));
                    sections.addAll(this.processYardRules(overloadLines));
                    sections.add("</td></tr>");
                    continue;
                }
                if (!(currentBlockTitle == null || RenderedDocumentationText.isBlockRequiredForTag(tag) && Objects.equals(blockTitle, currentBlockTitle))) {
                    sections.add("</td></tr>");
                    currentBlockTitle = null;
                }
                if (RenderedDocumentationText.isBlockRequiredForTag(tag) && currentBlockTitle == null) {
                    sections.add(String.format("%s%s:%s", SECTION_HEADER_START, blockTitle, SECTION_SEPARATOR));
                    currentBlockTitle = blockTitle;
                }
                for (j = i + 1; j < lines.size() && (RubyDocumentationUtil.getIndent(lines.get(j)) > blockIndent || StringUtil.isEmpty((String)lines.get(j))); ++j) {
                    itemContent.append("\n").append(lines.get(j));
                }
                i = j - 1;
                String itemContentString = itemContent.toString();
                if (currentBlockTitle != null) {
                    String yamlTagContent = RenderedDocumentationText.cutTagPrefix(itemContentString.trim());
                    if (line.startsWith(PARAM_TAG)) {
                        sections.addAll(this.processParametersTag(yamlTagContent));
                    } else if (line.startsWith(RETURN_TAG) || line.startsWith(EXCEPTION_TAG) || line.startsWith(RAISE_TAG)) {
                        sections.addAll(this.processTypeTag(yamlTagContent));
                    } else if (line.startsWith(EXAMPLE_TAG)) {
                        sections.addAll(RenderedDocumentationText.processExampleTag(itemContentString));
                    } else if (line.startsWith(OPTION_TAG)) {
                        sections.addAll(this.processOptionTag(yamlTagContent));
                    } else {
                        sections.addAll(List.of(RenderedDocumentationText.processRDocRules(itemContentString.substring(tag.length()), target), "<br/>"));
                    }
                } else {
                    sections.add(RenderedDocumentationText.renderYardTag(itemContentString));
                }
            } else {
                content.add(RenderedDocumentationText.processRDocRules(originalLine, target));
            }
            ++i;
        }
        if (currentBlockTitle != null) {
            sections.add("</td></tr>");
        }
        sections.add(SECTIONS_END);
        List list = ContainerUtil.concat(content, sections.size() > 2 ? sections : Collections.emptyList());
        if (list == null) {
            RenderedDocumentationText.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<String> processExampleTag(@NotNull String tagContent) {
        if (tagContent == null) {
            RenderedDocumentationText.$$$reportNull$$$0(10);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("</td></tr>");
        sb.append("<tr><td valign='top' colspan='2'>");
        String code = tagContent.substring(EXAMPLE_TAG.length());
        int endOfTheFirstLineOffset = code.indexOf(10);
        String title = "";
        if (endOfTheFirstLineOffset >= 0) {
            title = code.substring(0, endOfTheFirstLineOffset);
            code = code.substring(endOfTheFirstLineOffset);
        }
        if (!title.isBlank()) {
            sb.append(title).append("<br/>");
        }
        List<String> lines = List.of(StringUtil.trim((String)code, ch -> ch != '\n').split("\n"));
        RenderedDocumentationCodeBlock codeBlock = new RenderedDocumentationCodeBlock();
        for (String codeLine : lines) {
            codeBlock.addLine(codeLine);
        }
        sb.append(codeBlock.getRenderedText(false));
        List<String> list = List.of(sb.toString());
        if (list == null) {
            RenderedDocumentationText.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static String getCaptionFromYardTag(@NotNull String yardTag) {
        if (yardTag == null) {
            RenderedDocumentationText.$$$reportNull$$$0(12);
        }
        String word = yardTag.substring(1);
        String string = StringUtil.capitalize((String)word);
        if (string == null) {
            RenderedDocumentationText.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String renderYardTag(@NotNull String text) {
        if (text == null) {
            RenderedDocumentationText.$$$reportNull$$$0(14);
        }
        String tag = RubyDocumentationUtil.getFirstWord(text);
        String string = SECTION_HEADER_START + RenderedDocumentationText.getCaptionFromYardTag(tag) + ":</p></td><td valign='top' width='100%'>" + RenderedDocumentationText.processRDocRules(text.substring(tag.length())) + "</td></tr>";
        if (string == null) {
            RenderedDocumentationText.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private List<String> processParametersTag(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(16);
        }
        StringBuilder sb = new StringBuilder();
        Matcher paramMatcher = myParamPattern.matcher(line);
        if (paramMatcher.matches()) {
            String name = paramMatcher.group(1) != null ? paramMatcher.group(1) : paramMatcher.group(4);
            String type = paramMatcher.group(2) != null ? paramMatcher.group(2) : paramMatcher.group(3);
            String description = paramMatcher.group(5);
            if (name != null) {
                sb.append(this.processInlineCode(name)).append("&nbsp;");
            }
            if (type != null) {
                sb.append("(").append(this.processInlineCode(type)).append(")&nbsp;");
            }
            if (description != null) {
                sb.append("&mdash; ").append(RenderedDocumentationText.processRDocRules(description));
            }
            sb.append("<br/>");
        } else {
            sb.append(RenderedDocumentationText.processRDocRules(line)).append("<br/>");
        }
        List<String> list = List.of(sb.toString());
        if (list == null) {
            RenderedDocumentationText.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private List<String> processOptionTag(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(18);
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = myOptionsPattern.matcher(line);
        if (!matcher.matches()) {
            List<String> list = List.of(line, "<br/>");
            if (list == null) {
                RenderedDocumentationText.$$$reportNull$$$0(19);
            }
            return list;
        }
        String type = StringUtil.nullize((String)matcher.group(2), (boolean)true);
        String optionName = StringUtil.nullize((String)matcher.group(3), (boolean)true);
        String defaultValue = StringUtil.nullize((String)matcher.group(4), (boolean)true);
        String description = StringUtil.nullize((String)matcher.group(5), (boolean)true);
        if (optionName != null) {
            sb.append(this.processInlineCode(optionName + (String)(defaultValue != null ? " => " + defaultValue : ""))).append("&nbsp;");
        }
        if (type != null) {
            sb.append("(").append(this.processInlineCode(type)).append(")&nbsp;");
        }
        if (description != null) {
            sb.append("&mdash; ").append(RenderedDocumentationText.processRDocRules(description));
        }
        sb.append("<br/>");
        List<String> list = List.of(sb.toString());
        if (list == null) {
            RenderedDocumentationText.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private List<String> processTypeTag(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(21);
        }
        StringBuilder sb = new StringBuilder();
        Matcher typeMatcher = myTypePattern.matcher(line);
        if (typeMatcher.matches()) {
            String type = typeMatcher.group(1);
            String description = RenderedDocumentationText.processRDocRules(typeMatcher.group(2));
            sb.append("(").append(this.processInlineCode(type)).append(")&nbsp;");
            if (StringUtil.isNotEmpty((String)description)) {
                sb.append("&mdash; ").append(description);
            }
            sb.append("<br/>");
        } else {
            sb.append(line).append("<br/>");
        }
        List<String> list = List.of(sb.toString());
        if (list == null) {
            RenderedDocumentationText.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static String cutTagPrefix(@NotNull String line) {
        int i;
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(23);
        }
        for (i = 0; i < line.length() && !Character.isWhitespace(line.charAt(i)); ++i) {
        }
        while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        return line.substring(i);
    }

    @Nullable
    private String getBlockTitle(@NotNull String line, @NotNull String tag) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(24);
        }
        if (tag == null) {
            RenderedDocumentationText.$$$reportNull$$$0(25);
        }
        String name = TAGS_TO_NAME.get(tag);
        String details = OPTION_TAG.equals(tag) ? String.format("(%s)", this.processInlineCode(RubyDocumentationUtil.getFirstWord(line.substring(tag.length())))) : "";
        return name != null ? String.format("%s %s", name, details).trim() : null;
    }

    private static boolean isBlockRequiredForTag(@NotNull String tag) {
        if (tag == null) {
            RenderedDocumentationText.$$$reportNull$$$0(26);
        }
        return TAGS_TO_NAME.containsKey(tag);
    }

    @Contract(value="!null -> !null; null -> null")
    @Nullable
    private static String processRDocRules(@Nullable String line) {
        return RenderedDocumentationText.processRDocRules(line, null);
    }

    @Contract(value="!null, _ -> !null; null, _ -> null")
    @Nullable
    private static String processRDocRules(@Nullable String line, @Nullable Symbol target) {
        if (line == null) {
            return null;
        }
        String processedLine = line;
        processedLine = myDoubleQuotedPattern.matcher(processedLine).replaceAll("$1\u201c$2\u201d$3");
        processedLine = myBacktickQuotedPattern.matcher(processedLine).replaceAll("$1\u201c$2''$3");
        processedLine = myBoldPattern.matcher(processedLine).replaceAll("<b>$1</b>");
        processedLine = myItalicPattern.matcher(processedLine).replaceAll("$1<i>$2</i>$3");
        processedLine = RubyDocumentationMarkupUtil.escapeTags(processedLine);
        processedLine = myEscapeTagPattern.matcher(processedLine).replaceAll("&lt;$1&gt;");
        processedLine = myHorizontalLinePattern.matcher(processedLine).replaceAll("<hr>");
        processedLine = myBigHyphenPattern.matcher(processedLine).replaceAll("$1\u2014$3");
        processedLine = mySmallHyphenPattern.matcher(processedLine).replaceAll("$1\u2013$3");
        processedLine = myMarkdownLinkPattern.matcher(processedLine).replaceAll("$1<a href=\"$3\">$2</a>");
        processedLine = myLinkPattern.matcher(processedLine).replaceAll("$1<a href=\"$2\">$2</a>$3");
        processedLine = myTrademarkPattern.matcher(processedLine).replaceAll("\u00ae");
        processedLine = myCopyrightPattern.matcher(processedLine).replaceAll("\u00a9");
        processedLine = myEllipsisPattern.matcher(processedLine).replaceAll("$1\u2026$2");
        processedLine = RubyDocumentationMarkupUtil.applyHighlightingToLine(processedLine, target);
        Function<MatchResult, String> replacer = match -> RenderedDocumentationText.processInlineCodeWithoutEscaping(match.group(1).replace("\\", "\\\\").replace("$", "\\$")).replace("\\\\", "&bsol;");
        processedLine = myCodePattern.matcher(processedLine).replaceAll(replacer);
        processedLine = myCodeTagPattern.matcher(processedLine).replaceAll(replacer);
        processedLine = myTtTagPattern.matcher(processedLine).replaceAll(replacer);
        processedLine = myDoubleBackslashPattern.matcher(processedLine).replaceAll("&bsol;");
        processedLine = myBackslashPattern.matcher(processedLine).replaceAll("$1");
        return processedLine;
    }

    @NotNull
    private String processInlineCode(@NotNull String code) {
        if (code == null) {
            RenderedDocumentationText.$$$reportNull$$$0(27);
        }
        String string = QuickDocHighlightingHelper.getStyledInlineCode((Project)this.myProject, (Language)RubyLanguage.INSTANCE, (String)code);
        if (string == null) {
            RenderedDocumentationText.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String processInlineCodeWithoutEscaping(@NotNull String code) {
        if (code == null) {
            RenderedDocumentationText.$$$reportNull$$$0(29);
        }
        String string = QuickDocHighlightingHelper.wrapWithInlineCodeTag((String)code);
        if (string == null) {
            RenderedDocumentationText.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static List<String> processRDocHeaderRules(@NotNull List<String> lines) {
        if (lines == null) {
            RenderedDocumentationText.$$$reportNull$$$0(31);
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean isPrecededByHeader = false;
        for (String line : lines) {
            if (isPrecededByHeader && RenderedDocumentationText.isLineBreak(line)) continue;
            isPrecededByHeader = false;
            if (RenderedDocumentationText.handleHeader(line, result, myRdocHeaderPattern, '=') || RenderedDocumentationText.handleHeader(line, result, myMarkdownHeaderPattern, '#')) {
                isPrecededByHeader = true;
                continue;
            }
            result.add(line);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            RenderedDocumentationText.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private static boolean handleHeader(@NotNull String line, @NotNull List<String> resultLines, @NotNull Pattern headerPattern, char headerChar) {
        Matcher matcher;
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(33);
        }
        if (resultLines == null) {
            RenderedDocumentationText.$$$reportNull$$$0(34);
        }
        if (headerPattern == null) {
            RenderedDocumentationText.$$$reportNull$$$0(35);
        }
        if ((matcher = headerPattern.matcher(line)).matches()) {
            int i;
            RubyDocumentationUtil.ensurePaddingAfterUpperElement(resultLines);
            for (i = 0; i < line.length() && line.charAt(i) == headerChar; ++i) {
            }
            resultLines.add("<h" + (i + 1) + ">" + Matcher.quoteReplacement(line.substring(i).trim()) + "</h" + (i + 1) + ">");
            return true;
        }
        return false;
    }

    public static boolean isLineBreak(@NotNull String line) {
        if (line == null) {
            RenderedDocumentationText.$$$reportNull$$$0(36);
        }
        return "<br/>".equals(line) || StringUtil.isEmpty((String)line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 9, 11, 13, 15, 17, 19, 20, 22, 28, 30, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/RenderedDocumentationText";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagContent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yardTag";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultLines";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/RenderedDocumentationText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessMacroTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processYardRules";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processExampleTag";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptionFromYardTag";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "renderYardTag";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processParametersTag";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "processOptionTag";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "processTypeTag";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "processInlineCode";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "processInlineCodeWithoutEscaping";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "processRDocHeaderRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addLine";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasPriorityToTakeLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessMacroTags";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processYardRules";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processExampleTag";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCaptionFromYardTag";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renderYardTag";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processParametersTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processOptionTag";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processTypeTag";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "cutTagPrefix";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBlockTitle";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isBlockRequiredForTag";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processInlineCode";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processInlineCodeWithoutEscaping";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processRDocHeaderRules";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "handleHeader";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isLineBreak";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 9, 11, 13, 15, 17, 19, 20, 22, 28, 30, 32 -> new IllegalStateException(string);
        };
    }
}

