/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.BaseDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationList;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationText;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class CompositeDocumentationItem
extends BaseDocumentationItem {
    private static final String EXCLUDED_START_MARKER = "--";
    private static final String EXCLUDED_END_MARKER = "++";
    private final Project myProject;
    @Nullable
    private final RContainer myTarget;

    public CompositeDocumentationItem(@NotNull Project project, @NotNull List<String> lines, @Nullable RContainer target) {
        if (project == null) {
            CompositeDocumentationItem.$$$reportNull$$$0(0);
        }
        if (lines == null) {
            CompositeDocumentationItem.$$$reportNull$$$0(1);
        }
        super(lines);
        this.myProject = project;
        this.myTarget = target;
    }

    @Override
    @NotNull
    public String getRenderedText(boolean isFirstItem) {
        List<String> lines = RubyDocumentationUtil.cutCommonIndent(this.getLines());
        List<RenderedDocumentationItem> documentationItems = this.buildRenderedDocumentationStructure(lines);
        StringBuilder result = new StringBuilder();
        RenderedDocumentationItem previous = null;
        for (int i = 0; i < documentationItems.size(); ++i) {
            RenderedDocumentationItem item = documentationItems.get(i);
            if (previous != null) {
                result.append("\n");
            }
            if (item instanceof RenderedDocumentationText && previous instanceof RenderedDocumentationCodeBlock) {
                result.append("<br/>").append("\n");
            } else if (item instanceof RenderedDocumentationCodeBlock && previous instanceof RenderedDocumentationText) {
                result.append("<br/>").append("\n");
                result.append("<br/>").append("\n");
            }
            String html = item.getRenderedText(i == 0);
            result.append(html);
            previous = item;
        }
        String string = result.toString();
        if (string == null) {
            CompositeDocumentationItem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<RenderedDocumentationItem> buildRenderedDocumentationStructure(@NotNull List<String> docCommentLines) {
        if (docCommentLines == null) {
            CompositeDocumentationItem.$$$reportNull$$$0(3);
        }
        ArrayList<RenderedDocumentationItem> result = new ArrayList<RenderedDocumentationItem>();
        RenderedDocumentationItem lastItem = null;
        boolean commentDocumentation = false;
        for (int i = 0; i < docCommentLines.size(); ++i) {
            String line = docCommentLines.get(i);
            if (EXCLUDED_START_MARKER.equals(line)) {
                commentDocumentation = true;
            }
            if (commentDocumentation) {
                if (!EXCLUDED_END_MARKER.equals(line)) continue;
                commentDocumentation = false;
                continue;
            }
            if (line.trim().isEmpty()) {
                if (lastItem == null) continue;
                lastItem.addLine("");
                continue;
            }
            if (lastItem != null && lastItem.hasPriorityToTakeLine(line)) {
                lastItem.addLine(line);
                continue;
            }
            if (lastItem instanceof RenderedDocumentationList) {
                lastItem = null;
            }
            if (RubyDocumentationUtil.isListBlockStarts(docCommentLines.get(i))) {
                lastItem = new RenderedDocumentationList(this.myProject, this.myTarget);
                result.add(lastItem);
            } else if (Character.isWhitespace(line.charAt(0)) && !(lastItem instanceof RenderedDocumentationCodeBlock)) {
                lastItem = new RenderedDocumentationCodeBlock();
                result.add(lastItem);
            } else if (!(Character.isWhitespace(line.charAt(0)) && (lastItem != null || result.isEmpty()) || lastItem instanceof RenderedDocumentationText)) {
                lastItem = new RenderedDocumentationText(this.myProject, this.myTarget);
                result.add(lastItem);
            }
            if (lastItem == null) {
                lastItem = new RenderedDocumentationText(this.myProject, this.myTarget);
                result.add(lastItem);
            }
            lastItem.addLine(line);
        }
        ArrayList<RenderedDocumentationItem> arrayList = result;
        if (arrayList == null) {
            CompositeDocumentationItem.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/CompositeDocumentationItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docCommentLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/rendering/CompositeDocumentationItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRenderedDocumentationStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildRenderedDocumentationStructure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

